<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for markPaymentTerminal StructType
 * Meta information extracted from the WSDL
 * - type: tns:markPaymentTerminal
 * @subpackage Structs
 */
class MarkPaymentTerminal extends AbstractStructBase
{
    /**
     * The referenceNO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $referenceNO;
    /**
     * The PolicyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PolicyId;
    /**
     * Constructor method for markPaymentTerminal
     * @uses MarkPaymentTerminal::setReferenceNO()
     * @uses MarkPaymentTerminal::setPolicyId()
     * @param string $referenceNO
     * @param int $policyId
     */
    public function __construct($referenceNO = null, $policyId = null)
    {
        $this
            ->setReferenceNO($referenceNO)
            ->setPolicyId($policyId);
    }
    /**
     * Get referenceNO value
     * @return string|null
     */
    public function getReferenceNO()
    {
        return $this->referenceNO;
    }
    /**
     * Set referenceNO value
     * @param string $referenceNO
     * @return \App\Insis\StructType\MarkPaymentTerminal
     */
    public function setReferenceNO($referenceNO = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNO) && !is_string($referenceNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNO, true), gettype($referenceNO)), __LINE__);
        }
        $this->referenceNO = $referenceNO;
        return $this;
    }
    /**
     * Get PolicyId value
     * @return int|null
     */
    public function getPolicyId()
    {
        return $this->PolicyId;
    }
    /**
     * Set PolicyId value
     * @param int $policyId
     * @return \App\Insis\StructType\MarkPaymentTerminal
     */
    public function setPolicyId($policyId = null)
    {
        // validation for constraint: int
        if (!is_null($policyId) && !(is_int($policyId) || ctype_digit($policyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyId, true), gettype($policyId)), __LINE__);
        }
        $this->PolicyId = $policyId;
        return $this;
    }
}
