<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for markPayment StructType
 * Meta information extracted from the WSDL
 * - type: tns:markPayment
 * @subpackage Structs
 */
class MarkPayment extends AbstractStructBase
{
    /**
     * The aBillNO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aBillNO;
    /**
     * The aPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Insis\StructType\Payment
     */
    public $aPayment;
    /**
     * The aClientBIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aClientBIN;
    /**
     * The aUniqueCheckPaymentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aUniqueCheckPaymentID;
    /**
     * Constructor method for markPayment
     * @uses MarkPayment::setABillNO()
     * @uses MarkPayment::setAPayment()
     * @uses MarkPayment::setAClientBIN()
     * @uses MarkPayment::setAUniqueCheckPaymentID()
     * @param string $aBillNO
     * @param \App\Insis\StructType\Payment $aPayment
     * @param string $aClientBIN
     * @param int $aUniqueCheckPaymentID
     */
    public function __construct($aBillNO = null, \App\Insis\StructType\Payment $aPayment = null, $aClientBIN = null, $aUniqueCheckPaymentID = null)
    {
        $this
            ->setABillNO($aBillNO)
            ->setAPayment($aPayment)
            ->setAClientBIN($aClientBIN)
            ->setAUniqueCheckPaymentID($aUniqueCheckPaymentID);
    }
    /**
     * Get aBillNO value
     * @return string|null
     */
    public function getABillNO()
    {
        return $this->aBillNO;
    }
    /**
     * Set aBillNO value
     * @param string $aBillNO
     * @return \App\Insis\StructType\MarkPayment
     */
    public function setABillNO($aBillNO = null)
    {
        // validation for constraint: string
        if (!is_null($aBillNO) && !is_string($aBillNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aBillNO, true), gettype($aBillNO)), __LINE__);
        }
        $this->aBillNO = $aBillNO;
        return $this;
    }
    /**
     * Get aPayment value
     * @return \App\Insis\StructType\Payment|null
     */
    public function getAPayment()
    {
        return $this->aPayment;
    }
    /**
     * Set aPayment value
     * @param \App\Insis\StructType\Payment $aPayment
     * @return \App\Insis\StructType\MarkPayment
     */
    public function setAPayment(\App\Insis\StructType\Payment $aPayment = null)
    {
        $this->aPayment = $aPayment;
        return $this;
    }
    /**
     * Get aClientBIN value
     * @return string|null
     */
    public function getAClientBIN()
    {
        return $this->aClientBIN;
    }
    /**
     * Set aClientBIN value
     * @param string $aClientBIN
     * @return \App\Insis\StructType\MarkPayment
     */
    public function setAClientBIN($aClientBIN = null)
    {
        // validation for constraint: string
        if (!is_null($aClientBIN) && !is_string($aClientBIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aClientBIN, true), gettype($aClientBIN)), __LINE__);
        }
        $this->aClientBIN = $aClientBIN;
        return $this;
    }
    /**
     * Get aUniqueCheckPaymentID value
     * @return int|null
     */
    public function getAUniqueCheckPaymentID()
    {
        return $this->aUniqueCheckPaymentID;
    }
    /**
     * Set aUniqueCheckPaymentID value
     * @param int $aUniqueCheckPaymentID
     * @return \App\Insis\StructType\MarkPayment
     */
    public function setAUniqueCheckPaymentID($aUniqueCheckPaymentID = null)
    {
        // validation for constraint: int
        if (!is_null($aUniqueCheckPaymentID) && !(is_int($aUniqueCheckPaymentID) || ctype_digit($aUniqueCheckPaymentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aUniqueCheckPaymentID, true), gettype($aUniqueCheckPaymentID)), __LINE__);
        }
        $this->aUniqueCheckPaymentID = $aUniqueCheckPaymentID;
        return $this;
    }
}
