<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for idCard StructType
 * @subpackage Structs
 */
class IdCard extends AbstractStructBase
{
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The issueAuthor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issueAuthor;
    /**
     * The issueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issueDate;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The typen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $typen;
    /**
     * Constructor method for idCard
     * @uses IdCard::setEndDate()
     * @uses IdCard::setIssueAuthor()
     * @uses IdCard::setIssueDate()
     * @uses IdCard::setNumber()
     * @uses IdCard::setTypen()
     * @param string $endDate
     * @param string $issueAuthor
     * @param string $issueDate
     * @param string $number
     * @param string $typen
     */
    public function __construct($endDate = null, $issueAuthor = null, $issueDate = null, $number = null, $typen = null)
    {
        $this
            ->setEndDate($endDate)
            ->setIssueAuthor($issueAuthor)
            ->setIssueDate($issueDate)
            ->setNumber($number)
            ->setTypen($typen);
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \App\Insis\StructType\IdCard
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get issueAuthor value
     * @return string|null
     */
    public function getIssueAuthor()
    {
        return $this->issueAuthor;
    }
    /**
     * Set issueAuthor value
     * @param string $issueAuthor
     * @return \App\Insis\StructType\IdCard
     */
    public function setIssueAuthor($issueAuthor = null)
    {
        // validation for constraint: string
        if (!is_null($issueAuthor) && !is_string($issueAuthor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueAuthor, true), gettype($issueAuthor)), __LINE__);
        }
        $this->issueAuthor = $issueAuthor;
        return $this;
    }
    /**
     * Get issueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->issueDate;
    }
    /**
     * Set issueDate value
     * @param string $issueDate
     * @return \App\Insis\StructType\IdCard
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->issueDate = $issueDate;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \App\Insis\StructType\IdCard
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get typen value
     * @return string|null
     */
    public function getTypen()
    {
        return $this->typen;
    }
    /**
     * Set typen value
     * @param string $typen
     * @return \App\Insis\StructType\IdCard
     */
    public function setTypen($typen = null)
    {
        // validation for constraint: string
        if (!is_null($typen) && !is_string($typen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typen, true), gettype($typen)), __LINE__);
        }
        $this->typen = $typen;
        return $this;
    }
}
