<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for hcsbkInsurer StructType
 * @subpackage Structs
 */
class HcsbkInsurer extends AbstractStructBase
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The bik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bik;
    /**
     * The bin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bin;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The iban
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iban;
    /**
     * The iik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iik;
    /**
     * The isResident
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $isResident;
    /**
     * The kbe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kbe;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The rnn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rnn;
    /**
     * The sectorEconom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sectorEconom;
    /**
     * The swift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $swift;
    /**
     * Constructor method for hcsbkInsurer
     * @uses HcsbkInsurer::setAddress()
     * @uses HcsbkInsurer::setBik()
     * @uses HcsbkInsurer::setBin()
     * @uses HcsbkInsurer::setFax()
     * @uses HcsbkInsurer::setIban()
     * @uses HcsbkInsurer::setIik()
     * @uses HcsbkInsurer::setIsResident()
     * @uses HcsbkInsurer::setKbe()
     * @uses HcsbkInsurer::setName()
     * @uses HcsbkInsurer::setPhone()
     * @uses HcsbkInsurer::setRnn()
     * @uses HcsbkInsurer::setSectorEconom()
     * @uses HcsbkInsurer::setSwift()
     * @param string $address
     * @param string $bik
     * @param string $bin
     * @param string $fax
     * @param string $iban
     * @param string $iik
     * @param int $isResident
     * @param string $kbe
     * @param string $name
     * @param string $phone
     * @param string $rnn
     * @param string $sectorEconom
     * @param string $swift
     */
    public function __construct($address = null, $bik = null, $bin = null, $fax = null, $iban = null, $iik = null, $isResident = null, $kbe = null, $name = null, $phone = null, $rnn = null, $sectorEconom = null, $swift = null)
    {
        $this
            ->setAddress($address)
            ->setBik($bik)
            ->setBin($bin)
            ->setFax($fax)
            ->setIban($iban)
            ->setIik($iik)
            ->setIsResident($isResident)
            ->setKbe($kbe)
            ->setName($name)
            ->setPhone($phone)
            ->setRnn($rnn)
            ->setSectorEconom($sectorEconom)
            ->setSwift($swift);
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \App\Insis\StructType\HcsbkInsurer
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get bik value
     * @return string|null
     */
    public function getBik()
    {
        return $this->bik;
    }
    /**
     * Set bik value
     * @param string $bik
     * @return \App\Insis\StructType\HcsbkInsurer
     */
    public function setBik($bik = null)
    {
        // validation for constraint: string
        if (!is_null($bik) && !is_string($bik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bik, true), gettype($bik)), __LINE__);
        }
        $this->bik = $bik;
        return $this;
    }
    /**
     * Get bin value
     * @return string|null
     */
    public function getBin()
    {
        return $this->bin;
    }
    /**
     * Set bin value
     * @param string $bin
     * @return \App\Insis\StructType\HcsbkInsurer
     */
    public function setBin($bin = null)
    {
        // validation for constraint: string
        if (!is_null($bin) && !is_string($bin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bin, true), gettype($bin)), __LINE__);
        }
        $this->bin = $bin;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \App\Insis\StructType\HcsbkInsurer
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \App\Insis\StructType\HcsbkInsurer
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Get iik value
     * @return string|null
     */
    public function getIik()
    {
        return $this->iik;
    }
    /**
     * Set iik value
     * @param string $iik
     * @return \App\Insis\StructType\HcsbkInsurer
     */
    public function setIik($iik = null)
    {
        // validation for constraint: string
        if (!is_null($iik) && !is_string($iik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iik, true), gettype($iik)), __LINE__);
        }
        $this->iik = $iik;
        return $this;
    }
    /**
     * Get isResident value
     * @return int|null
     */
    public function getIsResident()
    {
        return $this->isResident;
    }
    /**
     * Set isResident value
     * @param int $isResident
     * @return \App\Insis\StructType\HcsbkInsurer
     */
    public function setIsResident($isResident = null)
    {
        // validation for constraint: int
        if (!is_null($isResident) && !(is_int($isResident) || ctype_digit($isResident))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isResident, true), gettype($isResident)), __LINE__);
        }
        $this->isResident = $isResident;
        return $this;
    }
    /**
     * Get kbe value
     * @return string|null
     */
    public function getKbe()
    {
        return $this->kbe;
    }
    /**
     * Set kbe value
     * @param string $kbe
     * @return \App\Insis\StructType\HcsbkInsurer
     */
    public function setKbe($kbe = null)
    {
        // validation for constraint: string
        if (!is_null($kbe) && !is_string($kbe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kbe, true), gettype($kbe)), __LINE__);
        }
        $this->kbe = $kbe;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Insis\StructType\HcsbkInsurer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \App\Insis\StructType\HcsbkInsurer
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get rnn value
     * @return string|null
     */
    public function getRnn()
    {
        return $this->rnn;
    }
    /**
     * Set rnn value
     * @param string $rnn
     * @return \App\Insis\StructType\HcsbkInsurer
     */
    public function setRnn($rnn = null)
    {
        // validation for constraint: string
        if (!is_null($rnn) && !is_string($rnn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rnn, true), gettype($rnn)), __LINE__);
        }
        $this->rnn = $rnn;
        return $this;
    }
    /**
     * Get sectorEconom value
     * @return string|null
     */
    public function getSectorEconom()
    {
        return $this->sectorEconom;
    }
    /**
     * Set sectorEconom value
     * @param string $sectorEconom
     * @return \App\Insis\StructType\HcsbkInsurer
     */
    public function setSectorEconom($sectorEconom = null)
    {
        // validation for constraint: string
        if (!is_null($sectorEconom) && !is_string($sectorEconom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorEconom, true), gettype($sectorEconom)), __LINE__);
        }
        $this->sectorEconom = $sectorEconom;
        return $this;
    }
    /**
     * Get swift value
     * @return string|null
     */
    public function getSwift()
    {
        return $this->swift;
    }
    /**
     * Set swift value
     * @param string $swift
     * @return \App\Insis\StructType\HcsbkInsurer
     */
    public function setSwift($swift = null)
    {
        // validation for constraint: string
        if (!is_null($swift) && !is_string($swift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($swift, true), gettype($swift)), __LINE__);
        }
        $this->swift = $swift;
        return $this;
    }
}
