<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for hcsbkClient StructType
 * @subpackage Structs
 */
class HcsbkClient extends AbstractStructBase
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The birthDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $birthDate;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The fullName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fullName;
    /**
     * The idCard
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\IdCard[]
     */
    public $idCard;
    /**
     * The iin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iin;
    /**
     * The isResident
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $isResident;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The mobilePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mobilePhone;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The sectorEconom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sectorEconom;
    /**
     * Constructor method for hcsbkClient
     * @uses HcsbkClient::setAddress()
     * @uses HcsbkClient::setBirthDate()
     * @uses HcsbkClient::setEmail()
     * @uses HcsbkClient::setFirstName()
     * @uses HcsbkClient::setFullName()
     * @uses HcsbkClient::setIdCard()
     * @uses HcsbkClient::setIin()
     * @uses HcsbkClient::setIsResident()
     * @uses HcsbkClient::setLastName()
     * @uses HcsbkClient::setMiddleName()
     * @uses HcsbkClient::setMobilePhone()
     * @uses HcsbkClient::setPhone()
     * @uses HcsbkClient::setSectorEconom()
     * @param string $address
     * @param string $birthDate
     * @param string $email
     * @param string $firstName
     * @param string $fullName
     * @param \App\Insis\StructType\IdCard[] $idCard
     * @param string $iin
     * @param string $isResident
     * @param string $lastName
     * @param string $middleName
     * @param string $mobilePhone
     * @param string $phone
     * @param string $sectorEconom
     */
    public function __construct($address = null, $birthDate = null, $email = null, $firstName = null, $fullName = null, array $idCard = array(), $iin = null, $isResident = null, $lastName = null, $middleName = null, $mobilePhone = null, $phone = null, $sectorEconom = null)
    {
        $this
            ->setAddress($address)
            ->setBirthDate($birthDate)
            ->setEmail($email)
            ->setFirstName($firstName)
            ->setFullName($fullName)
            ->setIdCard($idCard)
            ->setIin($iin)
            ->setIsResident($isResident)
            ->setLastName($lastName)
            ->setMiddleName($middleName)
            ->setMobilePhone($mobilePhone)
            ->setPhone($phone)
            ->setSectorEconom($sectorEconom);
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get idCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\IdCard[]|null
     */
    public function getIdCard()
    {
        return isset($this->idCard) ? $this->idCard : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIdCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdCard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdCardForArrayConstraintsFromSetIdCard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hcsbkClientIdCardItem) {
            // validation for constraint: itemType
            if (!$hcsbkClientIdCardItem instanceof \App\Insis\StructType\IdCard) {
                $invalidValues[] = is_object($hcsbkClientIdCardItem) ? get_class($hcsbkClientIdCardItem) : sprintf('%s(%s)', gettype($hcsbkClientIdCardItem), var_export($hcsbkClientIdCardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idCard property can only contain items of type \App\Insis\StructType\IdCard, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\IdCard[] $idCard
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function setIdCard(array $idCard = array())
    {
        // validation for constraint: array
        if ('' !== ($idCardArrayErrorMessage = self::validateIdCardForArrayConstraintsFromSetIdCard($idCard))) {
            throw new \InvalidArgumentException($idCardArrayErrorMessage, __LINE__);
        }
        if (is_null($idCard) || (is_array($idCard) && empty($idCard))) {
            unset($this->idCard);
        } else {
            $this->idCard = $idCard;
        }
        return $this;
    }
    /**
     * Add item to idCard value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\IdCard $item
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function addToIdCard(\App\Insis\StructType\IdCard $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\IdCard) {
            throw new \InvalidArgumentException(sprintf('The idCard property can only contain items of type \App\Insis\StructType\IdCard, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idCard[] = $item;
        return $this;
    }
    /**
     * Get iin value
     * @return string|null
     */
    public function getIin()
    {
        return $this->iin;
    }
    /**
     * Set iin value
     * @param string $iin
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function setIin($iin = null)
    {
        // validation for constraint: string
        if (!is_null($iin) && !is_string($iin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iin, true), gettype($iin)), __LINE__);
        }
        $this->iin = $iin;
        return $this;
    }
    /**
     * Get isResident value
     * @return string|null
     */
    public function getIsResident()
    {
        return $this->isResident;
    }
    /**
     * Set isResident value
     * @param string $isResident
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function setIsResident($isResident = null)
    {
        // validation for constraint: string
        if (!is_null($isResident) && !is_string($isResident)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isResident, true), gettype($isResident)), __LINE__);
        }
        $this->isResident = $isResident;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get mobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->mobilePhone;
    }
    /**
     * Set mobilePhone value
     * @param string $mobilePhone
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        $this->mobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get sectorEconom value
     * @return string|null
     */
    public function getSectorEconom()
    {
        return $this->sectorEconom;
    }
    /**
     * Set sectorEconom value
     * @param string $sectorEconom
     * @return \App\Insis\StructType\HcsbkClient
     */
    public function setSectorEconom($sectorEconom = null)
    {
        // validation for constraint: string
        if (!is_null($sectorEconom) && !is_string($sectorEconom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorEconom, true), gettype($sectorEconom)), __LINE__);
        }
        $this->sectorEconom = $sectorEconom;
        return $this;
    }
}
