<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getReport StructType
 * Meta information extracted from the WSDL
 * - type: tns:getReport
 * @subpackage Structs
 */
class GetReport extends AbstractStructBase
{
    /**
     * The aUserID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aUserID;
    /**
     * The aReportID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aReportID;
    /**
     * The aParams
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\ReportParam[]
     */
    public $aParams;
    /**
     * Constructor method for getReport
     * @uses GetReport::setAUserID()
     * @uses GetReport::setAReportID()
     * @uses GetReport::setAParams()
     * @param int $aUserID
     * @param int $aReportID
     * @param \App\Insis\StructType\ReportParam[] $aParams
     */
    public function __construct($aUserID = null, $aReportID = null, array $aParams = array())
    {
        $this
            ->setAUserID($aUserID)
            ->setAReportID($aReportID)
            ->setAParams($aParams);
    }
    /**
     * Get aUserID value
     * @return int|null
     */
    public function getAUserID()
    {
        return $this->aUserID;
    }
    /**
     * Set aUserID value
     * @param int $aUserID
     * @return \App\Insis\StructType\GetReport
     */
    public function setAUserID($aUserID = null)
    {
        // validation for constraint: int
        if (!is_null($aUserID) && !(is_int($aUserID) || ctype_digit($aUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aUserID, true), gettype($aUserID)), __LINE__);
        }
        $this->aUserID = $aUserID;
        return $this;
    }
    /**
     * Get aReportID value
     * @return int|null
     */
    public function getAReportID()
    {
        return $this->aReportID;
    }
    /**
     * Set aReportID value
     * @param int $aReportID
     * @return \App\Insis\StructType\GetReport
     */
    public function setAReportID($aReportID = null)
    {
        // validation for constraint: int
        if (!is_null($aReportID) && !(is_int($aReportID) || ctype_digit($aReportID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aReportID, true), gettype($aReportID)), __LINE__);
        }
        $this->aReportID = $aReportID;
        return $this;
    }
    /**
     * Get aParams value
     * @return \App\Insis\StructType\ReportParam[]|null
     */
    public function getAParams()
    {
        return $this->aParams;
    }
    /**
     * This method is responsible for validating the values passed to the setAParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAParamsForArrayConstraintsFromSetAParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getReportAParamsItem) {
            // validation for constraint: itemType
            if (!$getReportAParamsItem instanceof \App\Insis\StructType\ReportParam) {
                $invalidValues[] = is_object($getReportAParamsItem) ? get_class($getReportAParamsItem) : sprintf('%s(%s)', gettype($getReportAParamsItem), var_export($getReportAParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aParams property can only contain items of type \App\Insis\StructType\ReportParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ReportParam[] $aParams
     * @return \App\Insis\StructType\GetReport
     */
    public function setAParams(array $aParams = array())
    {
        // validation for constraint: array
        if ('' !== ($aParamsArrayErrorMessage = self::validateAParamsForArrayConstraintsFromSetAParams($aParams))) {
            throw new \InvalidArgumentException($aParamsArrayErrorMessage, __LINE__);
        }
        $this->aParams = $aParams;
        return $this;
    }
    /**
     * Add item to aParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ReportParam $item
     * @return \App\Insis\StructType\GetReport
     */
    public function addToAParams(\App\Insis\StructType\ReportParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ReportParam) {
            throw new \InvalidArgumentException(sprintf('The aParams property can only contain items of type \App\Insis\StructType\ReportParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aParams[] = $item;
        return $this;
    }
}
