<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPremiumTravelPolicy StructType
 * Meta information extracted from the WSDL
 * - type: tns:getPremiumTravelPolicy
 * @subpackage Structs
 */
class GetPremiumTravelPolicy extends AbstractStructBase
{
    /**
     * The InsrType
     * @var int
     */
    public $InsrType;
    /**
     * The CoverType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CoverType;
    /**
     * The InsurSum
     * @var int
     */
    public $InsurSum;
    /**
     * The InsurCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InsurCurrency;
    /**
     * The BeginDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The Countries
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Countries;
    /**
     * The IIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IIN;
    /**
     * The Params
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $Params;
    /**
     * Constructor method for getPremiumTravelPolicy
     * @uses GetPremiumTravelPolicy::setInsrType()
     * @uses GetPremiumTravelPolicy::setCoverType()
     * @uses GetPremiumTravelPolicy::setInsurSum()
     * @uses GetPremiumTravelPolicy::setInsurCurrency()
     * @uses GetPremiumTravelPolicy::setBeginDate()
     * @uses GetPremiumTravelPolicy::setEndDate()
     * @uses GetPremiumTravelPolicy::setCountries()
     * @uses GetPremiumTravelPolicy::setIIN()
     * @uses GetPremiumTravelPolicy::setParams()
     * @param int $insrType
     * @param string $coverType
     * @param int $insurSum
     * @param string $insurCurrency
     * @param string $beginDate
     * @param string $endDate
     * @param string[] $countries
     * @param string $iIN
     * @param \App\Insis\StructType\ObjectParam[] $params
     */
    public function __construct($insrType = null, $coverType = null, $insurSum = null, $insurCurrency = null, $beginDate = null, $endDate = null, array $countries = array(), $iIN = null, array $params = array())
    {
        $this
            ->setInsrType($insrType)
            ->setCoverType($coverType)
            ->setInsurSum($insurSum)
            ->setInsurCurrency($insurCurrency)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setCountries($countries)
            ->setIIN($iIN)
            ->setParams($params);
    }
    /**
     * Get InsrType value
     * @return int|null
     */
    public function getInsrType()
    {
        return $this->InsrType;
    }
    /**
     * Set InsrType value
     * @param int $insrType
     * @return \App\Insis\StructType\GetPremiumTravelPolicy
     */
    public function setInsrType($insrType = null)
    {
        // validation for constraint: int
        if (!is_null($insrType) && !(is_int($insrType) || ctype_digit($insrType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insrType, true), gettype($insrType)), __LINE__);
        }
        $this->InsrType = $insrType;
        return $this;
    }
    /**
     * Get CoverType value
     * @return string|null
     */
    public function getCoverType()
    {
        return $this->CoverType;
    }
    /**
     * Set CoverType value
     * @param string $coverType
     * @return \App\Insis\StructType\GetPremiumTravelPolicy
     */
    public function setCoverType($coverType = null)
    {
        // validation for constraint: string
        if (!is_null($coverType) && !is_string($coverType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coverType, true), gettype($coverType)), __LINE__);
        }
        $this->CoverType = $coverType;
        return $this;
    }
    /**
     * Get InsurSum value
     * @return int|null
     */
    public function getInsurSum()
    {
        return $this->InsurSum;
    }
    /**
     * Set InsurSum value
     * @param int $insurSum
     * @return \App\Insis\StructType\GetPremiumTravelPolicy
     */
    public function setInsurSum($insurSum = null)
    {
        // validation for constraint: int
        if (!is_null($insurSum) && !(is_int($insurSum) || ctype_digit($insurSum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insurSum, true), gettype($insurSum)), __LINE__);
        }
        $this->InsurSum = $insurSum;
        return $this;
    }
    /**
     * Get InsurCurrency value
     * @return string|null
     */
    public function getInsurCurrency()
    {
        return $this->InsurCurrency;
    }
    /**
     * Set InsurCurrency value
     * @param string $insurCurrency
     * @return \App\Insis\StructType\GetPremiumTravelPolicy
     */
    public function setInsurCurrency($insurCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($insurCurrency) && !is_string($insurCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insurCurrency, true), gettype($insurCurrency)), __LINE__);
        }
        $this->InsurCurrency = $insurCurrency;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \App\Insis\StructType\GetPremiumTravelPolicy
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \App\Insis\StructType\GetPremiumTravelPolicy
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Countries value
     * @return string[]|null
     */
    public function getCountries()
    {
        return $this->Countries;
    }
    /**
     * This method is responsible for validating the values passed to the setCountries method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountries method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountriesForArrayConstraintsFromSetCountries(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getPremiumTravelPolicyCountriesItem) {
            // validation for constraint: itemType
            if (!is_string($getPremiumTravelPolicyCountriesItem)) {
                $invalidValues[] = is_object($getPremiumTravelPolicyCountriesItem) ? get_class($getPremiumTravelPolicyCountriesItem) : sprintf('%s(%s)', gettype($getPremiumTravelPolicyCountriesItem), var_export($getPremiumTravelPolicyCountriesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Countries property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Countries value
     * @throws \InvalidArgumentException
     * @param string[] $countries
     * @return \App\Insis\StructType\GetPremiumTravelPolicy
     */
    public function setCountries(array $countries = array())
    {
        // validation for constraint: array
        if ('' !== ($countriesArrayErrorMessage = self::validateCountriesForArrayConstraintsFromSetCountries($countries))) {
            throw new \InvalidArgumentException($countriesArrayErrorMessage, __LINE__);
        }
        $this->Countries = $countries;
        return $this;
    }
    /**
     * Add item to Countries value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Insis\StructType\GetPremiumTravelPolicy
     */
    public function addToCountries($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Countries property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Countries[] = $item;
        return $this;
    }
    /**
     * Get IIN value
     * @return string|null
     */
    public function getIIN()
    {
        return $this->IIN;
    }
    /**
     * Set IIN value
     * @param string $iIN
     * @return \App\Insis\StructType\GetPremiumTravelPolicy
     */
    public function setIIN($iIN = null)
    {
        // validation for constraint: string
        if (!is_null($iIN) && !is_string($iIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iIN, true), gettype($iIN)), __LINE__);
        }
        $this->IIN = $iIN;
        return $this;
    }
    /**
     * Get Params value
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getParams()
    {
        return $this->Params;
    }
    /**
     * This method is responsible for validating the values passed to the setParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParamsForArrayConstraintsFromSetParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getPremiumTravelPolicyParamsItem) {
            // validation for constraint: itemType
            if (!$getPremiumTravelPolicyParamsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($getPremiumTravelPolicyParamsItem) ? get_class($getPremiumTravelPolicyParamsItem) : sprintf('%s(%s)', gettype($getPremiumTravelPolicyParamsItem), var_export($getPremiumTravelPolicyParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Params property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Params value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $params
     * @return \App\Insis\StructType\GetPremiumTravelPolicy
     */
    public function setParams(array $params = array())
    {
        // validation for constraint: array
        if ('' !== ($paramsArrayErrorMessage = self::validateParamsForArrayConstraintsFromSetParams($params))) {
            throw new \InvalidArgumentException($paramsArrayErrorMessage, __LINE__);
        }
        $this->Params = $params;
        return $this;
    }
    /**
     * Add item to Params value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\GetPremiumTravelPolicy
     */
    public function addToParams(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The Params property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Params[] = $item;
        return $this;
    }
}
