<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPolicyPrint StructType
 * Meta information extracted from the WSDL
 * - type: tns:getPolicyPrint
 * @subpackage Structs
 */
class GetPolicyPrint extends AbstractStructBase
{
    /**
     * The aPolicyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aPolicyID;
    /**
     * The aAnnexID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aAnnexID;
    /**
     * The aPrintType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aPrintType;
    /**
     * The aPrintGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aPrintGroup;
    /**
     * The aCoverType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aCoverType;
    /**
     * Constructor method for getPolicyPrint
     * @uses GetPolicyPrint::setAPolicyID()
     * @uses GetPolicyPrint::setAAnnexID()
     * @uses GetPolicyPrint::setAPrintType()
     * @uses GetPolicyPrint::setAPrintGroup()
     * @uses GetPolicyPrint::setACoverType()
     * @param int $aPolicyID
     * @param int $aAnnexID
     * @param int $aPrintType
     * @param string $aPrintGroup
     * @param string $aCoverType
     */
    public function __construct($aPolicyID = null, $aAnnexID = null, $aPrintType = null, $aPrintGroup = null, $aCoverType = null)
    {
        $this
            ->setAPolicyID($aPolicyID)
            ->setAAnnexID($aAnnexID)
            ->setAPrintType($aPrintType)
            ->setAPrintGroup($aPrintGroup)
            ->setACoverType($aCoverType);
    }
    /**
     * Get aPolicyID value
     * @return int|null
     */
    public function getAPolicyID()
    {
        return $this->aPolicyID;
    }
    /**
     * Set aPolicyID value
     * @param int $aPolicyID
     * @return \App\Insis\StructType\GetPolicyPrint
     */
    public function setAPolicyID($aPolicyID = null)
    {
        // validation for constraint: int
        if (!is_null($aPolicyID) && !(is_int($aPolicyID) || ctype_digit($aPolicyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aPolicyID, true), gettype($aPolicyID)), __LINE__);
        }
        $this->aPolicyID = $aPolicyID;
        return $this;
    }
    /**
     * Get aAnnexID value
     * @return int|null
     */
    public function getAAnnexID()
    {
        return $this->aAnnexID;
    }
    /**
     * Set aAnnexID value
     * @param int $aAnnexID
     * @return \App\Insis\StructType\GetPolicyPrint
     */
    public function setAAnnexID($aAnnexID = null)
    {
        // validation for constraint: int
        if (!is_null($aAnnexID) && !(is_int($aAnnexID) || ctype_digit($aAnnexID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aAnnexID, true), gettype($aAnnexID)), __LINE__);
        }
        $this->aAnnexID = $aAnnexID;
        return $this;
    }
    /**
     * Get aPrintType value
     * @return int|null
     */
    public function getAPrintType()
    {
        return $this->aPrintType;
    }
    /**
     * Set aPrintType value
     * @param int $aPrintType
     * @return \App\Insis\StructType\GetPolicyPrint
     */
    public function setAPrintType($aPrintType = null)
    {
        // validation for constraint: int
        if (!is_null($aPrintType) && !(is_int($aPrintType) || ctype_digit($aPrintType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aPrintType, true), gettype($aPrintType)), __LINE__);
        }
        $this->aPrintType = $aPrintType;
        return $this;
    }
    /**
     * Get aPrintGroup value
     * @return string|null
     */
    public function getAPrintGroup()
    {
        return $this->aPrintGroup;
    }
    /**
     * Set aPrintGroup value
     * @param string $aPrintGroup
     * @return \App\Insis\StructType\GetPolicyPrint
     */
    public function setAPrintGroup($aPrintGroup = null)
    {
        // validation for constraint: string
        if (!is_null($aPrintGroup) && !is_string($aPrintGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPrintGroup, true), gettype($aPrintGroup)), __LINE__);
        }
        $this->aPrintGroup = $aPrintGroup;
        return $this;
    }
    /**
     * Get aCoverType value
     * @return string|null
     */
    public function getACoverType()
    {
        return $this->aCoverType;
    }
    /**
     * Set aCoverType value
     * @param string $aCoverType
     * @return \App\Insis\StructType\GetPolicyPrint
     */
    public function setACoverType($aCoverType = null)
    {
        // validation for constraint: string
        if (!is_null($aCoverType) && !is_string($aCoverType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCoverType, true), gettype($aCoverType)), __LINE__);
        }
        $this->aCoverType = $aCoverType;
        return $this;
    }
}
