<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPolicy StructType
 * Meta information extracted from the WSDL
 * - type: tns:getPolicy
 * @subpackage Structs
 */
class GetPolicy extends AbstractStructBase
{
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyID;
    /**
     * The annexID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $annexID;
    /**
     * Constructor method for getPolicy
     * @uses GetPolicy::setPolicyID()
     * @uses GetPolicy::setAnnexID()
     * @param int $policyID
     * @param int $annexID
     */
    public function __construct($policyID = null, $annexID = null)
    {
        $this
            ->setPolicyID($policyID)
            ->setAnnexID($annexID);
    }
    /**
     * Get policyID value
     * @return int|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param int $policyID
     * @return \App\Insis\StructType\GetPolicy
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: int
        if (!is_null($policyID) && !(is_int($policyID) || ctype_digit($policyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get annexID value
     * @return int|null
     */
    public function getAnnexID()
    {
        return $this->annexID;
    }
    /**
     * Set annexID value
     * @param int $annexID
     * @return \App\Insis\StructType\GetPolicy
     */
    public function setAnnexID($annexID = null)
    {
        // validation for constraint: int
        if (!is_null($annexID) && !(is_int($annexID) || ctype_digit($annexID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($annexID, true), gettype($annexID)), __LINE__);
        }
        $this->annexID = $annexID;
        return $this;
    }
}
