<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getGuidBank StructType
 * Meta information extracted from the WSDL
 * - type: tns:getGuidBank
 * @subpackage Structs
 */
class GetGuidBank extends AbstractStructBase
{
    /**
     * The aIins
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $aIins;
    /**
     * The aGosNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $aGosNumbers;
    /**
     * The aPolicyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aPolicyID;
    /**
     * The acardHolder
     * @var bool
     */
    public $acardHolder;
    /**
     * The aBeginDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aBeginDate;
    /**
     * The aPhoneNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aPhoneNumber;
    /**
     * The aAgentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aAgentID;
    /**
     * The aChannelID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aChannelID;
    /**
     * The aPinCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aPinCode;
    /**
     * The aOldPolicyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aOldPolicyID;
    /**
     * Constructor method for getGuidBank
     * @uses GetGuidBank::setAIins()
     * @uses GetGuidBank::setAGosNumbers()
     * @uses GetGuidBank::setAPolicyID()
     * @uses GetGuidBank::setAcardHolder()
     * @uses GetGuidBank::setABeginDate()
     * @uses GetGuidBank::setAPhoneNumber()
     * @uses GetGuidBank::setAAgentID()
     * @uses GetGuidBank::setAChannelID()
     * @uses GetGuidBank::setAPinCode()
     * @uses GetGuidBank::setAOldPolicyID()
     * @param string[] $aIins
     * @param string[] $aGosNumbers
     * @param string $aPolicyID
     * @param bool $acardHolder
     * @param string $aBeginDate
     * @param string $aPhoneNumber
     * @param int $aAgentID
     * @param int $aChannelID
     * @param string $aPinCode
     * @param string $aOldPolicyID
     */
    public function __construct(array $aIins = array(), array $aGosNumbers = array(), $aPolicyID = null, $acardHolder = null, $aBeginDate = null, $aPhoneNumber = null, $aAgentID = null, $aChannelID = null, $aPinCode = null, $aOldPolicyID = null)
    {
        $this
            ->setAIins($aIins)
            ->setAGosNumbers($aGosNumbers)
            ->setAPolicyID($aPolicyID)
            ->setAcardHolder($acardHolder)
            ->setABeginDate($aBeginDate)
            ->setAPhoneNumber($aPhoneNumber)
            ->setAAgentID($aAgentID)
            ->setAChannelID($aChannelID)
            ->setAPinCode($aPinCode)
            ->setAOldPolicyID($aOldPolicyID);
    }
    /**
     * Get aIins value
     * @return string[]|null
     */
    public function getAIins()
    {
        return $this->aIins;
    }
    /**
     * This method is responsible for validating the values passed to the setAIins method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAIins method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAIinsForArrayConstraintsFromSetAIins(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getGuidBankAIinsItem) {
            // validation for constraint: itemType
            if (!is_string($getGuidBankAIinsItem)) {
                $invalidValues[] = is_object($getGuidBankAIinsItem) ? get_class($getGuidBankAIinsItem) : sprintf('%s(%s)', gettype($getGuidBankAIinsItem), var_export($getGuidBankAIinsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aIins property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aIins value
     * @throws \InvalidArgumentException
     * @param string[] $aIins
     * @return \App\Insis\StructType\GetGuidBank
     */
    public function setAIins(array $aIins = array())
    {
        // validation for constraint: array
        if ('' !== ($aIinsArrayErrorMessage = self::validateAIinsForArrayConstraintsFromSetAIins($aIins))) {
            throw new \InvalidArgumentException($aIinsArrayErrorMessage, __LINE__);
        }
        $this->aIins = $aIins;
        return $this;
    }
    /**
     * Add item to aIins value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Insis\StructType\GetGuidBank
     */
    public function addToAIins($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The aIins property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aIins[] = $item;
        return $this;
    }
    /**
     * Get aGosNumbers value
     * @return string[]|null
     */
    public function getAGosNumbers()
    {
        return $this->aGosNumbers;
    }
    /**
     * This method is responsible for validating the values passed to the setAGosNumbers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAGosNumbers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAGosNumbersForArrayConstraintsFromSetAGosNumbers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getGuidBankAGosNumbersItem) {
            // validation for constraint: itemType
            if (!is_string($getGuidBankAGosNumbersItem)) {
                $invalidValues[] = is_object($getGuidBankAGosNumbersItem) ? get_class($getGuidBankAGosNumbersItem) : sprintf('%s(%s)', gettype($getGuidBankAGosNumbersItem), var_export($getGuidBankAGosNumbersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aGosNumbers property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aGosNumbers value
     * @throws \InvalidArgumentException
     * @param string[] $aGosNumbers
     * @return \App\Insis\StructType\GetGuidBank
     */
    public function setAGosNumbers(array $aGosNumbers = array())
    {
        // validation for constraint: array
        if ('' !== ($aGosNumbersArrayErrorMessage = self::validateAGosNumbersForArrayConstraintsFromSetAGosNumbers($aGosNumbers))) {
            throw new \InvalidArgumentException($aGosNumbersArrayErrorMessage, __LINE__);
        }
        $this->aGosNumbers = $aGosNumbers;
        return $this;
    }
    /**
     * Add item to aGosNumbers value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Insis\StructType\GetGuidBank
     */
    public function addToAGosNumbers($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The aGosNumbers property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aGosNumbers[] = $item;
        return $this;
    }
    /**
     * Get aPolicyID value
     * @return string|null
     */
    public function getAPolicyID()
    {
        return $this->aPolicyID;
    }
    /**
     * Set aPolicyID value
     * @param string $aPolicyID
     * @return \App\Insis\StructType\GetGuidBank
     */
    public function setAPolicyID($aPolicyID = null)
    {
        // validation for constraint: string
        if (!is_null($aPolicyID) && !is_string($aPolicyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPolicyID, true), gettype($aPolicyID)), __LINE__);
        }
        $this->aPolicyID = $aPolicyID;
        return $this;
    }
    /**
     * Get acardHolder value
     * @return bool|null
     */
    public function getAcardHolder()
    {
        return $this->acardHolder;
    }
    /**
     * Set acardHolder value
     * @param bool $acardHolder
     * @return \App\Insis\StructType\GetGuidBank
     */
    public function setAcardHolder($acardHolder = null)
    {
        // validation for constraint: boolean
        if (!is_null($acardHolder) && !is_bool($acardHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($acardHolder, true), gettype($acardHolder)), __LINE__);
        }
        $this->acardHolder = $acardHolder;
        return $this;
    }
    /**
     * Get aBeginDate value
     * @return string|null
     */
    public function getABeginDate()
    {
        return $this->aBeginDate;
    }
    /**
     * Set aBeginDate value
     * @param string $aBeginDate
     * @return \App\Insis\StructType\GetGuidBank
     */
    public function setABeginDate($aBeginDate = null)
    {
        // validation for constraint: string
        if (!is_null($aBeginDate) && !is_string($aBeginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aBeginDate, true), gettype($aBeginDate)), __LINE__);
        }
        $this->aBeginDate = $aBeginDate;
        return $this;
    }
    /**
     * Get aPhoneNumber value
     * @return string|null
     */
    public function getAPhoneNumber()
    {
        return $this->aPhoneNumber;
    }
    /**
     * Set aPhoneNumber value
     * @param string $aPhoneNumber
     * @return \App\Insis\StructType\GetGuidBank
     */
    public function setAPhoneNumber($aPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($aPhoneNumber) && !is_string($aPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPhoneNumber, true), gettype($aPhoneNumber)), __LINE__);
        }
        $this->aPhoneNumber = $aPhoneNumber;
        return $this;
    }
    /**
     * Get aAgentID value
     * @return int|null
     */
    public function getAAgentID()
    {
        return $this->aAgentID;
    }
    /**
     * Set aAgentID value
     * @param int $aAgentID
     * @return \App\Insis\StructType\GetGuidBank
     */
    public function setAAgentID($aAgentID = null)
    {
        // validation for constraint: int
        if (!is_null($aAgentID) && !(is_int($aAgentID) || ctype_digit($aAgentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aAgentID, true), gettype($aAgentID)), __LINE__);
        }
        $this->aAgentID = $aAgentID;
        return $this;
    }
    /**
     * Get aChannelID value
     * @return int|null
     */
    public function getAChannelID()
    {
        return $this->aChannelID;
    }
    /**
     * Set aChannelID value
     * @param int $aChannelID
     * @return \App\Insis\StructType\GetGuidBank
     */
    public function setAChannelID($aChannelID = null)
    {
        // validation for constraint: int
        if (!is_null($aChannelID) && !(is_int($aChannelID) || ctype_digit($aChannelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aChannelID, true), gettype($aChannelID)), __LINE__);
        }
        $this->aChannelID = $aChannelID;
        return $this;
    }
    /**
     * Get aPinCode value
     * @return string|null
     */
    public function getAPinCode()
    {
        return $this->aPinCode;
    }
    /**
     * Set aPinCode value
     * @param string $aPinCode
     * @return \App\Insis\StructType\GetGuidBank
     */
    public function setAPinCode($aPinCode = null)
    {
        // validation for constraint: string
        if (!is_null($aPinCode) && !is_string($aPinCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPinCode, true), gettype($aPinCode)), __LINE__);
        }
        $this->aPinCode = $aPinCode;
        return $this;
    }
    /**
     * Get aOldPolicyID value
     * @return string|null
     */
    public function getAOldPolicyID()
    {
        return $this->aOldPolicyID;
    }
    /**
     * Set aOldPolicyID value
     * @param string $aOldPolicyID
     * @return \App\Insis\StructType\GetGuidBank
     */
    public function setAOldPolicyID($aOldPolicyID = null)
    {
        // validation for constraint: string
        if (!is_null($aOldPolicyID) && !is_string($aOldPolicyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aOldPolicyID, true), gettype($aOldPolicyID)), __LINE__);
        }
        $this->aOldPolicyID = $aOldPolicyID;
        return $this;
    }
}
