<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getDocumentAttachment StructType
 * Meta information extracted from the WSDL
 * - type: tns:getDocumentAttachment
 * @subpackage Structs
 */
class GetDocumentAttachment extends AbstractStructBase
{
    /**
     * The aObjectType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aObjectType;
    /**
     * The aAttachmentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aAttachmentId;
    /**
     * Constructor method for getDocumentAttachment
     * @uses GetDocumentAttachment::setAObjectType()
     * @uses GetDocumentAttachment::setAAttachmentId()
     * @param int $aObjectType
     * @param int $aAttachmentId
     */
    public function __construct($aObjectType = null, $aAttachmentId = null)
    {
        $this
            ->setAObjectType($aObjectType)
            ->setAAttachmentId($aAttachmentId);
    }
    /**
     * Get aObjectType value
     * @return int|null
     */
    public function getAObjectType()
    {
        return $this->aObjectType;
    }
    /**
     * Set aObjectType value
     * @param int $aObjectType
     * @return \App\Insis\StructType\GetDocumentAttachment
     */
    public function setAObjectType($aObjectType = null)
    {
        // validation for constraint: int
        if (!is_null($aObjectType) && !(is_int($aObjectType) || ctype_digit($aObjectType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aObjectType, true), gettype($aObjectType)), __LINE__);
        }
        $this->aObjectType = $aObjectType;
        return $this;
    }
    /**
     * Get aAttachmentId value
     * @return int|null
     */
    public function getAAttachmentId()
    {
        return $this->aAttachmentId;
    }
    /**
     * Set aAttachmentId value
     * @param int $aAttachmentId
     * @return \App\Insis\StructType\GetDocumentAttachment
     */
    public function setAAttachmentId($aAttachmentId = null)
    {
        // validation for constraint: int
        if (!is_null($aAttachmentId) && !(is_int($aAttachmentId) || ctype_digit($aAttachmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aAttachmentId, true), gettype($aAttachmentId)), __LINE__);
        }
        $this->aAttachmentId = $aAttachmentId;
        return $this;
    }
}
