<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for draftObject StructType
 * @subpackage Structs
 */
class DraftObject extends AbstractStructBase
{
    /**
     * The make
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $make;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The prodYear
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $prodYear;
    /**
     * The regNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $regNo;
    /**
     * The territory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $territory;
    /**
     * Constructor method for draftObject
     * @uses DraftObject::setMake()
     * @uses DraftObject::setModel()
     * @uses DraftObject::setProdYear()
     * @uses DraftObject::setRegNo()
     * @uses DraftObject::setTerritory()
     * @param string $make
     * @param string $model
     * @param int $prodYear
     * @param string $regNo
     * @param string $territory
     */
    public function __construct($make = null, $model = null, $prodYear = null, $regNo = null, $territory = null)
    {
        $this
            ->setMake($make)
            ->setModel($model)
            ->setProdYear($prodYear)
            ->setRegNo($regNo)
            ->setTerritory($territory);
    }
    /**
     * Get make value
     * @return string|null
     */
    public function getMake()
    {
        return $this->make;
    }
    /**
     * Set make value
     * @param string $make
     * @return \App\Insis\StructType\DraftObject
     */
    public function setMake($make = null)
    {
        // validation for constraint: string
        if (!is_null($make) && !is_string($make)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($make, true), gettype($make)), __LINE__);
        }
        $this->make = $make;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param string $model
     * @return \App\Insis\StructType\DraftObject
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($model, true), gettype($model)), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get prodYear value
     * @return int|null
     */
    public function getProdYear()
    {
        return $this->prodYear;
    }
    /**
     * Set prodYear value
     * @param int $prodYear
     * @return \App\Insis\StructType\DraftObject
     */
    public function setProdYear($prodYear = null)
    {
        // validation for constraint: int
        if (!is_null($prodYear) && !(is_int($prodYear) || ctype_digit($prodYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prodYear, true), gettype($prodYear)), __LINE__);
        }
        $this->prodYear = $prodYear;
        return $this;
    }
    /**
     * Get regNo value
     * @return string|null
     */
    public function getRegNo()
    {
        return $this->regNo;
    }
    /**
     * Set regNo value
     * @param string $regNo
     * @return \App\Insis\StructType\DraftObject
     */
    public function setRegNo($regNo = null)
    {
        // validation for constraint: string
        if (!is_null($regNo) && !is_string($regNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regNo, true), gettype($regNo)), __LINE__);
        }
        $this->regNo = $regNo;
        return $this;
    }
    /**
     * Get territory value
     * @return string|null
     */
    public function getTerritory()
    {
        return $this->territory;
    }
    /**
     * Set territory value
     * @param string $territory
     * @return \App\Insis\StructType\DraftObject
     */
    public function setTerritory($territory = null)
    {
        // validation for constraint: string
        if (!is_null($territory) && !is_string($territory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($territory, true), gettype($territory)), __LINE__);
        }
        $this->territory = $territory;
        return $this;
    }
}
