<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for draft StructType
 * @subpackage Structs
 */
class Draft extends AbstractStructBase
{
    /**
     * The avtop_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $avtop_id;
    /**
     * The basket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $basket;
    /**
     * The beginDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $beginDate;
    /**
     * The casko_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $casko_id;
    /**
     * The clients
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\DraftClient[]
     */
    public $clients;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The objects
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\DraftObject[]
     */
    public $objects;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyID;
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyNumber;
    /**
     * The policy_state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policy_state;
    /**
     * The premium_ogpo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $premium_ogpo;
    /**
     * Constructor method for draft
     * @uses Draft::setAvtop_id()
     * @uses Draft::setBasket()
     * @uses Draft::setBeginDate()
     * @uses Draft::setCasko_id()
     * @uses Draft::setClients()
     * @uses Draft::setEndDate()
     * @uses Draft::setObjects()
     * @uses Draft::setPolicyID()
     * @uses Draft::setPolicyNumber()
     * @uses Draft::setPolicy_state()
     * @uses Draft::setPremium_ogpo()
     * @param int $avtop_id
     * @param string $basket
     * @param string $beginDate
     * @param int $casko_id
     * @param \App\Insis\StructType\DraftClient[] $clients
     * @param string $endDate
     * @param \App\Insis\StructType\DraftObject[] $objects
     * @param int $policyID
     * @param string $policyNumber
     * @param int $policy_state
     * @param float $premium_ogpo
     */
    public function __construct($avtop_id = null, $basket = null, $beginDate = null, $casko_id = null, array $clients = array(), $endDate = null, array $objects = array(), $policyID = null, $policyNumber = null, $policy_state = null, $premium_ogpo = null)
    {
        $this
            ->setAvtop_id($avtop_id)
            ->setBasket($basket)
            ->setBeginDate($beginDate)
            ->setCasko_id($casko_id)
            ->setClients($clients)
            ->setEndDate($endDate)
            ->setObjects($objects)
            ->setPolicyID($policyID)
            ->setPolicyNumber($policyNumber)
            ->setPolicy_state($policy_state)
            ->setPremium_ogpo($premium_ogpo);
    }
    /**
     * Get avtop_id value
     * @return int|null
     */
    public function getAvtop_id()
    {
        return $this->avtop_id;
    }
    /**
     * Set avtop_id value
     * @param int $avtop_id
     * @return \App\Insis\StructType\Draft
     */
    public function setAvtop_id($avtop_id = null)
    {
        // validation for constraint: int
        if (!is_null($avtop_id) && !(is_int($avtop_id) || ctype_digit($avtop_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($avtop_id, true), gettype($avtop_id)), __LINE__);
        }
        $this->avtop_id = $avtop_id;
        return $this;
    }
    /**
     * Get basket value
     * @return string|null
     */
    public function getBasket()
    {
        return $this->basket;
    }
    /**
     * Set basket value
     * @param string $basket
     * @return \App\Insis\StructType\Draft
     */
    public function setBasket($basket = null)
    {
        // validation for constraint: string
        if (!is_null($basket) && !is_string($basket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basket, true), gettype($basket)), __LINE__);
        }
        $this->basket = $basket;
        return $this;
    }
    /**
     * Get beginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->beginDate;
    }
    /**
     * Set beginDate value
     * @param string $beginDate
     * @return \App\Insis\StructType\Draft
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginDate, true), gettype($beginDate)), __LINE__);
        }
        $this->beginDate = $beginDate;
        return $this;
    }
    /**
     * Get casko_id value
     * @return int|null
     */
    public function getCasko_id()
    {
        return $this->casko_id;
    }
    /**
     * Set casko_id value
     * @param int $casko_id
     * @return \App\Insis\StructType\Draft
     */
    public function setCasko_id($casko_id = null)
    {
        // validation for constraint: int
        if (!is_null($casko_id) && !(is_int($casko_id) || ctype_digit($casko_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($casko_id, true), gettype($casko_id)), __LINE__);
        }
        $this->casko_id = $casko_id;
        return $this;
    }
    /**
     * Get clients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\DraftClient[]|null
     */
    public function getClients()
    {
        return isset($this->clients) ? $this->clients : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClients method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClients method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClientsForArrayConstraintsFromSetClients(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $draftClientsItem) {
            // validation for constraint: itemType
            if (!$draftClientsItem instanceof \App\Insis\StructType\DraftClient) {
                $invalidValues[] = is_object($draftClientsItem) ? get_class($draftClientsItem) : sprintf('%s(%s)', gettype($draftClientsItem), var_export($draftClientsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The clients property can only contain items of type \App\Insis\StructType\DraftClient, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set clients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\DraftClient[] $clients
     * @return \App\Insis\StructType\Draft
     */
    public function setClients(array $clients = array())
    {
        // validation for constraint: array
        if ('' !== ($clientsArrayErrorMessage = self::validateClientsForArrayConstraintsFromSetClients($clients))) {
            throw new \InvalidArgumentException($clientsArrayErrorMessage, __LINE__);
        }
        if (is_null($clients) || (is_array($clients) && empty($clients))) {
            unset($this->clients);
        } else {
            $this->clients = $clients;
        }
        return $this;
    }
    /**
     * Add item to clients value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\DraftClient $item
     * @return \App\Insis\StructType\Draft
     */
    public function addToClients(\App\Insis\StructType\DraftClient $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\DraftClient) {
            throw new \InvalidArgumentException(sprintf('The clients property can only contain items of type \App\Insis\StructType\DraftClient, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->clients[] = $item;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \App\Insis\StructType\Draft
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get objects value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\DraftObject[]|null
     */
    public function getObjects()
    {
        return isset($this->objects) ? $this->objects : null;
    }
    /**
     * This method is responsible for validating the values passed to the setObjects method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObjects method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjectsForArrayConstraintsFromSetObjects(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $draftObjectsItem) {
            // validation for constraint: itemType
            if (!$draftObjectsItem instanceof \App\Insis\StructType\DraftObject) {
                $invalidValues[] = is_object($draftObjectsItem) ? get_class($draftObjectsItem) : sprintf('%s(%s)', gettype($draftObjectsItem), var_export($draftObjectsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The objects property can only contain items of type \App\Insis\StructType\DraftObject, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set objects value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\DraftObject[] $objects
     * @return \App\Insis\StructType\Draft
     */
    public function setObjects(array $objects = array())
    {
        // validation for constraint: array
        if ('' !== ($objectsArrayErrorMessage = self::validateObjectsForArrayConstraintsFromSetObjects($objects))) {
            throw new \InvalidArgumentException($objectsArrayErrorMessage, __LINE__);
        }
        if (is_null($objects) || (is_array($objects) && empty($objects))) {
            unset($this->objects);
        } else {
            $this->objects = $objects;
        }
        return $this;
    }
    /**
     * Add item to objects value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\DraftObject $item
     * @return \App\Insis\StructType\Draft
     */
    public function addToObjects(\App\Insis\StructType\DraftObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\DraftObject) {
            throw new \InvalidArgumentException(sprintf('The objects property can only contain items of type \App\Insis\StructType\DraftObject, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->objects[] = $item;
        return $this;
    }
    /**
     * Get policyID value
     * @return int|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param int $policyID
     * @return \App\Insis\StructType\Draft
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: int
        if (!is_null($policyID) && !(is_int($policyID) || ctype_digit($policyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get policyNumber value
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param string $policyNumber
     * @return \App\Insis\StructType\Draft
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get policy_state value
     * @return int|null
     */
    public function getPolicy_state()
    {
        return $this->policy_state;
    }
    /**
     * Set policy_state value
     * @param int $policy_state
     * @return \App\Insis\StructType\Draft
     */
    public function setPolicy_state($policy_state = null)
    {
        // validation for constraint: int
        if (!is_null($policy_state) && !(is_int($policy_state) || ctype_digit($policy_state))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policy_state, true), gettype($policy_state)), __LINE__);
        }
        $this->policy_state = $policy_state;
        return $this;
    }
    /**
     * Get premium_ogpo value
     * @return float|null
     */
    public function getPremium_ogpo()
    {
        return $this->premium_ogpo;
    }
    /**
     * Set premium_ogpo value
     * @param float $premium_ogpo
     * @return \App\Insis\StructType\Draft
     */
    public function setPremium_ogpo($premium_ogpo = null)
    {
        // validation for constraint: float
        if (!is_null($premium_ogpo) && !(is_float($premium_ogpo) || is_numeric($premium_ogpo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premium_ogpo, true), gettype($premium_ogpo)), __LINE__);
        }
        $this->premium_ogpo = $premium_ogpo;
        return $this;
    }
}
