<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoverRisk StructType
 * @subpackage Structs
 */
class CoverRisk extends AbstractStructBase
{
    /**
     * The riskType
     * @var string
     */
    public $riskType;
    /**
     * The franchiseID
     * @var string
     */
    public $franchiseID;
    /**
     * The franchiseType
     * @var string
     */
    public $franchiseType;
    /**
     * The franchiseValue
     * @var float
     */
    public $franchiseValue;
    /**
     * The franchiseMinValue
     * @var float
     */
    public $franchiseMinValue;
    /**
     * The franchiseMaxValue
     * @var float
     */
    public $franchiseMaxValue;
    /**
     * Constructor method for CoverRisk
     * @uses CoverRisk::setRiskType()
     * @uses CoverRisk::setFranchiseID()
     * @uses CoverRisk::setFranchiseType()
     * @uses CoverRisk::setFranchiseValue()
     * @uses CoverRisk::setFranchiseMinValue()
     * @uses CoverRisk::setFranchiseMaxValue()
     * @param string $riskType
     * @param string $franchiseID
     * @param string $franchiseType
     * @param float $franchiseValue
     * @param float $franchiseMinValue
     * @param float $franchiseMaxValue
     */
    public function __construct($riskType = null, $franchiseID = null, $franchiseType = null, $franchiseValue = null, $franchiseMinValue = null, $franchiseMaxValue = null)
    {
        $this
            ->setRiskType($riskType)
            ->setFranchiseID($franchiseID)
            ->setFranchiseType($franchiseType)
            ->setFranchiseValue($franchiseValue)
            ->setFranchiseMinValue($franchiseMinValue)
            ->setFranchiseMaxValue($franchiseMaxValue);
    }
    /**
     * Get riskType value
     * @return string|null
     */
    public function getRiskType()
    {
        return $this->riskType;
    }
    /**
     * Set riskType value
     * @param string $riskType
     * @return \App\Insis\StructType\CoverRisk
     */
    public function setRiskType($riskType = null)
    {
        // validation for constraint: string
        if (!is_null($riskType) && !is_string($riskType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($riskType, true), gettype($riskType)), __LINE__);
        }
        $this->riskType = $riskType;
        return $this;
    }
    /**
     * Get franchiseID value
     * @return string|null
     */
    public function getFranchiseID()
    {
        return $this->franchiseID;
    }
    /**
     * Set franchiseID value
     * @param string $franchiseID
     * @return \App\Insis\StructType\CoverRisk
     */
    public function setFranchiseID($franchiseID = null)
    {
        // validation for constraint: string
        if (!is_null($franchiseID) && !is_string($franchiseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($franchiseID, true), gettype($franchiseID)), __LINE__);
        }
        $this->franchiseID = $franchiseID;
        return $this;
    }
    /**
     * Get franchiseType value
     * @return string|null
     */
    public function getFranchiseType()
    {
        return $this->franchiseType;
    }
    /**
     * Set franchiseType value
     * @param string $franchiseType
     * @return \App\Insis\StructType\CoverRisk
     */
    public function setFranchiseType($franchiseType = null)
    {
        // validation for constraint: string
        if (!is_null($franchiseType) && !is_string($franchiseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($franchiseType, true), gettype($franchiseType)), __LINE__);
        }
        $this->franchiseType = $franchiseType;
        return $this;
    }
    /**
     * Get franchiseValue value
     * @return float|null
     */
    public function getFranchiseValue()
    {
        return $this->franchiseValue;
    }
    /**
     * Set franchiseValue value
     * @param float $franchiseValue
     * @return \App\Insis\StructType\CoverRisk
     */
    public function setFranchiseValue($franchiseValue = null)
    {
        // validation for constraint: float
        if (!is_null($franchiseValue) && !(is_float($franchiseValue) || is_numeric($franchiseValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($franchiseValue, true), gettype($franchiseValue)), __LINE__);
        }
        $this->franchiseValue = $franchiseValue;
        return $this;
    }
    /**
     * Get franchiseMinValue value
     * @return float|null
     */
    public function getFranchiseMinValue()
    {
        return $this->franchiseMinValue;
    }
    /**
     * Set franchiseMinValue value
     * @param float $franchiseMinValue
     * @return \App\Insis\StructType\CoverRisk
     */
    public function setFranchiseMinValue($franchiseMinValue = null)
    {
        // validation for constraint: float
        if (!is_null($franchiseMinValue) && !(is_float($franchiseMinValue) || is_numeric($franchiseMinValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($franchiseMinValue, true), gettype($franchiseMinValue)), __LINE__);
        }
        $this->franchiseMinValue = $franchiseMinValue;
        return $this;
    }
    /**
     * Get franchiseMaxValue value
     * @return float|null
     */
    public function getFranchiseMaxValue()
    {
        return $this->franchiseMaxValue;
    }
    /**
     * Set franchiseMaxValue value
     * @param float $franchiseMaxValue
     * @return \App\Insis\StructType\CoverRisk
     */
    public function setFranchiseMaxValue($franchiseMaxValue = null)
    {
        // validation for constraint: float
        if (!is_null($franchiseMaxValue) && !(is_float($franchiseMaxValue) || is_numeric($franchiseMaxValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($franchiseMaxValue, true), gettype($franchiseMaxValue)), __LINE__);
        }
        $this->franchiseMaxValue = $franchiseMaxValue;
        return $this;
    }
}
