<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for claimState StructType
 * @subpackage Structs
 */
class ClaimState extends AbstractStructBase
{
    /**
     * The actualStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $actualStatus;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $status;
    /**
     * The statusDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $statusDate;
    /**
     * The statusHint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $statusHint;
    /**
     * Constructor method for claimState
     * @uses ClaimState::setActualStatus()
     * @uses ClaimState::setStatus()
     * @uses ClaimState::setStatusDate()
     * @uses ClaimState::setStatusHint()
     * @param string $actualStatus
     * @param int $status
     * @param string $statusDate
     * @param string $statusHint
     */
    public function __construct($actualStatus = null, $status = null, $statusDate = null, $statusHint = null)
    {
        $this
            ->setActualStatus($actualStatus)
            ->setStatus($status)
            ->setStatusDate($statusDate)
            ->setStatusHint($statusHint);
    }
    /**
     * Get actualStatus value
     * @return string|null
     */
    public function getActualStatus()
    {
        return $this->actualStatus;
    }
    /**
     * Set actualStatus value
     * @param string $actualStatus
     * @return \App\Insis\StructType\ClaimState
     */
    public function setActualStatus($actualStatus = null)
    {
        // validation for constraint: string
        if (!is_null($actualStatus) && !is_string($actualStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualStatus, true), gettype($actualStatus)), __LINE__);
        }
        $this->actualStatus = $actualStatus;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \App\Insis\StructType\ClaimState
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get statusDate value
     * @return string|null
     */
    public function getStatusDate()
    {
        return $this->statusDate;
    }
    /**
     * Set statusDate value
     * @param string $statusDate
     * @return \App\Insis\StructType\ClaimState
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDate, true), gettype($statusDate)), __LINE__);
        }
        $this->statusDate = $statusDate;
        return $this;
    }
    /**
     * Get statusHint value
     * @return string|null
     */
    public function getStatusHint()
    {
        return $this->statusHint;
    }
    /**
     * Set statusHint value
     * @param string $statusHint
     * @return \App\Insis\StructType\ClaimState
     */
    public function setStatusHint($statusHint = null)
    {
        // validation for constraint: string
        if (!is_null($statusHint) && !is_string($statusHint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusHint, true), gettype($statusHint)), __LINE__);
        }
        $this->statusHint = $statusHint;
        return $this;
    }
}
