<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for claimSiteView StructType
 * @subpackage Structs
 */
class ClaimSiteView extends AbstractStructBase
{
    /**
     * The applicantTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $applicantTitle;
    /**
     * The damageDesc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $damageDesc;
    /**
     * The eventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $eventDate;
    /**
     * The states
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\ClaimStateSiteView[]
     */
    public $states;
    /**
     * Constructor method for claimSiteView
     * @uses ClaimSiteView::setApplicantTitle()
     * @uses ClaimSiteView::setDamageDesc()
     * @uses ClaimSiteView::setEventDate()
     * @uses ClaimSiteView::setStates()
     * @param string $applicantTitle
     * @param string $damageDesc
     * @param string $eventDate
     * @param \App\Insis\StructType\ClaimStateSiteView[] $states
     */
    public function __construct($applicantTitle = null, $damageDesc = null, $eventDate = null, array $states = array())
    {
        $this
            ->setApplicantTitle($applicantTitle)
            ->setDamageDesc($damageDesc)
            ->setEventDate($eventDate)
            ->setStates($states);
    }
    /**
     * Get applicantTitle value
     * @return string|null
     */
    public function getApplicantTitle()
    {
        return $this->applicantTitle;
    }
    /**
     * Set applicantTitle value
     * @param string $applicantTitle
     * @return \App\Insis\StructType\ClaimSiteView
     */
    public function setApplicantTitle($applicantTitle = null)
    {
        // validation for constraint: string
        if (!is_null($applicantTitle) && !is_string($applicantTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicantTitle, true), gettype($applicantTitle)), __LINE__);
        }
        $this->applicantTitle = $applicantTitle;
        return $this;
    }
    /**
     * Get damageDesc value
     * @return string|null
     */
    public function getDamageDesc()
    {
        return $this->damageDesc;
    }
    /**
     * Set damageDesc value
     * @param string $damageDesc
     * @return \App\Insis\StructType\ClaimSiteView
     */
    public function setDamageDesc($damageDesc = null)
    {
        // validation for constraint: string
        if (!is_null($damageDesc) && !is_string($damageDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($damageDesc, true), gettype($damageDesc)), __LINE__);
        }
        $this->damageDesc = $damageDesc;
        return $this;
    }
    /**
     * Get eventDate value
     * @return string|null
     */
    public function getEventDate()
    {
        return $this->eventDate;
    }
    /**
     * Set eventDate value
     * @param string $eventDate
     * @return \App\Insis\StructType\ClaimSiteView
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        $this->eventDate = $eventDate;
        return $this;
    }
    /**
     * Get states value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\ClaimStateSiteView[]|null
     */
    public function getStates()
    {
        return isset($this->states) ? $this->states : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatesForArrayConstraintsFromSetStates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $claimSiteViewStatesItem) {
            // validation for constraint: itemType
            if (!$claimSiteViewStatesItem instanceof \App\Insis\StructType\ClaimStateSiteView) {
                $invalidValues[] = is_object($claimSiteViewStatesItem) ? get_class($claimSiteViewStatesItem) : sprintf('%s(%s)', gettype($claimSiteViewStatesItem), var_export($claimSiteViewStatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The states property can only contain items of type \App\Insis\StructType\ClaimStateSiteView, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set states value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ClaimStateSiteView[] $states
     * @return \App\Insis\StructType\ClaimSiteView
     */
    public function setStates(array $states = array())
    {
        // validation for constraint: array
        if ('' !== ($statesArrayErrorMessage = self::validateStatesForArrayConstraintsFromSetStates($states))) {
            throw new \InvalidArgumentException($statesArrayErrorMessage, __LINE__);
        }
        if (is_null($states) || (is_array($states) && empty($states))) {
            unset($this->states);
        } else {
            $this->states = $states;
        }
        return $this;
    }
    /**
     * Add item to states value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ClaimStateSiteView $item
     * @return \App\Insis\StructType\ClaimSiteView
     */
    public function addToStates(\App\Insis\StructType\ClaimStateSiteView $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ClaimStateSiteView) {
            throw new \InvalidArgumentException(sprintf('The states property can only contain items of type \App\Insis\StructType\ClaimStateSiteView, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->states[] = $item;
        return $this;
    }
}
