<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashPaymentDetail StructType
 * @subpackage Structs
 */
class CashPaymentDetail extends AbstractStructBase
{
    /**
     * The InsisType
     * @var string
     */
    public $InsisType;
    /**
     * The InsisID
     * @var int
     */
    public $InsisID;
    /**
     * The Sum
     * @var float
     */
    public $Sum;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The PaymentNumber
     * @var string
     */
    public $PaymentNumber;
    /**
     * The NettingBool
     * @var bool
     */
    public $NettingBool;
    /**
     * Constructor method for CashPaymentDetail
     * @uses CashPaymentDetail::setInsisType()
     * @uses CashPaymentDetail::setInsisID()
     * @uses CashPaymentDetail::setSum()
     * @uses CashPaymentDetail::setCurrency()
     * @uses CashPaymentDetail::setPaymentNumber()
     * @uses CashPaymentDetail::setNettingBool()
     * @param string $insisType
     * @param int $insisID
     * @param float $sum
     * @param string $currency
     * @param string $paymentNumber
     * @param bool $nettingBool
     */
    public function __construct($insisType = null, $insisID = null, $sum = null, $currency = null, $paymentNumber = null, $nettingBool = null)
    {
        $this
            ->setInsisType($insisType)
            ->setInsisID($insisID)
            ->setSum($sum)
            ->setCurrency($currency)
            ->setPaymentNumber($paymentNumber)
            ->setNettingBool($nettingBool);
    }
    /**
     * Get InsisType value
     * @return string|null
     */
    public function getInsisType()
    {
        return $this->InsisType;
    }
    /**
     * Set InsisType value
     * @param string $insisType
     * @return \App\Insis\StructType\CashPaymentDetail
     */
    public function setInsisType($insisType = null)
    {
        // validation for constraint: string
        if (!is_null($insisType) && !is_string($insisType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insisType, true), gettype($insisType)), __LINE__);
        }
        $this->InsisType = $insisType;
        return $this;
    }
    /**
     * Get InsisID value
     * @return int|null
     */
    public function getInsisID()
    {
        return $this->InsisID;
    }
    /**
     * Set InsisID value
     * @param int $insisID
     * @return \App\Insis\StructType\CashPaymentDetail
     */
    public function setInsisID($insisID = null)
    {
        // validation for constraint: int
        if (!is_null($insisID) && !(is_int($insisID) || ctype_digit($insisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insisID, true), gettype($insisID)), __LINE__);
        }
        $this->InsisID = $insisID;
        return $this;
    }
    /**
     * Get Sum value
     * @return float|null
     */
    public function getSum()
    {
        return $this->Sum;
    }
    /**
     * Set Sum value
     * @param float $sum
     * @return \App\Insis\StructType\CashPaymentDetail
     */
    public function setSum($sum = null)
    {
        // validation for constraint: float
        if (!is_null($sum) && !(is_float($sum) || is_numeric($sum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sum, true), gettype($sum)), __LINE__);
        }
        $this->Sum = $sum;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \App\Insis\StructType\CashPaymentDetail
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get PaymentNumber value
     * @return string|null
     */
    public function getPaymentNumber()
    {
        return $this->PaymentNumber;
    }
    /**
     * Set PaymentNumber value
     * @param string $paymentNumber
     * @return \App\Insis\StructType\CashPaymentDetail
     */
    public function setPaymentNumber($paymentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($paymentNumber) && !is_string($paymentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentNumber, true), gettype($paymentNumber)), __LINE__);
        }
        $this->PaymentNumber = $paymentNumber;
        return $this;
    }
    /**
     * Get NettingBool value
     * @return bool|null
     */
    public function getNettingBool()
    {
        return $this->NettingBool;
    }
    /**
     * Set NettingBool value
     * @param bool $nettingBool
     * @return \App\Insis\StructType\CashPaymentDetail
     */
    public function setNettingBool($nettingBool = null)
    {
        // validation for constraint: boolean
        if (!is_null($nettingBool) && !is_bool($nettingBool)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nettingBool, true), gettype($nettingBool)), __LINE__);
        }
        $this->NettingBool = $nettingBool;
        return $this;
    }
}
