<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashPayment StructType
 * Meta information extracted from the WSDL
 * - type: ns1:CashPayment
 * @subpackage Structs
 */
class CashPayment extends AbstractStructBase
{
    /**
     * The InsisID
     * @var int
     */
    public $InsisID;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * The OperationType
     * @var string
     */
    public $OperationType;
    /**
     * The DC
     * @var string
     */
    public $DC;
    /**
     * The CustomerID
     * @var int
     */
    public $CustomerID;
    /**
     * The BranchCode
     * @var int
     */
    public $BranchCode;
    /**
     * The DepCode
     * @var int
     */
    public $DepCode;
    /**
     * The PaymentDetails
     * @var string
     */
    public $PaymentDetails;
    /**
     * The Comment
     * @var string
     */
    public $Comment;
    /**
     * The Ammount
     * @var float
     */
    public $Ammount;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The IsCorrect
     * @var string
     */
    public $IsCorrect;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UserID;
    /**
     * The ArrayOfPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Insis\StructType\CashPaymentDetail[]
     */
    public $ArrayOfPayment;
    /**
     * Constructor method for CashPayment
     * @uses CashPayment::setInsisID()
     * @uses CashPayment::setDate()
     * @uses CashPayment::setNumber()
     * @uses CashPayment::setOperationType()
     * @uses CashPayment::setDC()
     * @uses CashPayment::setCustomerID()
     * @uses CashPayment::setBranchCode()
     * @uses CashPayment::setDepCode()
     * @uses CashPayment::setPaymentDetails()
     * @uses CashPayment::setComment()
     * @uses CashPayment::setAmmount()
     * @uses CashPayment::setCurrency()
     * @uses CashPayment::setIsCorrect()
     * @uses CashPayment::setUserID()
     * @uses CashPayment::setArrayOfPayment()
     * @param int $insisID
     * @param string $date
     * @param string $number
     * @param string $operationType
     * @param string $dC
     * @param int $customerID
     * @param int $branchCode
     * @param int $depCode
     * @param string $paymentDetails
     * @param string $comment
     * @param float $ammount
     * @param string $currency
     * @param string $isCorrect
     * @param int $userID
     * @param \App\Insis\StructType\CashPaymentDetail[] $arrayOfPayment
     */
    public function __construct($insisID = null, $date = null, $number = null, $operationType = null, $dC = null, $customerID = null, $branchCode = null, $depCode = null, $paymentDetails = null, $comment = null, $ammount = null, $currency = null, $isCorrect = null, $userID = null, array $arrayOfPayment = array())
    {
        $this
            ->setInsisID($insisID)
            ->setDate($date)
            ->setNumber($number)
            ->setOperationType($operationType)
            ->setDC($dC)
            ->setCustomerID($customerID)
            ->setBranchCode($branchCode)
            ->setDepCode($depCode)
            ->setPaymentDetails($paymentDetails)
            ->setComment($comment)
            ->setAmmount($ammount)
            ->setCurrency($currency)
            ->setIsCorrect($isCorrect)
            ->setUserID($userID)
            ->setArrayOfPayment($arrayOfPayment);
    }
    /**
     * Get InsisID value
     * @return int|null
     */
    public function getInsisID()
    {
        return $this->InsisID;
    }
    /**
     * Set InsisID value
     * @param int $insisID
     * @return \App\Insis\StructType\CashPayment
     */
    public function setInsisID($insisID = null)
    {
        // validation for constraint: int
        if (!is_null($insisID) && !(is_int($insisID) || ctype_digit($insisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insisID, true), gettype($insisID)), __LINE__);
        }
        $this->InsisID = $insisID;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \App\Insis\StructType\CashPayment
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \App\Insis\StructType\CashPayment
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get OperationType value
     * @return string|null
     */
    public function getOperationType()
    {
        return $this->OperationType;
    }
    /**
     * Set OperationType value
     * @param string $operationType
     * @return \App\Insis\StructType\CashPayment
     */
    public function setOperationType($operationType = null)
    {
        // validation for constraint: string
        if (!is_null($operationType) && !is_string($operationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationType, true), gettype($operationType)), __LINE__);
        }
        $this->OperationType = $operationType;
        return $this;
    }
    /**
     * Get DC value
     * @return string|null
     */
    public function getDC()
    {
        return $this->DC;
    }
    /**
     * Set DC value
     * @param string $dC
     * @return \App\Insis\StructType\CashPayment
     */
    public function setDC($dC = null)
    {
        // validation for constraint: string
        if (!is_null($dC) && !is_string($dC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dC, true), gettype($dC)), __LINE__);
        }
        $this->DC = $dC;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \App\Insis\StructType\CashPayment
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get BranchCode value
     * @return int|null
     */
    public function getBranchCode()
    {
        return $this->BranchCode;
    }
    /**
     * Set BranchCode value
     * @param int $branchCode
     * @return \App\Insis\StructType\CashPayment
     */
    public function setBranchCode($branchCode = null)
    {
        // validation for constraint: int
        if (!is_null($branchCode) && !(is_int($branchCode) || ctype_digit($branchCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchCode, true), gettype($branchCode)), __LINE__);
        }
        $this->BranchCode = $branchCode;
        return $this;
    }
    /**
     * Get DepCode value
     * @return int|null
     */
    public function getDepCode()
    {
        return $this->DepCode;
    }
    /**
     * Set DepCode value
     * @param int $depCode
     * @return \App\Insis\StructType\CashPayment
     */
    public function setDepCode($depCode = null)
    {
        // validation for constraint: int
        if (!is_null($depCode) && !(is_int($depCode) || ctype_digit($depCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($depCode, true), gettype($depCode)), __LINE__);
        }
        $this->DepCode = $depCode;
        return $this;
    }
    /**
     * Get PaymentDetails value
     * @return string|null
     */
    public function getPaymentDetails()
    {
        return $this->PaymentDetails;
    }
    /**
     * Set PaymentDetails value
     * @param string $paymentDetails
     * @return \App\Insis\StructType\CashPayment
     */
    public function setPaymentDetails($paymentDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDetails) && !is_string($paymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDetails, true), gettype($paymentDetails)), __LINE__);
        }
        $this->PaymentDetails = $paymentDetails;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \App\Insis\StructType\CashPayment
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Ammount value
     * @return float|null
     */
    public function getAmmount()
    {
        return $this->Ammount;
    }
    /**
     * Set Ammount value
     * @param float $ammount
     * @return \App\Insis\StructType\CashPayment
     */
    public function setAmmount($ammount = null)
    {
        // validation for constraint: float
        if (!is_null($ammount) && !(is_float($ammount) || is_numeric($ammount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ammount, true), gettype($ammount)), __LINE__);
        }
        $this->Ammount = $ammount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \App\Insis\StructType\CashPayment
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get IsCorrect value
     * @return string|null
     */
    public function getIsCorrect()
    {
        return $this->IsCorrect;
    }
    /**
     * Set IsCorrect value
     * @param string $isCorrect
     * @return \App\Insis\StructType\CashPayment
     */
    public function setIsCorrect($isCorrect = null)
    {
        // validation for constraint: string
        if (!is_null($isCorrect) && !is_string($isCorrect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isCorrect, true), gettype($isCorrect)), __LINE__);
        }
        $this->IsCorrect = $isCorrect;
        return $this;
    }
    /**
     * Get UserID value
     * @return int|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \App\Insis\StructType\CashPayment
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get ArrayOfPayment value
     * @return \App\Insis\StructType\CashPaymentDetail[]|null
     */
    public function getArrayOfPayment()
    {
        return $this->ArrayOfPayment;
    }
    /**
     * This method is responsible for validating the values passed to the setArrayOfPayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArrayOfPayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArrayOfPaymentForArrayConstraintsFromSetArrayOfPayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cashPaymentArrayOfPaymentItem) {
            // validation for constraint: itemType
            if (!$cashPaymentArrayOfPaymentItem instanceof \App\Insis\StructType\CashPaymentDetail) {
                $invalidValues[] = is_object($cashPaymentArrayOfPaymentItem) ? get_class($cashPaymentArrayOfPaymentItem) : sprintf('%s(%s)', gettype($cashPaymentArrayOfPaymentItem), var_export($cashPaymentArrayOfPaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ArrayOfPayment property can only contain items of type \App\Insis\StructType\CashPaymentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ArrayOfPayment value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\CashPaymentDetail[] $arrayOfPayment
     * @return \App\Insis\StructType\CashPayment
     */
    public function setArrayOfPayment(array $arrayOfPayment = array())
    {
        // validation for constraint: array
        if ('' !== ($arrayOfPaymentArrayErrorMessage = self::validateArrayOfPaymentForArrayConstraintsFromSetArrayOfPayment($arrayOfPayment))) {
            throw new \InvalidArgumentException($arrayOfPaymentArrayErrorMessage, __LINE__);
        }
        $this->ArrayOfPayment = $arrayOfPayment;
        return $this;
    }
    /**
     * Add item to ArrayOfPayment value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\CashPaymentDetail $item
     * @return \App\Insis\StructType\CashPayment
     */
    public function addToArrayOfPayment(\App\Insis\StructType\CashPaymentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\CashPaymentDetail) {
            throw new \InvalidArgumentException(sprintf('The ArrayOfPayment property can only contain items of type \App\Insis\StructType\CashPaymentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ArrayOfPayment[] = $item;
        return $this;
    }
}
