<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for calcOp_onai StructType
 * Meta information extracted from the WSDL
 * - type: tns:calcOp_onai
 * @subpackage Structs
 */
class CalcOp_onai extends AbstractStructBase
{
    /**
     * The aRegistrationCityID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aRegistrationCityID;
    /**
     * The aIINs
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $aIINs;
    /**
     * The aDiscount
     * @var bool
     */
    public $aDiscount;
    /**
     * Constructor method for calcOp_onai
     * @uses CalcOp_onai::setARegistrationCityID()
     * @uses CalcOp_onai::setAIINs()
     * @uses CalcOp_onai::setADiscount()
     * @param string $aRegistrationCityID
     * @param string[] $aIINs
     * @param bool $aDiscount
     */
    public function __construct($aRegistrationCityID = null, array $aIINs = array(), $aDiscount = null)
    {
        $this
            ->setARegistrationCityID($aRegistrationCityID)
            ->setAIINs($aIINs)
            ->setADiscount($aDiscount);
    }
    /**
     * Get aRegistrationCityID value
     * @return string|null
     */
    public function getARegistrationCityID()
    {
        return $this->aRegistrationCityID;
    }
    /**
     * Set aRegistrationCityID value
     * @param string $aRegistrationCityID
     * @return \App\Insis\StructType\CalcOp_onai
     */
    public function setARegistrationCityID($aRegistrationCityID = null)
    {
        // validation for constraint: string
        if (!is_null($aRegistrationCityID) && !is_string($aRegistrationCityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aRegistrationCityID, true), gettype($aRegistrationCityID)), __LINE__);
        }
        $this->aRegistrationCityID = $aRegistrationCityID;
        return $this;
    }
    /**
     * Get aIINs value
     * @return string[]|null
     */
    public function getAIINs()
    {
        return $this->aIINs;
    }
    /**
     * This method is responsible for validating the values passed to the setAIINs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAIINs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAIINsForArrayConstraintsFromSetAIINs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $calcOp_onaiAIINsItem) {
            // validation for constraint: itemType
            if (!is_string($calcOp_onaiAIINsItem)) {
                $invalidValues[] = is_object($calcOp_onaiAIINsItem) ? get_class($calcOp_onaiAIINsItem) : sprintf('%s(%s)', gettype($calcOp_onaiAIINsItem), var_export($calcOp_onaiAIINsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aIINs property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aIINs value
     * @throws \InvalidArgumentException
     * @param string[] $aIINs
     * @return \App\Insis\StructType\CalcOp_onai
     */
    public function setAIINs(array $aIINs = array())
    {
        // validation for constraint: array
        if ('' !== ($aIINsArrayErrorMessage = self::validateAIINsForArrayConstraintsFromSetAIINs($aIINs))) {
            throw new \InvalidArgumentException($aIINsArrayErrorMessage, __LINE__);
        }
        $this->aIINs = $aIINs;
        return $this;
    }
    /**
     * Add item to aIINs value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Insis\StructType\CalcOp_onai
     */
    public function addToAIINs($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The aIINs property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aIINs[] = $item;
        return $this;
    }
    /**
     * Get aDiscount value
     * @return bool|null
     */
    public function getADiscount()
    {
        return $this->aDiscount;
    }
    /**
     * Set aDiscount value
     * @param bool $aDiscount
     * @return \App\Insis\StructType\CalcOp_onai
     */
    public function setADiscount($aDiscount = null)
    {
        // validation for constraint: boolean
        if (!is_null($aDiscount) && !is_bool($aDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aDiscount, true), gettype($aDiscount)), __LINE__);
        }
        $this->aDiscount = $aDiscount;
        return $this;
    }
}
