<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for calcMst StructType
 * Meta information extracted from the WSDL
 * - type: tns:calcMst
 * @subpackage Structs
 */
class CalcMst extends AbstractStructBase
{
    /**
     * The aCoverType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aCoverType;
    /**
     * The aClients
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $aClients;
    /**
     * The aCountries
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $aCountries;
    /**
     * The aBeginDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aBeginDate;
    /**
     * The aEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $aEndDate;
    /**
     * The aCoverValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aCoverValue;
    /**
     * The aDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aDays;
    /**
     * The aFranchise
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aFranchise;
    /**
     * The aSportType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $aSportType;
    /**
     * The ac
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ac;
    /**
     * Constructor method for calcMst
     * @uses CalcMst::setACoverType()
     * @uses CalcMst::setAClients()
     * @uses CalcMst::setACountries()
     * @uses CalcMst::setABeginDate()
     * @uses CalcMst::setAEndDate()
     * @uses CalcMst::setACoverValue()
     * @uses CalcMst::setADays()
     * @uses CalcMst::setAFranchise()
     * @uses CalcMst::setASportType()
     * @uses CalcMst::setAc()
     * @param string $aCoverType
     * @param string[] $aClients
     * @param string[] $aCountries
     * @param string $aBeginDate
     * @param string $aEndDate
     * @param int $aCoverValue
     * @param int $aDays
     * @param int $aFranchise
     * @param int $aSportType
     * @param float $ac
     */
    public function __construct($aCoverType = null, array $aClients = array(), array $aCountries = array(), $aBeginDate = null, $aEndDate = null, $aCoverValue = null, $aDays = null, $aFranchise = null, $aSportType = null, $ac = null)
    {
        $this
            ->setACoverType($aCoverType)
            ->setAClients($aClients)
            ->setACountries($aCountries)
            ->setABeginDate($aBeginDate)
            ->setAEndDate($aEndDate)
            ->setACoverValue($aCoverValue)
            ->setADays($aDays)
            ->setAFranchise($aFranchise)
            ->setASportType($aSportType)
            ->setAc($ac);
    }
    /**
     * Get aCoverType value
     * @return string|null
     */
    public function getACoverType()
    {
        return $this->aCoverType;
    }
    /**
     * Set aCoverType value
     * @param string $aCoverType
     * @return \App\Insis\StructType\CalcMst
     */
    public function setACoverType($aCoverType = null)
    {
        // validation for constraint: string
        if (!is_null($aCoverType) && !is_string($aCoverType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCoverType, true), gettype($aCoverType)), __LINE__);
        }
        $this->aCoverType = $aCoverType;
        return $this;
    }
    /**
     * Get aClients value
     * @return string[]|null
     */
    public function getAClients()
    {
        return $this->aClients;
    }
    /**
     * This method is responsible for validating the values passed to the setAClients method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAClients method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAClientsForArrayConstraintsFromSetAClients(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $calcMstAClientsItem) {
            // validation for constraint: itemType
            if (!is_string($calcMstAClientsItem)) {
                $invalidValues[] = is_object($calcMstAClientsItem) ? get_class($calcMstAClientsItem) : sprintf('%s(%s)', gettype($calcMstAClientsItem), var_export($calcMstAClientsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aClients property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aClients value
     * @throws \InvalidArgumentException
     * @param string[] $aClients
     * @return \App\Insis\StructType\CalcMst
     */
    public function setAClients(array $aClients = array())
    {
        // validation for constraint: array
        if ('' !== ($aClientsArrayErrorMessage = self::validateAClientsForArrayConstraintsFromSetAClients($aClients))) {
            throw new \InvalidArgumentException($aClientsArrayErrorMessage, __LINE__);
        }
        $this->aClients = $aClients;
        return $this;
    }
    /**
     * Add item to aClients value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Insis\StructType\CalcMst
     */
    public function addToAClients($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The aClients property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aClients[] = $item;
        return $this;
    }
    /**
     * Get aCountries value
     * @return string[]|null
     */
    public function getACountries()
    {
        return $this->aCountries;
    }
    /**
     * This method is responsible for validating the values passed to the setACountries method
     * This method is willingly generated in order to preserve the one-line inline validation within the setACountries method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateACountriesForArrayConstraintsFromSetACountries(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $calcMstACountriesItem) {
            // validation for constraint: itemType
            if (!is_string($calcMstACountriesItem)) {
                $invalidValues[] = is_object($calcMstACountriesItem) ? get_class($calcMstACountriesItem) : sprintf('%s(%s)', gettype($calcMstACountriesItem), var_export($calcMstACountriesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aCountries property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aCountries value
     * @throws \InvalidArgumentException
     * @param string[] $aCountries
     * @return \App\Insis\StructType\CalcMst
     */
    public function setACountries(array $aCountries = array())
    {
        // validation for constraint: array
        if ('' !== ($aCountriesArrayErrorMessage = self::validateACountriesForArrayConstraintsFromSetACountries($aCountries))) {
            throw new \InvalidArgumentException($aCountriesArrayErrorMessage, __LINE__);
        }
        $this->aCountries = $aCountries;
        return $this;
    }
    /**
     * Add item to aCountries value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Insis\StructType\CalcMst
     */
    public function addToACountries($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The aCountries property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aCountries[] = $item;
        return $this;
    }
    /**
     * Get aBeginDate value
     * @return string|null
     */
    public function getABeginDate()
    {
        return $this->aBeginDate;
    }
    /**
     * Set aBeginDate value
     * @param string $aBeginDate
     * @return \App\Insis\StructType\CalcMst
     */
    public function setABeginDate($aBeginDate = null)
    {
        // validation for constraint: string
        if (!is_null($aBeginDate) && !is_string($aBeginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aBeginDate, true), gettype($aBeginDate)), __LINE__);
        }
        $this->aBeginDate = $aBeginDate;
        return $this;
    }
    /**
     * Get aEndDate value
     * @return string|null
     */
    public function getAEndDate()
    {
        return $this->aEndDate;
    }
    /**
     * Set aEndDate value
     * @param string $aEndDate
     * @return \App\Insis\StructType\CalcMst
     */
    public function setAEndDate($aEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($aEndDate) && !is_string($aEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aEndDate, true), gettype($aEndDate)), __LINE__);
        }
        $this->aEndDate = $aEndDate;
        return $this;
    }
    /**
     * Get aCoverValue value
     * @return int|null
     */
    public function getACoverValue()
    {
        return $this->aCoverValue;
    }
    /**
     * Set aCoverValue value
     * @param int $aCoverValue
     * @return \App\Insis\StructType\CalcMst
     */
    public function setACoverValue($aCoverValue = null)
    {
        // validation for constraint: int
        if (!is_null($aCoverValue) && !(is_int($aCoverValue) || ctype_digit($aCoverValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aCoverValue, true), gettype($aCoverValue)), __LINE__);
        }
        $this->aCoverValue = $aCoverValue;
        return $this;
    }
    /**
     * Get aDays value
     * @return int|null
     */
    public function getADays()
    {
        return $this->aDays;
    }
    /**
     * Set aDays value
     * @param int $aDays
     * @return \App\Insis\StructType\CalcMst
     */
    public function setADays($aDays = null)
    {
        // validation for constraint: int
        if (!is_null($aDays) && !(is_int($aDays) || ctype_digit($aDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aDays, true), gettype($aDays)), __LINE__);
        }
        $this->aDays = $aDays;
        return $this;
    }
    /**
     * Get aFranchise value
     * @return int|null
     */
    public function getAFranchise()
    {
        return $this->aFranchise;
    }
    /**
     * Set aFranchise value
     * @param int $aFranchise
     * @return \App\Insis\StructType\CalcMst
     */
    public function setAFranchise($aFranchise = null)
    {
        // validation for constraint: int
        if (!is_null($aFranchise) && !(is_int($aFranchise) || ctype_digit($aFranchise))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aFranchise, true), gettype($aFranchise)), __LINE__);
        }
        $this->aFranchise = $aFranchise;
        return $this;
    }
    /**
     * Get aSportType value
     * @return int|null
     */
    public function getASportType()
    {
        return $this->aSportType;
    }
    /**
     * Set aSportType value
     * @param int $aSportType
     * @return \App\Insis\StructType\CalcMst
     */
    public function setASportType($aSportType = null)
    {
        // validation for constraint: int
        if (!is_null($aSportType) && !(is_int($aSportType) || ctype_digit($aSportType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aSportType, true), gettype($aSportType)), __LINE__);
        }
        $this->aSportType = $aSportType;
        return $this;
    }
    /**
     * Get ac value
     * @return float|null
     */
    public function getAc()
    {
        return $this->ac;
    }
    /**
     * Set ac value
     * @param float $ac
     * @return \App\Insis\StructType\CalcMst
     */
    public function setAc($ac = null)
    {
        // validation for constraint: float
        if (!is_null($ac) && !(is_float($ac) || is_numeric($ac))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ac, true), gettype($ac)), __LINE__);
        }
        $this->ac = $ac;
        return $this;
    }
}
