<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for box StructType
 * @subpackage Structs
 */
class Box extends AbstractStructBase
{
    /**
     * The activateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $activateTime;
    /**
     * The agentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $agentID;
    /**
     * The autoBlank
     * @var bool
     */
    public $autoBlank;
    /**
     * The boxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $boxCode;
    /**
     * The boxID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $boxID;
    /**
     * The clientCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $clientCount;
    /**
     * The clients
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $clients;
    /**
     * The createdUserID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $createdUserID;
    /**
     * The insrType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insrType;
    /**
     * The insrValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $insrValue;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The objectID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $objectID;
    /**
     * The paid
     * @var bool
     */
    public $paid;
    /**
     * The prefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prefix;
    /**
     * The premium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $premium;
    /**
     * The recipientID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $recipientID;
    /**
     * The salesChanelID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $salesChanelID;
    /**
     * The variableParams
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $variableParams;
    /**
     * Constructor method for box
     * @uses Box::setActivateTime()
     * @uses Box::setAgentID()
     * @uses Box::setAutoBlank()
     * @uses Box::setBoxCode()
     * @uses Box::setBoxID()
     * @uses Box::setClientCount()
     * @uses Box::setClients()
     * @uses Box::setCreatedUserID()
     * @uses Box::setInsrType()
     * @uses Box::setInsrValue()
     * @uses Box::setNumber()
     * @uses Box::setObjectID()
     * @uses Box::setPaid()
     * @uses Box::setPrefix()
     * @uses Box::setPremium()
     * @uses Box::setRecipientID()
     * @uses Box::setSalesChanelID()
     * @uses Box::setVariableParams()
     * @param int $activateTime
     * @param int $agentID
     * @param bool $autoBlank
     * @param string $boxCode
     * @param int $boxID
     * @param int $clientCount
     * @param int[] $clients
     * @param int $createdUserID
     * @param string $insrType
     * @param float $insrValue
     * @param string $number
     * @param int $objectID
     * @param bool $paid
     * @param string $prefix
     * @param float $premium
     * @param int $recipientID
     * @param int $salesChanelID
     * @param \App\Insis\StructType\ObjectParam[] $variableParams
     */
    public function __construct($activateTime = null, $agentID = null, $autoBlank = null, $boxCode = null, $boxID = null, $clientCount = null, array $clients = array(), $createdUserID = null, $insrType = null, $insrValue = null, $number = null, $objectID = null, $paid = null, $prefix = null, $premium = null, $recipientID = null, $salesChanelID = null, array $variableParams = array())
    {
        $this
            ->setActivateTime($activateTime)
            ->setAgentID($agentID)
            ->setAutoBlank($autoBlank)
            ->setBoxCode($boxCode)
            ->setBoxID($boxID)
            ->setClientCount($clientCount)
            ->setClients($clients)
            ->setCreatedUserID($createdUserID)
            ->setInsrType($insrType)
            ->setInsrValue($insrValue)
            ->setNumber($number)
            ->setObjectID($objectID)
            ->setPaid($paid)
            ->setPrefix($prefix)
            ->setPremium($premium)
            ->setRecipientID($recipientID)
            ->setSalesChanelID($salesChanelID)
            ->setVariableParams($variableParams);
    }
    /**
     * Get activateTime value
     * @return int|null
     */
    public function getActivateTime()
    {
        return $this->activateTime;
    }
    /**
     * Set activateTime value
     * @param int $activateTime
     * @return \App\Insis\StructType\Box
     */
    public function setActivateTime($activateTime = null)
    {
        // validation for constraint: int
        if (!is_null($activateTime) && !(is_int($activateTime) || ctype_digit($activateTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($activateTime, true), gettype($activateTime)), __LINE__);
        }
        $this->activateTime = $activateTime;
        return $this;
    }
    /**
     * Get agentID value
     * @return int|null
     */
    public function getAgentID()
    {
        return $this->agentID;
    }
    /**
     * Set agentID value
     * @param int $agentID
     * @return \App\Insis\StructType\Box
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: int
        if (!is_null($agentID) && !(is_int($agentID) || ctype_digit($agentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agentID, true), gettype($agentID)), __LINE__);
        }
        $this->agentID = $agentID;
        return $this;
    }
    /**
     * Get autoBlank value
     * @return bool|null
     */
    public function getAutoBlank()
    {
        return $this->autoBlank;
    }
    /**
     * Set autoBlank value
     * @param bool $autoBlank
     * @return \App\Insis\StructType\Box
     */
    public function setAutoBlank($autoBlank = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoBlank) && !is_bool($autoBlank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoBlank, true), gettype($autoBlank)), __LINE__);
        }
        $this->autoBlank = $autoBlank;
        return $this;
    }
    /**
     * Get boxCode value
     * @return string|null
     */
    public function getBoxCode()
    {
        return $this->boxCode;
    }
    /**
     * Set boxCode value
     * @param string $boxCode
     * @return \App\Insis\StructType\Box
     */
    public function setBoxCode($boxCode = null)
    {
        // validation for constraint: string
        if (!is_null($boxCode) && !is_string($boxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boxCode, true), gettype($boxCode)), __LINE__);
        }
        $this->boxCode = $boxCode;
        return $this;
    }
    /**
     * Get boxID value
     * @return int|null
     */
    public function getBoxID()
    {
        return $this->boxID;
    }
    /**
     * Set boxID value
     * @param int $boxID
     * @return \App\Insis\StructType\Box
     */
    public function setBoxID($boxID = null)
    {
        // validation for constraint: int
        if (!is_null($boxID) && !(is_int($boxID) || ctype_digit($boxID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boxID, true), gettype($boxID)), __LINE__);
        }
        $this->boxID = $boxID;
        return $this;
    }
    /**
     * Get clientCount value
     * @return int|null
     */
    public function getClientCount()
    {
        return $this->clientCount;
    }
    /**
     * Set clientCount value
     * @param int $clientCount
     * @return \App\Insis\StructType\Box
     */
    public function setClientCount($clientCount = null)
    {
        // validation for constraint: int
        if (!is_null($clientCount) && !(is_int($clientCount) || ctype_digit($clientCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientCount, true), gettype($clientCount)), __LINE__);
        }
        $this->clientCount = $clientCount;
        return $this;
    }
    /**
     * Get clients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getClients()
    {
        return isset($this->clients) ? $this->clients : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClients method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClients method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClientsForArrayConstraintsFromSetClients(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $boxClientsItem) {
            // validation for constraint: itemType
            if (!(is_int($boxClientsItem) || ctype_digit($boxClientsItem))) {
                $invalidValues[] = is_object($boxClientsItem) ? get_class($boxClientsItem) : sprintf('%s(%s)', gettype($boxClientsItem), var_export($boxClientsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The clients property can only contain items of type long, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set clients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $clients
     * @return \App\Insis\StructType\Box
     */
    public function setClients(array $clients = array())
    {
        // validation for constraint: array
        if ('' !== ($clientsArrayErrorMessage = self::validateClientsForArrayConstraintsFromSetClients($clients))) {
            throw new \InvalidArgumentException($clientsArrayErrorMessage, __LINE__);
        }
        if (is_null($clients) || (is_array($clients) && empty($clients))) {
            unset($this->clients);
        } else {
            $this->clients = $clients;
        }
        return $this;
    }
    /**
     * Add item to clients value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \App\Insis\StructType\Box
     */
    public function addToClients($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The clients property can only contain items of type long, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->clients[] = $item;
        return $this;
    }
    /**
     * Get createdUserID value
     * @return int|null
     */
    public function getCreatedUserID()
    {
        return $this->createdUserID;
    }
    /**
     * Set createdUserID value
     * @param int $createdUserID
     * @return \App\Insis\StructType\Box
     */
    public function setCreatedUserID($createdUserID = null)
    {
        // validation for constraint: int
        if (!is_null($createdUserID) && !(is_int($createdUserID) || ctype_digit($createdUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($createdUserID, true), gettype($createdUserID)), __LINE__);
        }
        $this->createdUserID = $createdUserID;
        return $this;
    }
    /**
     * Get insrType value
     * @return string|null
     */
    public function getInsrType()
    {
        return $this->insrType;
    }
    /**
     * Set insrType value
     * @param string $insrType
     * @return \App\Insis\StructType\Box
     */
    public function setInsrType($insrType = null)
    {
        // validation for constraint: string
        if (!is_null($insrType) && !is_string($insrType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insrType, true), gettype($insrType)), __LINE__);
        }
        $this->insrType = $insrType;
        return $this;
    }
    /**
     * Get insrValue value
     * @return float|null
     */
    public function getInsrValue()
    {
        return $this->insrValue;
    }
    /**
     * Set insrValue value
     * @param float $insrValue
     * @return \App\Insis\StructType\Box
     */
    public function setInsrValue($insrValue = null)
    {
        // validation for constraint: float
        if (!is_null($insrValue) && !(is_float($insrValue) || is_numeric($insrValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insrValue, true), gettype($insrValue)), __LINE__);
        }
        $this->insrValue = $insrValue;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \App\Insis\StructType\Box
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get objectID value
     * @return int|null
     */
    public function getObjectID()
    {
        return $this->objectID;
    }
    /**
     * Set objectID value
     * @param int $objectID
     * @return \App\Insis\StructType\Box
     */
    public function setObjectID($objectID = null)
    {
        // validation for constraint: int
        if (!is_null($objectID) && !(is_int($objectID) || ctype_digit($objectID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectID, true), gettype($objectID)), __LINE__);
        }
        $this->objectID = $objectID;
        return $this;
    }
    /**
     * Get paid value
     * @return bool|null
     */
    public function getPaid()
    {
        return $this->paid;
    }
    /**
     * Set paid value
     * @param bool $paid
     * @return \App\Insis\StructType\Box
     */
    public function setPaid($paid = null)
    {
        // validation for constraint: boolean
        if (!is_null($paid) && !is_bool($paid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paid, true), gettype($paid)), __LINE__);
        }
        $this->paid = $paid;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \App\Insis\StructType\Box
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get premium value
     * @return float|null
     */
    public function getPremium()
    {
        return $this->premium;
    }
    /**
     * Set premium value
     * @param float $premium
     * @return \App\Insis\StructType\Box
     */
    public function setPremium($premium = null)
    {
        // validation for constraint: float
        if (!is_null($premium) && !(is_float($premium) || is_numeric($premium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premium, true), gettype($premium)), __LINE__);
        }
        $this->premium = $premium;
        return $this;
    }
    /**
     * Get recipientID value
     * @return int|null
     */
    public function getRecipientID()
    {
        return $this->recipientID;
    }
    /**
     * Set recipientID value
     * @param int $recipientID
     * @return \App\Insis\StructType\Box
     */
    public function setRecipientID($recipientID = null)
    {
        // validation for constraint: int
        if (!is_null($recipientID) && !(is_int($recipientID) || ctype_digit($recipientID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recipientID, true), gettype($recipientID)), __LINE__);
        }
        $this->recipientID = $recipientID;
        return $this;
    }
    /**
     * Get salesChanelID value
     * @return int|null
     */
    public function getSalesChanelID()
    {
        return $this->salesChanelID;
    }
    /**
     * Set salesChanelID value
     * @param int $salesChanelID
     * @return \App\Insis\StructType\Box
     */
    public function setSalesChanelID($salesChanelID = null)
    {
        // validation for constraint: int
        if (!is_null($salesChanelID) && !(is_int($salesChanelID) || ctype_digit($salesChanelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($salesChanelID, true), gettype($salesChanelID)), __LINE__);
        }
        $this->salesChanelID = $salesChanelID;
        return $this;
    }
    /**
     * Get variableParams value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getVariableParams()
    {
        return isset($this->variableParams) ? $this->variableParams : null;
    }
    /**
     * This method is responsible for validating the values passed to the setVariableParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVariableParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVariableParamsForArrayConstraintsFromSetVariableParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $boxVariableParamsItem) {
            // validation for constraint: itemType
            if (!$boxVariableParamsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($boxVariableParamsItem) ? get_class($boxVariableParamsItem) : sprintf('%s(%s)', gettype($boxVariableParamsItem), var_export($boxVariableParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The variableParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set variableParams value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $variableParams
     * @return \App\Insis\StructType\Box
     */
    public function setVariableParams(array $variableParams = array())
    {
        // validation for constraint: array
        if ('' !== ($variableParamsArrayErrorMessage = self::validateVariableParamsForArrayConstraintsFromSetVariableParams($variableParams))) {
            throw new \InvalidArgumentException($variableParamsArrayErrorMessage, __LINE__);
        }
        if (is_null($variableParams) || (is_array($variableParams) && empty($variableParams))) {
            unset($this->variableParams);
        } else {
            $this->variableParams = $variableParams;
        }
        return $this;
    }
    /**
     * Add item to variableParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\Box
     */
    public function addToVariableParams(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The variableParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->variableParams[] = $item;
        return $this;
    }
}
