<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for billList StructType
 * @subpackage Structs
 */
class BillList extends AbstractStructBase
{
    /**
     * The billTotalCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $billTotalCount;
    /**
     * The bills
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\Bill[]
     */
    public $bills;
    /**
     * Constructor method for billList
     * @uses BillList::setBillTotalCount()
     * @uses BillList::setBills()
     * @param int $billTotalCount
     * @param \App\Insis\StructType\Bill[] $bills
     */
    public function __construct($billTotalCount = null, array $bills = array())
    {
        $this
            ->setBillTotalCount($billTotalCount)
            ->setBills($bills);
    }
    /**
     * Get billTotalCount value
     * @return int|null
     */
    public function getBillTotalCount()
    {
        return $this->billTotalCount;
    }
    /**
     * Set billTotalCount value
     * @param int $billTotalCount
     * @return \App\Insis\StructType\BillList
     */
    public function setBillTotalCount($billTotalCount = null)
    {
        // validation for constraint: int
        if (!is_null($billTotalCount) && !(is_int($billTotalCount) || ctype_digit($billTotalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($billTotalCount, true), gettype($billTotalCount)), __LINE__);
        }
        $this->billTotalCount = $billTotalCount;
        return $this;
    }
    /**
     * Get bills value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\Bill[]|null
     */
    public function getBills()
    {
        return isset($this->bills) ? $this->bills : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBills method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBills method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillsForArrayConstraintsFromSetBills(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billListBillsItem) {
            // validation for constraint: itemType
            if (!$billListBillsItem instanceof \App\Insis\StructType\Bill) {
                $invalidValues[] = is_object($billListBillsItem) ? get_class($billListBillsItem) : sprintf('%s(%s)', gettype($billListBillsItem), var_export($billListBillsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bills property can only contain items of type \App\Insis\StructType\Bill, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bills value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Bill[] $bills
     * @return \App\Insis\StructType\BillList
     */
    public function setBills(array $bills = array())
    {
        // validation for constraint: array
        if ('' !== ($billsArrayErrorMessage = self::validateBillsForArrayConstraintsFromSetBills($bills))) {
            throw new \InvalidArgumentException($billsArrayErrorMessage, __LINE__);
        }
        if (is_null($bills) || (is_array($bills) && empty($bills))) {
            unset($this->bills);
        } else {
            $this->bills = $bills;
        }
        return $this;
    }
    /**
     * Add item to bills value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\Bill $item
     * @return \App\Insis\StructType\BillList
     */
    public function addToBills(\App\Insis\StructType\Bill $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\Bill) {
            throw new \InvalidArgumentException(sprintf('The bills property can only contain items of type \App\Insis\StructType\Bill, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bills[] = $item;
        return $this;
    }
}
