<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for billDetails StructType
 * @subpackage Structs
 */
class BillDetails extends AbstractStructBase
{
    /**
     * The amnt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amnt;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyID;
    /**
     * Constructor method for billDetails
     * @uses BillDetails::setAmnt()
     * @uses BillDetails::setPolicyID()
     * @param float $amnt
     * @param int $policyID
     */
    public function __construct($amnt = null, $policyID = null)
    {
        $this
            ->setAmnt($amnt)
            ->setPolicyID($policyID);
    }
    /**
     * Get amnt value
     * @return float|null
     */
    public function getAmnt()
    {
        return $this->amnt;
    }
    /**
     * Set amnt value
     * @param float $amnt
     * @return \App\Insis\StructType\BillDetails
     */
    public function setAmnt($amnt = null)
    {
        // validation for constraint: float
        if (!is_null($amnt) && !(is_float($amnt) || is_numeric($amnt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amnt, true), gettype($amnt)), __LINE__);
        }
        $this->amnt = $amnt;
        return $this;
    }
    /**
     * Get policyID value
     * @return int|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param int $policyID
     * @return \App\Insis\StructType\BillDetails
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: int
        if (!is_null($policyID) && !(is_int($policyID) || ctype_digit($policyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
}
