<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bill StructType
 * @subpackage Structs
 */
class Bill extends AbstractStructBase
{
    /**
     * The billDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billDate;
    /**
     * The billID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $billID;
    /**
     * The billNO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billNO;
    /**
     * The billType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billType;
    /**
     * The details
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\BillDetails[]
     */
    public $details;
    /**
     * The ownerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ownerID;
    /**
     * The paymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentType;
    /**
     * Constructor method for bill
     * @uses Bill::setBillDate()
     * @uses Bill::setBillID()
     * @uses Bill::setBillNO()
     * @uses Bill::setBillType()
     * @uses Bill::setDetails()
     * @uses Bill::setOwnerID()
     * @uses Bill::setPaymentType()
     * @param string $billDate
     * @param int $billID
     * @param string $billNO
     * @param string $billType
     * @param \App\Insis\StructType\BillDetails[] $details
     * @param int $ownerID
     * @param string $paymentType
     */
    public function __construct($billDate = null, $billID = null, $billNO = null, $billType = null, array $details = array(), $ownerID = null, $paymentType = null)
    {
        $this
            ->setBillDate($billDate)
            ->setBillID($billID)
            ->setBillNO($billNO)
            ->setBillType($billType)
            ->setDetails($details)
            ->setOwnerID($ownerID)
            ->setPaymentType($paymentType);
    }
    /**
     * Get billDate value
     * @return string|null
     */
    public function getBillDate()
    {
        return $this->billDate;
    }
    /**
     * Set billDate value
     * @param string $billDate
     * @return \App\Insis\StructType\Bill
     */
    public function setBillDate($billDate = null)
    {
        // validation for constraint: string
        if (!is_null($billDate) && !is_string($billDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billDate, true), gettype($billDate)), __LINE__);
        }
        $this->billDate = $billDate;
        return $this;
    }
    /**
     * Get billID value
     * @return int|null
     */
    public function getBillID()
    {
        return $this->billID;
    }
    /**
     * Set billID value
     * @param int $billID
     * @return \App\Insis\StructType\Bill
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !(is_int($billID) || ctype_digit($billID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($billID, true), gettype($billID)), __LINE__);
        }
        $this->billID = $billID;
        return $this;
    }
    /**
     * Get billNO value
     * @return string|null
     */
    public function getBillNO()
    {
        return $this->billNO;
    }
    /**
     * Set billNO value
     * @param string $billNO
     * @return \App\Insis\StructType\Bill
     */
    public function setBillNO($billNO = null)
    {
        // validation for constraint: string
        if (!is_null($billNO) && !is_string($billNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billNO, true), gettype($billNO)), __LINE__);
        }
        $this->billNO = $billNO;
        return $this;
    }
    /**
     * Get billType value
     * @return string|null
     */
    public function getBillType()
    {
        return $this->billType;
    }
    /**
     * Set billType value
     * @param string $billType
     * @return \App\Insis\StructType\Bill
     */
    public function setBillType($billType = null)
    {
        // validation for constraint: string
        if (!is_null($billType) && !is_string($billType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billType, true), gettype($billType)), __LINE__);
        }
        $this->billType = $billType;
        return $this;
    }
    /**
     * Get details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\BillDetails[]|null
     */
    public function getDetails()
    {
        return isset($this->details) ? $this->details : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetailsForArrayConstraintsFromSetDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $billDetailsItem) {
            // validation for constraint: itemType
            if (!$billDetailsItem instanceof \App\Insis\StructType\BillDetails) {
                $invalidValues[] = is_object($billDetailsItem) ? get_class($billDetailsItem) : sprintf('%s(%s)', gettype($billDetailsItem), var_export($billDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The details property can only contain items of type \App\Insis\StructType\BillDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\BillDetails[] $details
     * @return \App\Insis\StructType\Bill
     */
    public function setDetails(array $details = array())
    {
        // validation for constraint: array
        if ('' !== ($detailsArrayErrorMessage = self::validateDetailsForArrayConstraintsFromSetDetails($details))) {
            throw new \InvalidArgumentException($detailsArrayErrorMessage, __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->details);
        } else {
            $this->details = $details;
        }
        return $this;
    }
    /**
     * Add item to details value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\BillDetails $item
     * @return \App\Insis\StructType\Bill
     */
    public function addToDetails(\App\Insis\StructType\BillDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\BillDetails) {
            throw new \InvalidArgumentException(sprintf('The details property can only contain items of type \App\Insis\StructType\BillDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->details[] = $item;
        return $this;
    }
    /**
     * Get ownerID value
     * @return int|null
     */
    public function getOwnerID()
    {
        return $this->ownerID;
    }
    /**
     * Set ownerID value
     * @param int $ownerID
     * @return \App\Insis\StructType\Bill
     */
    public function setOwnerID($ownerID = null)
    {
        // validation for constraint: int
        if (!is_null($ownerID) && !(is_int($ownerID) || ctype_digit($ownerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ownerID, true), gettype($ownerID)), __LINE__);
        }
        $this->ownerID = $ownerID;
        return $this;
    }
    /**
     * Get paymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param string $paymentType
     * @return \App\Insis\StructType\Bill
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
}
