<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for attachment StructType
 * @subpackage Structs
 */
class Attachment extends AbstractStructBase
{
    /**
     * The attachment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $attachment;
    /**
     * The attachmentDesc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $attachmentDesc;
    /**
     * The attachmentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $attachmentId;
    /**
     * The attachmentName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $attachmentName;
    /**
     * The fileExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fileExtension;
    /**
     * Constructor method for attachment
     * @uses Attachment::setAttachment()
     * @uses Attachment::setAttachmentDesc()
     * @uses Attachment::setAttachmentId()
     * @uses Attachment::setAttachmentName()
     * @uses Attachment::setFileExtension()
     * @param string $attachment
     * @param string $attachmentDesc
     * @param int $attachmentId
     * @param string $attachmentName
     * @param string $fileExtension
     */
    public function __construct($attachment = null, $attachmentDesc = null, $attachmentId = null, $attachmentName = null, $fileExtension = null)
    {
        $this
            ->setAttachment($attachment)
            ->setAttachmentDesc($attachmentDesc)
            ->setAttachmentId($attachmentId)
            ->setAttachmentName($attachmentName)
            ->setFileExtension($fileExtension);
    }
    /**
     * Get attachment value
     * @return string|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * Set attachment value
     * @param string $attachment
     * @return \App\Insis\StructType\Attachment
     */
    public function setAttachment($attachment = null)
    {
        // validation for constraint: string
        if (!is_null($attachment) && !is_string($attachment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachment, true), gettype($attachment)), __LINE__);
        }
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Get attachmentDesc value
     * @return string|null
     */
    public function getAttachmentDesc()
    {
        return $this->attachmentDesc;
    }
    /**
     * Set attachmentDesc value
     * @param string $attachmentDesc
     * @return \App\Insis\StructType\Attachment
     */
    public function setAttachmentDesc($attachmentDesc = null)
    {
        // validation for constraint: string
        if (!is_null($attachmentDesc) && !is_string($attachmentDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachmentDesc, true), gettype($attachmentDesc)), __LINE__);
        }
        $this->attachmentDesc = $attachmentDesc;
        return $this;
    }
    /**
     * Get attachmentId value
     * @return int|null
     */
    public function getAttachmentId()
    {
        return $this->attachmentId;
    }
    /**
     * Set attachmentId value
     * @param int $attachmentId
     * @return \App\Insis\StructType\Attachment
     */
    public function setAttachmentId($attachmentId = null)
    {
        // validation for constraint: int
        if (!is_null($attachmentId) && !(is_int($attachmentId) || ctype_digit($attachmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attachmentId, true), gettype($attachmentId)), __LINE__);
        }
        $this->attachmentId = $attachmentId;
        return $this;
    }
    /**
     * Get attachmentName value
     * @return string|null
     */
    public function getAttachmentName()
    {
        return $this->attachmentName;
    }
    /**
     * Set attachmentName value
     * @param string $attachmentName
     * @return \App\Insis\StructType\Attachment
     */
    public function setAttachmentName($attachmentName = null)
    {
        // validation for constraint: string
        if (!is_null($attachmentName) && !is_string($attachmentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachmentName, true), gettype($attachmentName)), __LINE__);
        }
        $this->attachmentName = $attachmentName;
        return $this;
    }
    /**
     * Get fileExtension value
     * @return string|null
     */
    public function getFileExtension()
    {
        return $this->fileExtension;
    }
    /**
     * Set fileExtension value
     * @param string $fileExtension
     * @return \App\Insis\StructType\Attachment
     */
    public function setFileExtension($fileExtension = null)
    {
        // validation for constraint: string
        if (!is_null($fileExtension) && !is_string($fileExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileExtension, true), gettype($fileExtension)), __LINE__);
        }
        $this->fileExtension = $fileExtension;
        return $this;
    }
}
