<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for archivePolicyDetails StructType
 * @subpackage Structs
 */
class ArchivePolicyDetails extends AbstractStructBase
{
    /**
     * The AR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AR;
    /**
     * The annexId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $annexId;
    /**
     * The blankNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blankNumber;
    /**
     * The blankPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blankPrefix;
    /**
     * The chanelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $chanelId;
    /**
     * The clientId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $clientId;
    /**
     * The descr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descr;
    /**
     * The documents
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $documents;
    /**
     * The listNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $listNumber;
    /**
     * The policyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyId;
    /**
     * Constructor method for archivePolicyDetails
     * @uses ArchivePolicyDetails::setAR()
     * @uses ArchivePolicyDetails::setAnnexId()
     * @uses ArchivePolicyDetails::setBlankNumber()
     * @uses ArchivePolicyDetails::setBlankPrefix()
     * @uses ArchivePolicyDetails::setChanelId()
     * @uses ArchivePolicyDetails::setClientId()
     * @uses ArchivePolicyDetails::setDescr()
     * @uses ArchivePolicyDetails::setDocuments()
     * @uses ArchivePolicyDetails::setListNumber()
     * @uses ArchivePolicyDetails::setPolicyId()
     * @param string $aR
     * @param int $annexId
     * @param string $blankNumber
     * @param string $blankPrefix
     * @param int $chanelId
     * @param int $clientId
     * @param string $descr
     * @param \App\Insis\StructType\ObjectParam[] $documents
     * @param int $listNumber
     * @param int $policyId
     */
    public function __construct($aR = null, $annexId = null, $blankNumber = null, $blankPrefix = null, $chanelId = null, $clientId = null, $descr = null, array $documents = array(), $listNumber = null, $policyId = null)
    {
        $this
            ->setAR($aR)
            ->setAnnexId($annexId)
            ->setBlankNumber($blankNumber)
            ->setBlankPrefix($blankPrefix)
            ->setChanelId($chanelId)
            ->setClientId($clientId)
            ->setDescr($descr)
            ->setDocuments($documents)
            ->setListNumber($listNumber)
            ->setPolicyId($policyId);
    }
    /**
     * Get AR value
     * @return string|null
     */
    public function getAR()
    {
        return $this->AR;
    }
    /**
     * Set AR value
     * @param string $aR
     * @return \App\Insis\StructType\ArchivePolicyDetails
     */
    public function setAR($aR = null)
    {
        // validation for constraint: string
        if (!is_null($aR) && !is_string($aR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aR, true), gettype($aR)), __LINE__);
        }
        $this->AR = $aR;
        return $this;
    }
    /**
     * Get annexId value
     * @return int|null
     */
    public function getAnnexId()
    {
        return $this->annexId;
    }
    /**
     * Set annexId value
     * @param int $annexId
     * @return \App\Insis\StructType\ArchivePolicyDetails
     */
    public function setAnnexId($annexId = null)
    {
        // validation for constraint: int
        if (!is_null($annexId) && !(is_int($annexId) || ctype_digit($annexId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($annexId, true), gettype($annexId)), __LINE__);
        }
        $this->annexId = $annexId;
        return $this;
    }
    /**
     * Get blankNumber value
     * @return string|null
     */
    public function getBlankNumber()
    {
        return $this->blankNumber;
    }
    /**
     * Set blankNumber value
     * @param string $blankNumber
     * @return \App\Insis\StructType\ArchivePolicyDetails
     */
    public function setBlankNumber($blankNumber = null)
    {
        // validation for constraint: string
        if (!is_null($blankNumber) && !is_string($blankNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blankNumber, true), gettype($blankNumber)), __LINE__);
        }
        $this->blankNumber = $blankNumber;
        return $this;
    }
    /**
     * Get blankPrefix value
     * @return string|null
     */
    public function getBlankPrefix()
    {
        return $this->blankPrefix;
    }
    /**
     * Set blankPrefix value
     * @param string $blankPrefix
     * @return \App\Insis\StructType\ArchivePolicyDetails
     */
    public function setBlankPrefix($blankPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($blankPrefix) && !is_string($blankPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blankPrefix, true), gettype($blankPrefix)), __LINE__);
        }
        $this->blankPrefix = $blankPrefix;
        return $this;
    }
    /**
     * Get chanelId value
     * @return int|null
     */
    public function getChanelId()
    {
        return $this->chanelId;
    }
    /**
     * Set chanelId value
     * @param int $chanelId
     * @return \App\Insis\StructType\ArchivePolicyDetails
     */
    public function setChanelId($chanelId = null)
    {
        // validation for constraint: int
        if (!is_null($chanelId) && !(is_int($chanelId) || ctype_digit($chanelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chanelId, true), gettype($chanelId)), __LINE__);
        }
        $this->chanelId = $chanelId;
        return $this;
    }
    /**
     * Get clientId value
     * @return int|null
     */
    public function getClientId()
    {
        return $this->clientId;
    }
    /**
     * Set clientId value
     * @param int $clientId
     * @return \App\Insis\StructType\ArchivePolicyDetails
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: int
        if (!is_null($clientId) && !(is_int($clientId) || ctype_digit($clientId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        $this->clientId = $clientId;
        return $this;
    }
    /**
     * Get descr value
     * @return string|null
     */
    public function getDescr()
    {
        return $this->descr;
    }
    /**
     * Set descr value
     * @param string $descr
     * @return \App\Insis\StructType\ArchivePolicyDetails
     */
    public function setDescr($descr = null)
    {
        // validation for constraint: string
        if (!is_null($descr) && !is_string($descr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descr, true), gettype($descr)), __LINE__);
        }
        $this->descr = $descr;
        return $this;
    }
    /**
     * Get documents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getDocuments()
    {
        return isset($this->documents) ? $this->documents : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocuments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocuments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentsForArrayConstraintsFromSetDocuments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $archivePolicyDetailsDocumentsItem) {
            // validation for constraint: itemType
            if (!$archivePolicyDetailsDocumentsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($archivePolicyDetailsDocumentsItem) ? get_class($archivePolicyDetailsDocumentsItem) : sprintf('%s(%s)', gettype($archivePolicyDetailsDocumentsItem), var_export($archivePolicyDetailsDocumentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The documents property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set documents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $documents
     * @return \App\Insis\StructType\ArchivePolicyDetails
     */
    public function setDocuments(array $documents = array())
    {
        // validation for constraint: array
        if ('' !== ($documentsArrayErrorMessage = self::validateDocumentsForArrayConstraintsFromSetDocuments($documents))) {
            throw new \InvalidArgumentException($documentsArrayErrorMessage, __LINE__);
        }
        if (is_null($documents) || (is_array($documents) && empty($documents))) {
            unset($this->documents);
        } else {
            $this->documents = $documents;
        }
        return $this;
    }
    /**
     * Add item to documents value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\ArchivePolicyDetails
     */
    public function addToDocuments(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The documents property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->documents[] = $item;
        return $this;
    }
    /**
     * Get listNumber value
     * @return int|null
     */
    public function getListNumber()
    {
        return $this->listNumber;
    }
    /**
     * Set listNumber value
     * @param int $listNumber
     * @return \App\Insis\StructType\ArchivePolicyDetails
     */
    public function setListNumber($listNumber = null)
    {
        // validation for constraint: int
        if (!is_null($listNumber) && !(is_int($listNumber) || ctype_digit($listNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($listNumber, true), gettype($listNumber)), __LINE__);
        }
        $this->listNumber = $listNumber;
        return $this;
    }
    /**
     * Get policyId value
     * @return int|null
     */
    public function getPolicyId()
    {
        return $this->policyId;
    }
    /**
     * Set policyId value
     * @param int $policyId
     * @return \App\Insis\StructType\ArchivePolicyDetails
     */
    public function setPolicyId($policyId = null)
    {
        // validation for constraint: int
        if (!is_null($policyId) && !(is_int($policyId) || ctype_digit($policyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyId, true), gettype($policyId)), __LINE__);
        }
        $this->policyId = $policyId;
        return $this;
    }
}
