<?php

namespace App\Insis\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for application StructType
 * @subpackage Structs
 */
class Application extends AbstractStructBase
{
    /**
     * The additionalMaxValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $additionalMaxValue;
    /**
     * The additionalMinValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $additionalMinValue;
    /**
     * The aditionalActions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\AditionalApp[]
     */
    public $aditionalActions;
    /**
     * The appGiftAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $appGiftAmount;
    /**
     * The appID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $appID;
    /**
     * The appName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $appName;
    /**
     * The autoBlank
     * @var bool
     */
    public $autoBlank;
    /**
     * The blanks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\PolicyBlanks[]
     */
    public $blanks;
    /**
     * The discount
     * @var bool
     */
    public $discount;
    /**
     * The duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $duration;
    /**
     * The objectNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $objectNum;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyID;
    /**
     * The printed
     * @var bool
     */
    public $printed;
    /**
     * The variableParams
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Insis\StructType\ObjectParam[]
     */
    public $variableParams;
    /**
     * Constructor method for application
     * @uses Application::setAdditionalMaxValue()
     * @uses Application::setAdditionalMinValue()
     * @uses Application::setAditionalActions()
     * @uses Application::setAppGiftAmount()
     * @uses Application::setAppID()
     * @uses Application::setAppName()
     * @uses Application::setAutoBlank()
     * @uses Application::setBlanks()
     * @uses Application::setDiscount()
     * @uses Application::setDuration()
     * @uses Application::setObjectNum()
     * @uses Application::setPolicyID()
     * @uses Application::setPrinted()
     * @uses Application::setVariableParams()
     * @param int $additionalMaxValue
     * @param int $additionalMinValue
     * @param \App\Insis\StructType\AditionalApp[] $aditionalActions
     * @param float $appGiftAmount
     * @param int $appID
     * @param string $appName
     * @param bool $autoBlank
     * @param \App\Insis\StructType\PolicyBlanks[] $blanks
     * @param bool $discount
     * @param int $duration
     * @param int $objectNum
     * @param int $policyID
     * @param bool $printed
     * @param \App\Insis\StructType\ObjectParam[] $variableParams
     */
    public function __construct($additionalMaxValue = null, $additionalMinValue = null, array $aditionalActions = array(), $appGiftAmount = null, $appID = null, $appName = null, $autoBlank = null, array $blanks = array(), $discount = null, $duration = null, $objectNum = null, $policyID = null, $printed = null, array $variableParams = array())
    {
        $this
            ->setAdditionalMaxValue($additionalMaxValue)
            ->setAdditionalMinValue($additionalMinValue)
            ->setAditionalActions($aditionalActions)
            ->setAppGiftAmount($appGiftAmount)
            ->setAppID($appID)
            ->setAppName($appName)
            ->setAutoBlank($autoBlank)
            ->setBlanks($blanks)
            ->setDiscount($discount)
            ->setDuration($duration)
            ->setObjectNum($objectNum)
            ->setPolicyID($policyID)
            ->setPrinted($printed)
            ->setVariableParams($variableParams);
    }
    /**
     * Get additionalMaxValue value
     * @return int|null
     */
    public function getAdditionalMaxValue()
    {
        return $this->additionalMaxValue;
    }
    /**
     * Set additionalMaxValue value
     * @param int $additionalMaxValue
     * @return \App\Insis\StructType\Application
     */
    public function setAdditionalMaxValue($additionalMaxValue = null)
    {
        // validation for constraint: int
        if (!is_null($additionalMaxValue) && !(is_int($additionalMaxValue) || ctype_digit($additionalMaxValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($additionalMaxValue, true), gettype($additionalMaxValue)), __LINE__);
        }
        $this->additionalMaxValue = $additionalMaxValue;
        return $this;
    }
    /**
     * Get additionalMinValue value
     * @return int|null
     */
    public function getAdditionalMinValue()
    {
        return $this->additionalMinValue;
    }
    /**
     * Set additionalMinValue value
     * @param int $additionalMinValue
     * @return \App\Insis\StructType\Application
     */
    public function setAdditionalMinValue($additionalMinValue = null)
    {
        // validation for constraint: int
        if (!is_null($additionalMinValue) && !(is_int($additionalMinValue) || ctype_digit($additionalMinValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($additionalMinValue, true), gettype($additionalMinValue)), __LINE__);
        }
        $this->additionalMinValue = $additionalMinValue;
        return $this;
    }
    /**
     * Get aditionalActions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\AditionalApp[]|null
     */
    public function getAditionalActions()
    {
        return isset($this->aditionalActions) ? $this->aditionalActions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAditionalActions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAditionalActions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAditionalActionsForArrayConstraintsFromSetAditionalActions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicationAditionalActionsItem) {
            // validation for constraint: itemType
            if (!$applicationAditionalActionsItem instanceof \App\Insis\StructType\AditionalApp) {
                $invalidValues[] = is_object($applicationAditionalActionsItem) ? get_class($applicationAditionalActionsItem) : sprintf('%s(%s)', gettype($applicationAditionalActionsItem), var_export($applicationAditionalActionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aditionalActions property can only contain items of type \App\Insis\StructType\AditionalApp, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aditionalActions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\AditionalApp[] $aditionalActions
     * @return \App\Insis\StructType\Application
     */
    public function setAditionalActions(array $aditionalActions = array())
    {
        // validation for constraint: array
        if ('' !== ($aditionalActionsArrayErrorMessage = self::validateAditionalActionsForArrayConstraintsFromSetAditionalActions($aditionalActions))) {
            throw new \InvalidArgumentException($aditionalActionsArrayErrorMessage, __LINE__);
        }
        if (is_null($aditionalActions) || (is_array($aditionalActions) && empty($aditionalActions))) {
            unset($this->aditionalActions);
        } else {
            $this->aditionalActions = $aditionalActions;
        }
        return $this;
    }
    /**
     * Add item to aditionalActions value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\AditionalApp $item
     * @return \App\Insis\StructType\Application
     */
    public function addToAditionalActions(\App\Insis\StructType\AditionalApp $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\AditionalApp) {
            throw new \InvalidArgumentException(sprintf('The aditionalActions property can only contain items of type \App\Insis\StructType\AditionalApp, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aditionalActions[] = $item;
        return $this;
    }
    /**
     * Get appGiftAmount value
     * @return float|null
     */
    public function getAppGiftAmount()
    {
        return $this->appGiftAmount;
    }
    /**
     * Set appGiftAmount value
     * @param float $appGiftAmount
     * @return \App\Insis\StructType\Application
     */
    public function setAppGiftAmount($appGiftAmount = null)
    {
        // validation for constraint: float
        if (!is_null($appGiftAmount) && !(is_float($appGiftAmount) || is_numeric($appGiftAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($appGiftAmount, true), gettype($appGiftAmount)), __LINE__);
        }
        $this->appGiftAmount = $appGiftAmount;
        return $this;
    }
    /**
     * Get appID value
     * @return int|null
     */
    public function getAppID()
    {
        return $this->appID;
    }
    /**
     * Set appID value
     * @param int $appID
     * @return \App\Insis\StructType\Application
     */
    public function setAppID($appID = null)
    {
        // validation for constraint: int
        if (!is_null($appID) && !(is_int($appID) || ctype_digit($appID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($appID, true), gettype($appID)), __LINE__);
        }
        $this->appID = $appID;
        return $this;
    }
    /**
     * Get appName value
     * @return string|null
     */
    public function getAppName()
    {
        return $this->appName;
    }
    /**
     * Set appName value
     * @param string $appName
     * @return \App\Insis\StructType\Application
     */
    public function setAppName($appName = null)
    {
        // validation for constraint: string
        if (!is_null($appName) && !is_string($appName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appName, true), gettype($appName)), __LINE__);
        }
        $this->appName = $appName;
        return $this;
    }
    /**
     * Get autoBlank value
     * @return bool|null
     */
    public function getAutoBlank()
    {
        return $this->autoBlank;
    }
    /**
     * Set autoBlank value
     * @param bool $autoBlank
     * @return \App\Insis\StructType\Application
     */
    public function setAutoBlank($autoBlank = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoBlank) && !is_bool($autoBlank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoBlank, true), gettype($autoBlank)), __LINE__);
        }
        $this->autoBlank = $autoBlank;
        return $this;
    }
    /**
     * Get blanks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\PolicyBlanks[]|null
     */
    public function getBlanks()
    {
        return isset($this->blanks) ? $this->blanks : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBlanks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBlanks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBlanksForArrayConstraintsFromSetBlanks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicationBlanksItem) {
            // validation for constraint: itemType
            if (!$applicationBlanksItem instanceof \App\Insis\StructType\PolicyBlanks) {
                $invalidValues[] = is_object($applicationBlanksItem) ? get_class($applicationBlanksItem) : sprintf('%s(%s)', gettype($applicationBlanksItem), var_export($applicationBlanksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The blanks property can only contain items of type \App\Insis\StructType\PolicyBlanks, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set blanks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PolicyBlanks[] $blanks
     * @return \App\Insis\StructType\Application
     */
    public function setBlanks(array $blanks = array())
    {
        // validation for constraint: array
        if ('' !== ($blanksArrayErrorMessage = self::validateBlanksForArrayConstraintsFromSetBlanks($blanks))) {
            throw new \InvalidArgumentException($blanksArrayErrorMessage, __LINE__);
        }
        if (is_null($blanks) || (is_array($blanks) && empty($blanks))) {
            unset($this->blanks);
        } else {
            $this->blanks = $blanks;
        }
        return $this;
    }
    /**
     * Add item to blanks value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\PolicyBlanks $item
     * @return \App\Insis\StructType\Application
     */
    public function addToBlanks(\App\Insis\StructType\PolicyBlanks $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\PolicyBlanks) {
            throw new \InvalidArgumentException(sprintf('The blanks property can only contain items of type \App\Insis\StructType\PolicyBlanks, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->blanks[] = $item;
        return $this;
    }
    /**
     * Get discount value
     * @return bool|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param bool $discount
     * @return \App\Insis\StructType\Application
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: boolean
        if (!is_null($discount) && !is_bool($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \App\Insis\StructType\Application
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get objectNum value
     * @return int|null
     */
    public function getObjectNum()
    {
        return $this->objectNum;
    }
    /**
     * Set objectNum value
     * @param int $objectNum
     * @return \App\Insis\StructType\Application
     */
    public function setObjectNum($objectNum = null)
    {
        // validation for constraint: int
        if (!is_null($objectNum) && !(is_int($objectNum) || ctype_digit($objectNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectNum, true), gettype($objectNum)), __LINE__);
        }
        $this->objectNum = $objectNum;
        return $this;
    }
    /**
     * Get policyID value
     * @return int|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param int $policyID
     * @return \App\Insis\StructType\Application
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: int
        if (!is_null($policyID) && !(is_int($policyID) || ctype_digit($policyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get printed value
     * @return bool|null
     */
    public function getPrinted()
    {
        return $this->printed;
    }
    /**
     * Set printed value
     * @param bool $printed
     * @return \App\Insis\StructType\Application
     */
    public function setPrinted($printed = null)
    {
        // validation for constraint: boolean
        if (!is_null($printed) && !is_bool($printed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printed, true), gettype($printed)), __LINE__);
        }
        $this->printed = $printed;
        return $this;
    }
    /**
     * Get variableParams value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Insis\StructType\ObjectParam[]|null
     */
    public function getVariableParams()
    {
        return isset($this->variableParams) ? $this->variableParams : null;
    }
    /**
     * This method is responsible for validating the values passed to the setVariableParams method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVariableParams method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVariableParamsForArrayConstraintsFromSetVariableParams(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicationVariableParamsItem) {
            // validation for constraint: itemType
            if (!$applicationVariableParamsItem instanceof \App\Insis\StructType\ObjectParam) {
                $invalidValues[] = is_object($applicationVariableParamsItem) ? get_class($applicationVariableParamsItem) : sprintf('%s(%s)', gettype($applicationVariableParamsItem), var_export($applicationVariableParamsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The variableParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set variableParams value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam[] $variableParams
     * @return \App\Insis\StructType\Application
     */
    public function setVariableParams(array $variableParams = array())
    {
        // validation for constraint: array
        if ('' !== ($variableParamsArrayErrorMessage = self::validateVariableParamsForArrayConstraintsFromSetVariableParams($variableParams))) {
            throw new \InvalidArgumentException($variableParamsArrayErrorMessage, __LINE__);
        }
        if (is_null($variableParams) || (is_array($variableParams) && empty($variableParams))) {
            unset($this->variableParams);
        } else {
            $this->variableParams = $variableParams;
        }
        return $this;
    }
    /**
     * Add item to variableParams value
     * @throws \InvalidArgumentException
     * @param \App\Insis\StructType\ObjectParam $item
     * @return \App\Insis\StructType\Application
     */
    public function addToVariableParams(\App\Insis\StructType\ObjectParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Insis\StructType\ObjectParam) {
            throw new \InvalidArgumentException(sprintf('The variableParams property can only contain items of type \App\Insis\StructType\ObjectParam, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->variableParams[] = $item;
        return $this;
    }
}
