<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Tie ServiceType
 * @subpackage Services
 */
class Tie extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named tieUp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\TieUp $parameters
     * @return \App\Insis\StructType\TieUpResponse|bool
     */
    public function tieUp(\App\Insis\StructType\TieUp $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->tieUp($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\TieUpResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
