<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mark ServiceType
 * @subpackage Services
 */
class Mark extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named markPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\MarkPayment $parameters
     * @return \App\Insis\StructType\MarkPaymentResponse|bool
     */
    public function markPayment(\App\Insis\StructType\MarkPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->markPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named markPaymentTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\MarkPaymentTerminal $parameters
     * @return \App\Insis\StructType\MarkPaymentTerminalResponse|bool
     */
    public function markPaymentTerminal(\App\Insis\StructType\MarkPaymentTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->markPaymentTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\MarkPaymentResponse|\App\Insis\StructType\MarkPaymentTerminalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
