<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPolicy $parameters
     * @return \App\Insis\StructType\GetPolicyResponse|bool
     */
    public function getPolicy(\App\Insis\StructType\GetPolicy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDictionary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetDictionary $parameters
     * @return \App\Insis\StructType\GetDictionaryResponse|bool
     */
    public function getDictionary(\App\Insis\StructType\GetDictionary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDictionary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClientClassByIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetClientClassByIIN $parameters
     * @return \App\Insis\StructType\GetClientClassByIINResponse|bool
     */
    public function getClientClassByIIN(\App\Insis\StructType\GetClientClassByIIN $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getClientClassByIIN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetReport $parameters
     * @return \App\Insis\StructType\GetReportResponse|bool
     */
    public function getReport(\App\Insis\StructType\GetReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCurrencyRate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetCurrencyRate $parameters
     * @return \App\Insis\StructType\GetCurrencyRateResponse|bool
     */
    public function getCurrencyRate(\App\Insis\StructType\GetCurrencyRate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCurrencyRate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLimitConditions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetLimitConditions $parameters
     * @return \App\Insis\StructType\GetLimitConditionsResponse|bool
     */
    public function getLimitConditions(\App\Insis\StructType\GetLimitConditions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLimitConditions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStaffByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetStaffByKeyFields $parameters
     * @return \App\Insis\StructType\GetStaffByKeyFieldsResponse|bool
     */
    public function getStaffByKeyFields(\App\Insis\StructType\GetStaffByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getStaffByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReportParams
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetReportParams $parameters
     * @return \App\Insis\StructType\GetReportParamsResponse|bool
     */
    public function getReportParams(\App\Insis\StructType\GetReportParams $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getReportParams($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAvailableReports
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetAvailableReports $parameters
     * @return \App\Insis\StructType\GetAvailableReportsResponse|bool
     */
    public function getAvailableReports(\App\Insis\StructType\GetAvailableReports $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAvailableReports($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getObjectCarByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetObjectCarByKeyFields $parameters
     * @return \App\Insis\StructType\GetObjectCarByKeyFieldsResponse|bool
     */
    public function getObjectCarByKeyFields(\App\Insis\StructType\GetObjectCarByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getObjectCarByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCarViolations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetCarViolations $parameters
     * @return \App\Insis\StructType\GetCarViolationsResponse|bool
     */
    public function getCarViolations(\App\Insis\StructType\GetCarViolations $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCarViolations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStandartRiskValues
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetStandartRiskValues $parameters
     * @return \App\Insis\StructType\GetStandartRiskValuesResponse|bool
     */
    public function getStandartRiskValues(\App\Insis\StructType\GetStandartRiskValues $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getStandartRiskValues($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAgentByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetAgentByKeyFields $parameters
     * @return \App\Insis\StructType\GetAgentByKeyFieldsResponse|bool
     */
    public function getAgentByKeyFields(\App\Insis\StructType\GetAgentByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAgentByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStandartCovers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetStandartCovers $parameters
     * @return \App\Insis\StructType\GetStandartCoversResponse|bool
     */
    public function getStandartCovers(\App\Insis\StructType\GetStandartCovers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getStandartCovers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTariffList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetTariffList $parameters
     * @return \App\Insis\StructType\GetTariffListResponse|bool
     */
    public function getTariffList(\App\Insis\StructType\GetTariffList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTariffList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlanksNumbers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetBlanksNumbers $parameters
     * @return \App\Insis\StructType\GetBlanksNumbersResponse|bool
     */
    public function getBlanksNumbers(\App\Insis\StructType\GetBlanksNumbers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlanksNumbers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlankByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetBlankByKeyFields $parameters
     * @return \App\Insis\StructType\GetBlankByKeyFieldsResponse|bool
     */
    public function getBlankByKeyFields(\App\Insis\StructType\GetBlankByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlankByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlankOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetBlankOrders $parameters
     * @return \App\Insis\StructType\GetBlankOrdersResponse|bool
     */
    public function getBlankOrders(\App\Insis\StructType\GetBlankOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlankOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBillByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetBillByKeyFields $parameters
     * @return \App\Insis\StructType\GetBillByKeyFieldsResponse|bool
     */
    public function getBillByKeyFields(\App\Insis\StructType\GetBillByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBillByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPoliciesForPaymentByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPoliciesForPaymentByKeyFields $parameters
     * @return \App\Insis\StructType\GetPoliciesForPaymentByKeyFieldsResponse|bool
     */
    public function getPoliciesForPaymentByKeyFields(\App\Insis\StructType\GetPoliciesForPaymentByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPoliciesForPaymentByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetCallList $parameters
     * @return \App\Insis\StructType\GetCallListResponse|bool
     */
    public function getCallList(\App\Insis\StructType\GetCallList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicyPaidPremium
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPolicyPaidPremium $parameters
     * @return \App\Insis\StructType\GetPolicyPaidPremiumResponse|bool
     */
    public function getPolicyPaidPremium(\App\Insis\StructType\GetPolicyPaidPremium $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicyPaidPremium($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlankPrefixes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetBlankPrefixes $parameters
     * @return \App\Insis\StructType\GetBlankPrefixesResponse|bool
     */
    public function getBlankPrefixes(\App\Insis\StructType\GetBlankPrefixes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlankPrefixes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicyApps
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPolicyApps $parameters
     * @return \App\Insis\StructType\GetPolicyAppsResponse|bool
     */
    public function getPolicyApps(\App\Insis\StructType\GetPolicyApps $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicyApps($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInsrTypeCoverInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetInsrTypeCoverInfo $parameters
     * @return \App\Insis\StructType\GetInsrTypeCoverInfoResponse|bool
     */
    public function getInsrTypeCoverInfo(\App\Insis\StructType\GetInsrTypeCoverInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getInsrTypeCoverInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPoliciesByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPoliciesByKeyFields $parameters
     * @return \App\Insis\StructType\GetPoliciesByKeyFieldsResponse|bool
     */
    public function getPoliciesByKeyFields(\App\Insis\StructType\GetPoliciesByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPoliciesByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicyPrint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPolicyPrint $parameters
     * @return \App\Insis\StructType\GetPolicyPrintResponse|bool
     */
    public function getPolicyPrint(\App\Insis\StructType\GetPolicyPrint $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicyPrint($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPrintForm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPrintForm $parameters
     * @return \App\Insis\StructType\GetPrintFormResponse|bool
     */
    public function getPrintForm(\App\Insis\StructType\GetPrintForm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPrintForm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStandartCoverValues
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetStandartCoverValues $parameters
     * @return \App\Insis\StructType\GetStandartCoverValuesResponse|bool
     */
    public function getStandartCoverValues(\App\Insis\StructType\GetStandartCoverValues $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getStandartCoverValues($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStandartMultiCoverValues
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetStandartMultiCoverValues $parameters
     * @return \App\Insis\StructType\GetStandartMultiCoverValuesResponse|bool
     */
    public function getStandartMultiCoverValues(\App\Insis\StructType\GetStandartMultiCoverValues $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getStandartMultiCoverValues($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSouvenirs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetSouvenirs $parameters
     * @return \App\Insis\StructType\GetSouvenirsResponse|bool
     */
    public function getSouvenirs(\App\Insis\StructType\GetSouvenirs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSouvenirs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getArchiveByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetArchiveByKeyFields $parameters
     * @return \App\Insis\StructType\GetArchiveByKeyFieldsResponse|bool
     */
    public function getArchiveByKeyFields(\App\Insis\StructType\GetArchiveByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getArchiveByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConfirmList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetConfirmList $parameters
     * @return \App\Insis\StructType\GetConfirmListResponse|bool
     */
    public function getConfirmList(\App\Insis\StructType\GetConfirmList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getConfirmList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClaimByPeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetClaimByPeriod $parameters
     * @return \App\Insis\StructType\GetClaimByPeriodResponse|bool
     */
    public function getClaimByPeriod(\App\Insis\StructType\GetClaimByPeriod $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getClaimByPeriod($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClaimByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetClaimByKeyFields $parameters
     * @return \App\Insis\StructType\GetClaimByKeyFieldsResponse|bool
     */
    public function getClaimByKeyFields(\App\Insis\StructType\GetClaimByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getClaimByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClaimSiteView
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetClaimSiteView $parameters
     * @return \App\Insis\StructType\GetClaimSiteViewResponse|bool
     */
    public function getClaimSiteView(\App\Insis\StructType\GetClaimSiteView $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getClaimSiteView($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getObjectCargoByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetObjectCargoByKeyFields $parameters
     * @return \App\Insis\StructType\GetObjectCargoByKeyFieldsResponse|bool
     */
    public function getObjectCargoByKeyFields(\App\Insis\StructType\GetObjectCargoByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getObjectCargoByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPeopleByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPeopleByKeyFields $parameters
     * @return \App\Insis\StructType\GetPeopleByKeyFieldsResponse|bool
     */
    public function getPeopleByKeyFields(\App\Insis\StructType\GetPeopleByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPeopleByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClientClassByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetClientClassByKeyFields $parameters
     * @return \App\Insis\StructType\GetClientClassByKeyFieldsResponse|bool
     */
    public function getClientClassByKeyFields(\App\Insis\StructType\GetClientClassByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getClientClassByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClientClassByManID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetClientClassByManID $parameters
     * @return \App\Insis\StructType\GetClientClassByManIDResponse|bool
     */
    public function getClientClassByManID(\App\Insis\StructType\GetClientClassByManID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getClientClassByManID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPaymentInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPaymentInfo $parameters
     * @return \App\Insis\StructType\GetPaymentInfoResponse|bool
     */
    public function getPaymentInfo(\App\Insis\StructType\GetPaymentInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPaymentInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicyQRCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPolicyQRCode $parameters
     * @return \App\Insis\StructType\GetPolicyQRCodeResponse|bool
     */
    public function getPolicyQRCode(\App\Insis\StructType\GetPolicyQRCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicyQRCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDocumentAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetDocumentAttachment $parameters
     * @return \App\Insis\StructType\GetDocumentAttachmentResponse|bool
     */
    public function getDocumentAttachment(\App\Insis\StructType\GetDocumentAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDocumentAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetBoxByKeyFields $parameters
     * @return \App\Insis\StructType\GetBoxByKeyFieldsResponse|bool
     */
    public function getBoxByKeyFields(\App\Insis\StructType\GetBoxByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSiebelBoxPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetSiebelBoxPayment $parameters
     * @return \App\Insis\StructType\GetSiebelBoxPaymentResponse|bool
     */
    public function getSiebelBoxPayment(\App\Insis\StructType\GetSiebelBoxPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSiebelBoxPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSiebelBox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetSiebelBox $parameters
     * @return \App\Insis\StructType\GetSiebelBoxResponse|bool
     */
    public function getSiebelBox(\App\Insis\StructType\GetSiebelBox $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSiebelBox($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxIdByNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetBoxIdByNumber $parameters
     * @return \App\Insis\StructType\GetBoxIdByNumberResponse|bool
     */
    public function getBoxIdByNumber(\App\Insis\StructType\GetBoxIdByNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxIdByNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetBoxStatus $parameters
     * @return \App\Insis\StructType\GetBoxStatusResponse|bool
     */
    public function getBoxStatus(\App\Insis\StructType\GetBoxStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCarByNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetCarByNumber $parameters
     * @return \App\Insis\StructType\GetCarByNumberResponse|bool
     */
    public function getCarByNumber(\App\Insis\StructType\GetCarByNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCarByNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPremiumOGPOAuto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPremiumOGPOAuto $parameters
     * @return \App\Insis\StructType\GetPremiumOGPOAutoResponse|bool
     */
    public function getPremiumOGPOAuto(\App\Insis\StructType\GetPremiumOGPOAuto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPremiumOGPOAuto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetBoxPayment $parameters
     * @return \App\Insis\StructType\GetBoxPaymentResponse|bool
     */
    public function getBoxPayment(\App\Insis\StructType\GetBoxPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClientClass
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetClientClass $parameters
     * @return \App\Insis\StructType\GetClientClassResponse|bool
     */
    public function getClientClass(\App\Insis\StructType\GetClientClass $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getClientClass($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCarInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetCarInfo $parameters
     * @return \App\Insis\StructType\GetCarInfoResponse|bool
     */
    public function getCarInfo(\App\Insis\StructType\GetCarInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCarInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVierifiedPeopleByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetVierifiedPeopleByKeyFields $parameters
     * @return \App\Insis\StructType\GetVierifiedPeopleByKeyFieldsResponse|bool
     */
    public function getVierifiedPeopleByKeyFields(\App\Insis\StructType\GetVierifiedPeopleByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVierifiedPeopleByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPremiumOGPOAutoByIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPremiumOGPOAutoByIIN $parameters
     * @return \App\Insis\StructType\GetPremiumOGPOAutoByIINResponse|bool
     */
    public function getPremiumOGPOAutoByIIN(\App\Insis\StructType\GetPremiumOGPOAutoByIIN $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPremiumOGPOAutoByIIN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPremiumTravelPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPremiumTravelPolicy $parameters
     * @return \App\Insis\StructType\GetPremiumTravelPolicyResponse|bool
     */
    public function getPremiumTravelPolicy(\App\Insis\StructType\GetPremiumTravelPolicy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPremiumTravelPolicy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetBoxes $parameters
     * @return \App\Insis\StructType\GetBoxesResponse|bool
     */
    public function getBoxes(\App\Insis\StructType\GetBoxes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxPremium
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetBoxPremium $parameters
     * @return \App\Insis\StructType\GetBoxPremiumResponse|bool
     */
    public function getBoxPremium(\App\Insis\StructType\GetBoxPremium $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxPremium($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getArchivePolicyDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetArchivePolicyDetails $parameters
     * @return \App\Insis\StructType\GetArchivePolicyDetailsResponse|bool
     */
    public function getArchivePolicyDetails(\App\Insis\StructType\GetArchivePolicyDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getArchivePolicyDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGuidBank
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetGuidBank $parameters
     * @return \App\Insis\StructType\GetGuidBankResponse|bool
     */
    public function getGuidBank(\App\Insis\StructType\GetGuidBank $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getGuidBank($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlanksNumbersByIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetBlanksNumbersByIIN $parameters
     * @return \App\Insis\StructType\GetBlanksNumbersByIINResponse|bool
     */
    public function getBlanksNumbersByIIN(\App\Insis\StructType\GetBlanksNumbersByIIN $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlanksNumbersByIIN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOnlinePolicies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetOnlinePolicies $parameters
     * @return \App\Insis\StructType\GetOnlinePoliciesResponse|bool
     */
    public function getOnlinePolicies(\App\Insis\StructType\GetOnlinePolicies $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getOnlinePolicies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPremiumAndInsName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPremiumAndInsName $parameters
     * @return \App\Insis\StructType\GetPremiumAndInsNameResponse|bool
     */
    public function getPremiumAndInsName(\App\Insis\StructType\GetPremiumAndInsName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPremiumAndInsName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getObjectProperty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetObjectProperty $parameters
     * @return \App\Insis\StructType\GetObjectPropertyResponse|bool
     */
    public function getObjectProperty(\App\Insis\StructType\GetObjectProperty $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getObjectProperty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxPremiumByIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetBoxPremiumByIIN $parameters
     * @return \App\Insis\StructType\GetBoxPremiumByIINResponse|bool
     */
    public function getBoxPremiumByIIN(\App\Insis\StructType\GetBoxPremiumByIIN $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxPremiumByIIN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPremForSite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPremForSite $parameters
     * @return \App\Insis\StructType\GetPremForSiteResponse|bool
     */
    public function getPremForSite(\App\Insis\StructType\GetPremForSite $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPremForSite($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVerifiedPeople
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetVerifiedPeople $parameters
     * @return \App\Insis\StructType\GetVerifiedPeopleResponse|bool
     */
    public function getVerifiedPeople(\App\Insis\StructType\GetVerifiedPeople $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVerifiedPeople($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNameByIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetNameByIIN $parameters
     * @return \App\Insis\StructType\GetNameByIINResponse|bool
     */
    public function getNameByIIN(\App\Insis\StructType\GetNameByIIN $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getNameByIIN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMarkTS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetMarkTS $parameters
     * @return \App\Insis\StructType\GetMarkTSResponse|bool
     */
    public function getMarkTS(\App\Insis\StructType\GetMarkTS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getMarkTS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPeopleShort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPeopleShort $parameters
     * @return \App\Insis\StructType\GetPeopleShortResponse|bool
     */
    public function getPeopleShort(\App\Insis\StructType\GetPeopleShort $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPeopleShort($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCarShort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetCarShort $parameters
     * @return \App\Insis\StructType\GetCarShortResponse|bool
     */
    public function getCarShort(\App\Insis\StructType\GetCarShort $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCarShort($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOGPOFlagsByIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetOGPOFlagsByIIN $parameters
     * @return \App\Insis\StructType\GetOGPOFlagsByIINResponse|bool
     */
    public function getOGPOFlagsByIIN(\App\Insis\StructType\GetOGPOFlagsByIIN $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getOGPOFlagsByIIN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDraftRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetDraftRequest $parameters
     * @return \App\Insis\StructType\GetDraftRequestResponse|bool
     */
    public function getDraftRequest(\App\Insis\StructType\GetDraftRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDraftRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOnlineCover
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetOnlineCover $parameters
     * @return \App\Insis\StructType\GetOnlineCoverResponse|bool
     */
    public function getOnlineCover(\App\Insis\StructType\GetOnlineCover $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getOnlineCover($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOilByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetOilByKeyFields $parameters
     * @return \App\Insis\StructType\GetOilByKeyFieldsResponse|bool
     */
    public function getOilByKeyFields(\App\Insis\StructType\GetOilByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getOilByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOilQR
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetOilQR $parameters
     * @return \App\Insis\StructType\GetOilQRResponse|bool
     */
    public function getOilQR(\App\Insis\StructType\GetOilQR $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getOilQR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRZNUByMan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetRZNUByMan $parameters
     * @return \App\Insis\StructType\GetRZNUByManResponse|bool
     */
    public function getRZNUByMan(\App\Insis\StructType\GetRZNUByMan $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getRZNUByMan($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDraftRequestForPrint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetDraftRequestForPrint $parameters
     * @return \App\Insis\StructType\GetDraftRequestForPrintResponse|bool
     */
    public function getDraftRequestForPrint(\App\Insis\StructType\GetDraftRequestForPrint $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDraftRequestForPrint($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTechInspByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetTechInspByKeyFields $parameters
     * @return \App\Insis\StructType\GetTechInspByKeyFieldsResponse|bool
     */
    public function getTechInspByKeyFields(\App\Insis\StructType\GetTechInspByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTechInspByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicyIDbyRef
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetPolicyIDbyRef $parameters
     * @return \App\Insis\StructType\GetPolicyIDbyRefResponse|bool
     */
    public function getPolicyIDbyRef(\App\Insis\StructType\GetPolicyIDbyRef $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicyIDbyRef($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHalykTravelByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetHalykTravelByKeyFields $parameters
     * @return \App\Insis\StructType\GetHalykTravelByKeyFieldsResponse|bool
     */
    public function getHalykTravelByKeyFields(\App\Insis\StructType\GetHalykTravelByKeyFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHalykTravelByKeyFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDopsByPolicyID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\GetDopsByPolicyID $parameters
     * @return \App\Insis\StructType\GetDopsByPolicyIDResponse|bool
     */
    public function getDopsByPolicyID(\App\Insis\StructType\GetDopsByPolicyID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDopsByPolicyID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\GetAgentByKeyFieldsResponse|\App\Insis\StructType\GetArchiveByKeyFieldsResponse|\App\Insis\StructType\GetArchivePolicyDetailsResponse|\App\Insis\StructType\GetAvailableReportsResponse|\App\Insis\StructType\GetBillByKeyFieldsResponse|\App\Insis\StructType\GetBlankByKeyFieldsResponse|\App\Insis\StructType\GetBlankOrdersResponse|\App\Insis\StructType\GetBlankPrefixesResponse|\App\Insis\StructType\GetBlanksNumbersByIINResponse|\App\Insis\StructType\GetBlanksNumbersResponse|\App\Insis\StructType\GetBoxByKeyFieldsResponse|\App\Insis\StructType\GetBoxesResponse|\App\Insis\StructType\GetBoxIdByNumberResponse|\App\Insis\StructType\GetBoxPaymentResponse|\App\Insis\StructType\GetBoxPremiumByIINResponse|\App\Insis\StructType\GetBoxPremiumResponse|\App\Insis\StructType\GetBoxStatusResponse|\App\Insis\StructType\GetCallListResponse|\App\Insis\StructType\GetCarByNumberResponse|\App\Insis\StructType\GetCarInfoResponse|\App\Insis\StructType\GetCarShortResponse|\App\Insis\StructType\GetCarViolationsResponse|\App\Insis\StructType\GetClaimByKeyFieldsResponse|\App\Insis\StructType\GetClaimByPeriodResponse|\App\Insis\StructType\GetClaimSiteViewResponse|\App\Insis\StructType\GetClientClassByIINResponse|\App\Insis\StructType\GetClientClassByKeyFieldsResponse|\App\Insis\StructType\GetClientClassByManIDResponse|\App\Insis\StructType\GetClientClassResponse|\App\Insis\StructType\GetConfirmListResponse|\App\Insis\StructType\GetCurrencyRateResponse|\App\Insis\StructType\GetDictionaryResponse|\App\Insis\StructType\GetDocumentAttachmentResponse|\App\Insis\StructType\GetDopsByPolicyIDResponse|\App\Insis\StructType\GetDraftRequestForPrintResponse|\App\Insis\StructType\GetDraftRequestResponse|\App\Insis\StructType\GetGuidBankResponse|\App\Insis\StructType\GetHalykTravelByKeyFieldsResponse|\App\Insis\StructType\GetInsrTypeCoverInfoResponse|\App\Insis\StructType\GetLimitConditionsResponse|\App\Insis\StructType\GetMarkTSResponse|\App\Insis\StructType\GetNameByIINResponse|\App\Insis\StructType\GetObjectCarByKeyFieldsResponse|\App\Insis\StructType\GetObjectCargoByKeyFieldsResponse|\App\Insis\StructType\GetObjectPropertyResponse|\App\Insis\StructType\GetOGPOFlagsByIINResponse|\App\Insis\StructType\GetOilByKeyFieldsResponse|\App\Insis\StructType\GetOilQRResponse|\App\Insis\StructType\GetOnlineCoverResponse|\App\Insis\StructType\GetOnlinePoliciesResponse|\App\Insis\StructType\GetPaymentInfoResponse|\App\Insis\StructType\GetPeopleByKeyFieldsResponse|\App\Insis\StructType\GetPeopleShortResponse|\App\Insis\StructType\GetPoliciesByKeyFieldsResponse|\App\Insis\StructType\GetPoliciesForPaymentByKeyFieldsResponse|\App\Insis\StructType\GetPolicyAppsResponse|\App\Insis\StructType\GetPolicyIDbyRefResponse|\App\Insis\StructType\GetPolicyPaidPremiumResponse|\App\Insis\StructType\GetPolicyPrintResponse|\App\Insis\StructType\GetPolicyQRCodeResponse|\App\Insis\StructType\GetPolicyResponse|\App\Insis\StructType\GetPremForSiteResponse|\App\Insis\StructType\GetPremiumAndInsNameResponse|\App\Insis\StructType\GetPremiumOGPOAutoByIINResponse|\App\Insis\StructType\GetPremiumOGPOAutoResponse|\App\Insis\StructType\GetPremiumTravelPolicyResponse|\App\Insis\StructType\GetPrintFormResponse|\App\Insis\StructType\GetReportParamsResponse|\App\Insis\StructType\GetReportResponse|\App\Insis\StructType\GetRZNUByManResponse|\App\Insis\StructType\GetSiebelBoxPaymentResponse|\App\Insis\StructType\GetSiebelBoxResponse|\App\Insis\StructType\GetSouvenirsResponse|\App\Insis\StructType\GetStaffByKeyFieldsResponse|\App\Insis\StructType\GetStandartCoversResponse|\App\Insis\StructType\GetStandartCoverValuesResponse|\App\Insis\StructType\GetStandartMultiCoverValuesResponse|\App\Insis\StructType\GetStandartRiskValuesResponse|\App\Insis\StructType\GetTariffListResponse|\App\Insis\StructType\GetTechInspByKeyFieldsResponse|\App\Insis\StructType\GetVerifiedPeopleResponse|\App\Insis\StructType\GetVierifiedPeopleByKeyFieldsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
