<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkPolicyExistence
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CheckPolicyExistence $parameters
     * @return \App\Insis\StructType\CheckPolicyExistenceResponse|bool
     */
    public function checkPolicyExistence(\App\Insis\StructType\CheckPolicyExistence $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkPolicyExistence($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkObjectCar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CheckObjectCar $parameters
     * @return \App\Insis\StructType\CheckObjectCarResponse|bool
     */
    public function checkObjectCar(\App\Insis\StructType\CheckObjectCar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkObjectCar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkForClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CheckForClient $parameters
     * @return \App\Insis\StructType\CheckForClientResponse|bool
     */
    public function checkForClient(\App\Insis\StructType\CheckForClient $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkForClient($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkPeopleInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CheckPeopleInfo $parameters
     * @return \App\Insis\StructType\CheckPeopleInfoResponse|bool
     */
    public function checkPeopleInfo(\App\Insis\StructType\CheckPeopleInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkPeopleInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkPeopleIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CheckPeopleIIN $parameters
     * @return \App\Insis\StructType\CheckPeopleIINResponse|bool
     */
    public function checkPeopleIIN(\App\Insis\StructType\CheckPeopleIIN $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkPeopleIIN($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkSiebelBox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CheckSiebelBox $parameters
     * @return \App\Insis\StructType\CheckSiebelBoxResponse|bool
     */
    public function checkSiebelBox(\App\Insis\StructType\CheckSiebelBox $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkSiebelBox($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkFormats
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CheckFormats $parameters
     * @return \App\Insis\StructType\CheckFormatsResponse|bool
     */
    public function checkFormats(\App\Insis\StructType\CheckFormats $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkFormats($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkPKOState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CheckPKOState $parameters
     * @return \App\Insis\StructType\CheckPKOStateResponse|bool
     */
    public function checkPKOState(\App\Insis\StructType\CheckPKOState $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkPKOState($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkVerifiedStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CheckVerifiedStatus $parameters
     * @return \App\Insis\StructType\CheckVerifiedStatusResponse|bool
     */
    public function checkVerifiedStatus(\App\Insis\StructType\CheckVerifiedStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkVerifiedStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkOnlineStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CheckOnlineStatus $parameters
     * @return \App\Insis\StructType\CheckOnlineStatusResponse|bool
     */
    public function checkOnlineStatus(\App\Insis\StructType\CheckOnlineStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkOnlineStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkPolicyStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\CheckPolicyStatus $parameters
     * @return \App\Insis\StructType\CheckPolicyStatusResponse|bool
     */
    public function checkPolicyStatus(\App\Insis\StructType\CheckPolicyStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->checkPolicyStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\CheckForClientResponse|\App\Insis\StructType\CheckFormatsResponse|\App\Insis\StructType\CheckObjectCarResponse|\App\Insis\StructType\CheckOnlineStatusResponse|\App\Insis\StructType\CheckPeopleIINResponse|\App\Insis\StructType\CheckPeopleInfoResponse|\App\Insis\StructType\CheckPKOStateResponse|\App\Insis\StructType\CheckPolicyExistenceResponse|\App\Insis\StructType\CheckPolicyStatusResponse|\App\Insis\StructType\CheckSiebelBoxResponse|\App\Insis\StructType\CheckVerifiedStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
