<?php

namespace App\Insis\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Annul ServiceType
 * @subpackage Services
 */
class Annul extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named annulApplication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\AnnulApplication $parameters
     * @return \App\Insis\StructType\AnnulApplicationResponse|bool
     */
    public function annulApplication(\App\Insis\StructType\AnnulApplication $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->annulApplication($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named annulBox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\AnnulBox $parameters
     * @return \App\Insis\StructType\AnnulBoxResponse|bool
     */
    public function annulBox(\App\Insis\StructType\AnnulBox $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->annulBox($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named annulOilCoupon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\AnnulOilCoupon $parameters
     * @return \App\Insis\StructType\AnnulOilCouponResponse|bool
     */
    public function annulOilCoupon(\App\Insis\StructType\AnnulOilCoupon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->annulOilCoupon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named annulTechInspection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\AnnulTechInspection $parameters
     * @return \App\Insis\StructType\AnnulTechInspectionResponse|bool
     */
    public function annulTechInspection(\App\Insis\StructType\AnnulTechInspection $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->annulTechInspection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named annulRecord
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Insis\StructType\AnnulRecord $parameters
     * @return \App\Insis\StructType\AnnulRecordResponse|bool
     */
    public function annulRecord(\App\Insis\StructType\AnnulRecord $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->annulRecord($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Insis\StructType\AnnulApplicationResponse|\App\Insis\StructType\AnnulBoxResponse|\App\Insis\StructType\AnnulOilCouponResponse|\App\Insis\StructType\AnnulRecordResponse|\App\Insis\StructType\AnnulTechInspectionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
