<?php

namespace App\Insis;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'PolicyBlanks' => '\\App\\Insis\\StructType\\PolicyBlanks',
            'ObjectParam' => '\\App\\Insis\\StructType\\ObjectParam',
            'People' => '\\App\\Insis\\StructType\\People',
            'PolicyObject' => '\\App\\Insis\\StructType\\PolicyObject',
            'ObjectCover' => '\\App\\Insis\\StructType\\ObjectCover',
            'Tariff' => '\\App\\Insis\\StructType\\Tariff',
            'CoverRisk' => '\\App\\Insis\\StructType\\CoverRisk',
            'Policy' => '\\App\\Insis\\StructType\\Policy',
            'Payment' => '\\App\\Insis\\StructType\\Payment',
            'PolicyList' => '\\App\\Insis\\StructType\\PolicyList',
            'ObjectCar' => '\\App\\Insis\\StructType\\ObjectCar',
            'CashPayment' => '\\App\\Insis\\StructType\\CashPayment',
            'CashPaymentDetail' => '\\App\\Insis\\StructType\\CashPaymentDetail',
            'Distribution' => '\\App\\Insis\\StructType\\Distribution',
            'Agent' => '\\App\\Insis\\StructType\\Agent',
            'setHalykTravelPayment' => '\\App\\Insis\\StructType\\SetHalykTravelPayment',
            'setHalykTravelPaymentResponse' => '\\App\\Insis\\StructType\\SetHalykTravelPaymentResponse',
            'BTAException' => '\\App\\Insis\\StructType\\BTAException',
            'checkOnlineStatus' => '\\App\\Insis\\StructType\\CheckOnlineStatus',
            'checkOnlineStatusResponse' => '\\App\\Insis\\StructType\\CheckOnlineStatusResponse',
            'getBlanksNumbersByIIN' => '\\App\\Insis\\StructType\\GetBlanksNumbersByIIN',
            'getBlanksNumbersByIINResponse' => '\\App\\Insis\\StructType\\GetBlanksNumbersByIINResponse',
            'getPolicyApps' => '\\App\\Insis\\StructType\\GetPolicyApps',
            'getPolicyAppsResponse' => '\\App\\Insis\\StructType\\GetPolicyAppsResponse',
            'application' => '\\App\\Insis\\StructType\\Application',
            'aditionalApp' => '\\App\\Insis\\StructType\\AditionalApp',
            'getOGPOFlagsByIIN' => '\\App\\Insis\\StructType\\GetOGPOFlagsByIIN',
            'getOGPOFlagsByIINResponse' => '\\App\\Insis\\StructType\\GetOGPOFlagsByIINResponse',
            'address' => '\\App\\Insis\\StructType\\Address',
            'peopleDocument' => '\\App\\Insis\\StructType\\PeopleDocument',
            'attachment' => '\\App\\Insis\\StructType\\Attachment',
            'bankAccount' => '\\App\\Insis\\StructType\\BankAccount',
            'addressKATO' => '\\App\\Insis\\StructType\\AddressKATO',
            'setRequestData' => '\\App\\Insis\\StructType\\SetRequestData',
            'hcsbkRequest' => '\\App\\Insis\\StructType\\HcsbkRequest',
            'requestData' => '\\App\\Insis\\StructType\\RequestData',
            'agreementData' => '\\App\\Insis\\StructType\\AgreementData',
            'hcsbkBank' => '\\App\\Insis\\StructType\\HcsbkBank',
            'hcsbkClient' => '\\App\\Insis\\StructType\\HcsbkClient',
            'idCard' => '\\App\\Insis\\StructType\\IdCard',
            'insuranceData' => '\\App\\Insis\\StructType\\InsuranceData',
            'hcsbkAgent' => '\\App\\Insis\\StructType\\HcsbkAgent',
            'propertyInsurance' => '\\App\\Insis\\StructType\\PropertyInsurance',
            'titleInsurance' => '\\App\\Insis\\StructType\\TitleInsurance',
            'hcsbkInsurer' => '\\App\\Insis\\StructType\\HcsbkInsurer',
            'pledger' => '\\App\\Insis\\StructType\\Pledger',
            'hcsbkItem' => '\\App\\Insis\\StructType\\HcsbkItem',
            'realty' => '\\App\\Insis\\StructType\\Realty',
            'requestInfo' => '\\App\\Insis\\StructType\\RequestInfo',
            'setRequestDataResponse' => '\\App\\Insis\\StructType\\SetRequestDataResponse',
            'Exception' => '\\App\\Insis\\StructType\\Exception',
            'calcCascoEleganse' => '\\App\\Insis\\StructType\\CalcCascoEleganse',
            'calcCascoEleganseResponse' => '\\App\\Insis\\StructType\\CalcCascoEleganseResponse',
            'getStandartCoverValues' => '\\App\\Insis\\StructType\\GetStandartCoverValues',
            'getStandartCoverValuesResponse' => '\\App\\Insis\\StructType\\GetStandartCoverValuesResponse',
            'getSiebelBox' => '\\App\\Insis\\StructType\\GetSiebelBox',
            'getSiebelBoxResponse' => '\\App\\Insis\\StructType\\GetSiebelBoxResponse',
            'siebelBox' => '\\App\\Insis\\StructType\\SiebelBox',
            'getBlanksNumbers' => '\\App\\Insis\\StructType\\GetBlanksNumbers',
            'getBlanksNumbersResponse' => '\\App\\Insis\\StructType\\GetBlanksNumbersResponse',
            'getOnlinePolicies' => '\\App\\Insis\\StructType\\GetOnlinePolicies',
            'getOnlinePoliciesResponse' => '\\App\\Insis\\StructType\\GetOnlinePoliciesResponse',
            'calcOsgpoAuto' => '\\App\\Insis\\StructType\\CalcOsgpoAuto',
            'calcOsgpoAutoResponse' => '\\App\\Insis\\StructType\\CalcOsgpoAutoResponse',
            'getClientClassByManID' => '\\App\\Insis\\StructType\\GetClientClassByManID',
            'getClientClassByManIDResponse' => '\\App\\Insis\\StructType\\GetClientClassByManIDResponse',
            'setAMEXPolicy' => '\\App\\Insis\\StructType\\SetAMEXPolicy',
            'bordero' => '\\App\\Insis\\StructType\\Bordero',
            'setAMEXPolicyResponse' => '\\App\\Insis\\StructType\\SetAMEXPolicyResponse',
            'setOSRNSDetails' => '\\App\\Insis\\StructType\\SetOSRNSDetails',
            'setOSRNSDetailsResponse' => '\\App\\Insis\\StructType\\SetOSRNSDetailsResponse',
            'setArchive' => '\\App\\Insis\\StructType\\SetArchive',
            'archive' => '\\App\\Insis\\StructType\\Archive',
            'archiveConfirmation' => '\\App\\Insis\\StructType\\ArchiveConfirmation',
            'archivePolicyDetails' => '\\App\\Insis\\StructType\\ArchivePolicyDetails',
            'setArchiveResponse' => '\\App\\Insis\\StructType\\SetArchiveResponse',
            'tieUp' => '\\App\\Insis\\StructType\\TieUp',
            'tieUpResponse' => '\\App\\Insis\\StructType\\TieUpResponse',
            'setPaymentSite' => '\\App\\Insis\\StructType\\SetPaymentSite',
            'setPaymentSiteResponse' => '\\App\\Insis\\StructType\\SetPaymentSiteResponse',
            'getClientClass' => '\\App\\Insis\\StructType\\GetClientClass',
            'getClientClassResponse' => '\\App\\Insis\\StructType\\GetClientClassResponse',
            'annulTechInspection' => '\\App\\Insis\\StructType\\AnnulTechInspection',
            'techInspection' => '\\App\\Insis\\StructType\\TechInspection',
            'annulTechInspectionResponse' => '\\App\\Insis\\StructType\\AnnulTechInspectionResponse',
            'deleteDocumentAttachment' => '\\App\\Insis\\StructType\\DeleteDocumentAttachment',
            'deleteDocumentAttachmentResponse' => '\\App\\Insis\\StructType\\DeleteDocumentAttachmentResponse',
            'getArchivePolicyDetails' => '\\App\\Insis\\StructType\\GetArchivePolicyDetails',
            'getArchivePolicyDetailsResponse' => '\\App\\Insis\\StructType\\GetArchivePolicyDetailsResponse',
            'archiveInfo' => '\\App\\Insis\\StructType\\ArchiveInfo',
            'getPremiumOGPOAutoByIIN' => '\\App\\Insis\\StructType\\GetPremiumOGPOAutoByIIN',
            'ogpoClient' => '\\App\\Insis\\StructType\\OgpoClient',
            'getPremiumOGPOAutoByIINResponse' => '\\App\\Insis\\StructType\\GetPremiumOGPOAutoByIINResponse',
            'getPolicyQRCode' => '\\App\\Insis\\StructType\\GetPolicyQRCode',
            'getPolicyQRCodeResponse' => '\\App\\Insis\\StructType\\GetPolicyQRCodeResponse',
            'deleteArchive' => '\\App\\Insis\\StructType\\DeleteArchive',
            'deleteArchiveResponse' => '\\App\\Insis\\StructType\\DeleteArchiveResponse',
            'checkPKOState' => '\\App\\Insis\\StructType\\CheckPKOState',
            'checkPKOStateResponse' => '\\App\\Insis\\StructType\\CheckPKOStateResponse',
            'getBoxPremiumByIIN' => '\\App\\Insis\\StructType\\GetBoxPremiumByIIN',
            'getBoxPremiumByIINResponse' => '\\App\\Insis\\StructType\\GetBoxPremiumByIINResponse',
            'getPolicyIDbyRef' => '\\App\\Insis\\StructType\\GetPolicyIDbyRef',
            'getPolicyIDbyRefResponse' => '\\App\\Insis\\StructType\\GetPolicyIDbyRefResponse',
            'getRZNUByMan' => '\\App\\Insis\\StructType\\GetRZNUByMan',
            'getRZNUByManResponse' => '\\App\\Insis\\StructType\\GetRZNUByManResponse',
            'setObjectLiability' => '\\App\\Insis\\StructType\\SetObjectLiability',
            'objectLiability' => '\\App\\Insis\\StructType\\ObjectLiability',
            'setObjectLiabilityResponse' => '\\App\\Insis\\StructType\\SetObjectLiabilityResponse',
            'calcCascoClassic' => '\\App\\Insis\\StructType\\CalcCascoClassic',
            'calcCascoClassicResponse' => '\\App\\Insis\\StructType\\CalcCascoClassicResponse',
            'getPrintForm' => '\\App\\Insis\\StructType\\GetPrintForm',
            'getPrintFormResponse' => '\\App\\Insis\\StructType\\GetPrintFormResponse',
            'setPayment' => '\\App\\Insis\\StructType\\SetPayment',
            'setPaymentResponse' => '\\App\\Insis\\StructType\\SetPaymentResponse',
            'getDraftRequest' => '\\App\\Insis\\StructType\\GetDraftRequest',
            'getDraftRequestResponse' => '\\App\\Insis\\StructType\\GetDraftRequestResponse',
            'draft' => '\\App\\Insis\\StructType\\Draft',
            'draftClient' => '\\App\\Insis\\StructType\\DraftClient',
            'draftObject' => '\\App\\Insis\\StructType\\DraftObject',
            'setPolicyAttachment' => '\\App\\Insis\\StructType\\SetPolicyAttachment',
            'setPolicyAttachmentResponse' => '\\App\\Insis\\StructType\\SetPolicyAttachmentResponse',
            'getPeopleByKeyFields' => '\\App\\Insis\\StructType\\GetPeopleByKeyFields',
            'getPeopleByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetPeopleByKeyFieldsResponse',
            'calcCascoAvangard' => '\\App\\Insis\\StructType\\CalcCascoAvangard',
            'calcCascoAvangardResponse' => '\\App\\Insis\\StructType\\CalcCascoAvangardResponse',
            'getInsrTypeCoverInfo' => '\\App\\Insis\\StructType\\GetInsrTypeCoverInfo',
            'getInsrTypeCoverInfoResponse' => '\\App\\Insis\\StructType\\GetInsrTypeCoverInfoResponse',
            'createBill' => '\\App\\Insis\\StructType\\CreateBill',
            'bill' => '\\App\\Insis\\StructType\\Bill',
            'billDetails' => '\\App\\Insis\\StructType\\BillDetails',
            'createBillResponse' => '\\App\\Insis\\StructType\\CreateBillResponse',
            'getBoxByKeyFields' => '\\App\\Insis\\StructType\\GetBoxByKeyFields',
            'box' => '\\App\\Insis\\StructType\\Box',
            'getBoxByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetBoxByKeyFieldsResponse',
            'getObjectCargoByKeyFields' => '\\App\\Insis\\StructType\\GetObjectCargoByKeyFields',
            'objectCargo' => '\\App\\Insis\\StructType\\ObjectCargo',
            'getObjectCargoByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetObjectCargoByKeyFieldsResponse',
            'annulRecord' => '\\App\\Insis\\StructType\\AnnulRecord',
            'annulRecordResponse' => '\\App\\Insis\\StructType\\AnnulRecordResponse',
            'getBoxes' => '\\App\\Insis\\StructType\\GetBoxes',
            'getBoxesResponse' => '\\App\\Insis\\StructType\\GetBoxesResponse',
            'boxDetails' => '\\App\\Insis\\StructType\\BoxDetails',
            'cleanQueue' => '\\App\\Insis\\StructType\\CleanQueue',
            'cleanQueueResponse' => '\\App\\Insis\\StructType\\CleanQueueResponse',
            'getConfirmList' => '\\App\\Insis\\StructType\\GetConfirmList',
            'getConfirmListResponse' => '\\App\\Insis\\StructType\\GetConfirmListResponse',
            'setBoxPayment' => '\\App\\Insis\\StructType\\SetBoxPayment',
            'setBoxPaymentResponse' => '\\App\\Insis\\StructType\\SetBoxPaymentResponse',
            'getPaymentInfo' => '\\App\\Insis\\StructType\\GetPaymentInfo',
            'getPaymentInfoResponse' => '\\App\\Insis\\StructType\\GetPaymentInfoResponse',
            'registerBox' => '\\App\\Insis\\StructType\\RegisterBox',
            'registerBoxResponse' => '\\App\\Insis\\StructType\\RegisterBoxResponse',
            'setClaimInfoAttach' => '\\App\\Insis\\StructType\\SetClaimInfoAttach',
            'setClaimInfoAttachResponse' => '\\App\\Insis\\StructType\\SetClaimInfoAttachResponse',
            'getBlankByKeyFields' => '\\App\\Insis\\StructType\\GetBlankByKeyFields',
            'getBlankByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetBlankByKeyFieldsResponse',
            'getCallList' => '\\App\\Insis\\StructType\\GetCallList',
            'getCallListResponse' => '\\App\\Insis\\StructType\\GetCallListResponse',
            'policyCalls' => '\\App\\Insis\\StructType\\PolicyCalls',
            'getOnlineCover' => '\\App\\Insis\\StructType\\GetOnlineCover',
            'onlineCover' => '\\App\\Insis\\StructType\\OnlineCover',
            'getOnlineCoverResponse' => '\\App\\Insis\\StructType\\GetOnlineCoverResponse',
            'setApplication' => '\\App\\Insis\\StructType\\SetApplication',
            'setApplicationResponse' => '\\App\\Insis\\StructType\\SetApplicationResponse',
            'getObjectCarByKeyFields' => '\\App\\Insis\\StructType\\GetObjectCarByKeyFields',
            'getObjectCarByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetObjectCarByKeyFieldsResponse',
            'useDistribution' => '\\App\\Insis\\StructType\\UseDistribution',
            'useDistributionResponse' => '\\App\\Insis\\StructType\\UseDistributionResponse',
            'getCarViolations' => '\\App\\Insis\\StructType\\GetCarViolations',
            'getCarViolationsResponse' => '\\App\\Insis\\StructType\\GetCarViolationsResponse',
            'carViolation' => '\\App\\Insis\\StructType\\CarViolation',
            'setIncomingReinsurance' => '\\App\\Insis\\StructType\\SetIncomingReinsurance',
            'incomingReinsurance' => '\\App\\Insis\\StructType\\IncomingReinsurance',
            'reinsurer' => '\\App\\Insis\\StructType\\Reinsurer',
            'setIncomingReinsuranceResponse' => '\\App\\Insis\\StructType\\SetIncomingReinsuranceResponse',
            'getOilByKeyFields' => '\\App\\Insis\\StructType\\GetOilByKeyFields',
            'oil' => '\\App\\Insis\\StructType\\Oil',
            'getOilByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetOilByKeyFieldsResponse',
            'getAvailableReports' => '\\App\\Insis\\StructType\\GetAvailableReports',
            'getAvailableReportsResponse' => '\\App\\Insis\\StructType\\GetAvailableReportsResponse',
            'getDopsByPolicyID' => '\\App\\Insis\\StructType\\GetDopsByPolicyID',
            'getDopsByPolicyIDResponse' => '\\App\\Insis\\StructType\\GetDopsByPolicyIDResponse',
            'getCarShort' => '\\App\\Insis\\StructType\\GetCarShort',
            'getCarShortResponse' => '\\App\\Insis\\StructType\\GetCarShortResponse',
            'checkVerifiedStatus' => '\\App\\Insis\\StructType\\CheckVerifiedStatus',
            'checkVerifiedStatusResponse' => '\\App\\Insis\\StructType\\CheckVerifiedStatusResponse',
            'getGuidBank' => '\\App\\Insis\\StructType\\GetGuidBank',
            'getGuidBankResponse' => '\\App\\Insis\\StructType\\GetGuidBankResponse',
            'setSiebelHBCardInfo' => '\\App\\Insis\\StructType\\SetSiebelHBCardInfo',
            'siebelHBCards' => '\\App\\Insis\\StructType\\SiebelHBCards',
            'setSiebelHBCardInfoResponse' => '\\App\\Insis\\StructType\\SetSiebelHBCardInfoResponse',
            'siebelHBCardsResult' => '\\App\\Insis\\StructType\\SiebelHBCardsResult',
            'setPeople' => '\\App\\Insis\\StructType\\SetPeople',
            'setPeopleResponse' => '\\App\\Insis\\StructType\\SetPeopleResponse',
            'setSiebelBoxPayment' => '\\App\\Insis\\StructType\\SetSiebelBoxPayment',
            'setSiebelBoxPaymentResponse' => '\\App\\Insis\\StructType\\SetSiebelBoxPaymentResponse',
            'siebelBoxChk' => '\\App\\Insis\\StructType\\SiebelBoxChk',
            'createSiebelBox' => '\\App\\Insis\\StructType\\CreateSiebelBox',
            'createSiebelBoxResponse' => '\\App\\Insis\\StructType\\CreateSiebelBoxResponse',
            'siebelBoxTools' => '\\App\\Insis\\StructType\\SiebelBoxTools',
            'setBoxAddress' => '\\App\\Insis\\StructType\\SetBoxAddress',
            'setBoxAddressResponse' => '\\App\\Insis\\StructType\\SetBoxAddressResponse',
            'getObjectProperty' => '\\App\\Insis\\StructType\\GetObjectProperty',
            'getObjectPropertyResponse' => '\\App\\Insis\\StructType\\GetObjectPropertyResponse',
            'objectProperty' => '\\App\\Insis\\StructType\\ObjectProperty',
            'getPremiumOGPOAuto' => '\\App\\Insis\\StructType\\GetPremiumOGPOAuto',
            'getPremiumOGPOAutoResponse' => '\\App\\Insis\\StructType\\GetPremiumOGPOAutoResponse',
            'checkPeopleIIN' => '\\App\\Insis\\StructType\\CheckPeopleIIN',
            'checkPeopleIINResponse' => '\\App\\Insis\\StructType\\CheckPeopleIINResponse',
            'setRequestDataFile' => '\\App\\Insis\\StructType\\SetRequestDataFile',
            'setRequestDataFileResponse' => '\\App\\Insis\\StructType\\SetRequestDataFileResponse',
            'getBoxStatus' => '\\App\\Insis\\StructType\\GetBoxStatus',
            'getBoxStatusResponse' => '\\App\\Insis\\StructType\\GetBoxStatusResponse',
            'getDictionary' => '\\App\\Insis\\StructType\\GetDictionary',
            'getDictionaryResponse' => '\\App\\Insis\\StructType\\GetDictionaryResponse',
            'getBlankPrefixes' => '\\App\\Insis\\StructType\\GetBlankPrefixes',
            'getBlankPrefixesResponse' => '\\App\\Insis\\StructType\\GetBlankPrefixesResponse',
            'sendSmsOil' => '\\App\\Insis\\StructType\\SendSmsOil',
            'sendSmsOilResponse' => '\\App\\Insis\\StructType\\SendSmsOilResponse',
            'setObjectCarAttachment' => '\\App\\Insis\\StructType\\SetObjectCarAttachment',
            'setObjectCarAttachmentResponse' => '\\App\\Insis\\StructType\\SetObjectCarAttachmentResponse',
            'checkPolicyExistence' => '\\App\\Insis\\StructType\\CheckPolicyExistence',
            'checkPolicyExistenceResponse' => '\\App\\Insis\\StructType\\CheckPolicyExistenceResponse',
            'getBlankOrders' => '\\App\\Insis\\StructType\\GetBlankOrders',
            'getBlankOrdersResponse' => '\\App\\Insis\\StructType\\GetBlankOrdersResponse',
            'blankOrder' => '\\App\\Insis\\StructType\\BlankOrder',
            'setVerifiedPeople' => '\\App\\Insis\\StructType\\SetVerifiedPeople',
            'setVerifiedPeopleResponse' => '\\App\\Insis\\StructType\\SetVerifiedPeopleResponse',
            'getSouvenirs' => '\\App\\Insis\\StructType\\GetSouvenirs',
            'getSouvenirsResponse' => '\\App\\Insis\\StructType\\GetSouvenirsResponse',
            'getCurrencyRate' => '\\App\\Insis\\StructType\\GetCurrencyRate',
            'getCurrencyRateResponse' => '\\App\\Insis\\StructType\\GetCurrencyRateResponse',
            'getVierifiedPeopleByKeyFields' => '\\App\\Insis\\StructType\\GetVierifiedPeopleByKeyFields',
            'getVierifiedPeopleByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetVierifiedPeopleByKeyFieldsResponse',
            'setPolicy' => '\\App\\Insis\\StructType\\SetPolicy',
            'setPolicyResponse' => '\\App\\Insis\\StructType\\SetPolicyResponse',
            'setCash' => '\\App\\Insis\\StructType\\SetCash',
            'setCashResponse' => '\\App\\Insis\\StructType\\SetCashResponse',
            'calcOsgpoAutoCalendar' => '\\App\\Insis\\StructType\\CalcOsgpoAutoCalendar',
            'calcOsgpoAutoCalendarResponse' => '\\App\\Insis\\StructType\\CalcOsgpoAutoCalendarResponse',
            'getMarkTS' => '\\App\\Insis\\StructType\\GetMarkTS',
            'getMarkTSResponse' => '\\App\\Insis\\StructType\\GetMarkTSResponse',
            'getReport' => '\\App\\Insis\\StructType\\GetReport',
            'reportParam' => '\\App\\Insis\\StructType\\ReportParam',
            'getReportResponse' => '\\App\\Insis\\StructType\\GetReportResponse',
            'mergeSiebelBoxClient' => '\\App\\Insis\\StructType\\MergeSiebelBoxClient',
            'mergeSiebelBoxClientResponse' => '\\App\\Insis\\StructType\\MergeSiebelBoxClientResponse',
            'annulBox' => '\\App\\Insis\\StructType\\AnnulBox',
            'annulBoxResponse' => '\\App\\Insis\\StructType\\AnnulBoxResponse',
            'getAgentByKeyFields' => '\\App\\Insis\\StructType\\GetAgentByKeyFields',
            'getAgentByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetAgentByKeyFieldsResponse',
            'checkForClient' => '\\App\\Insis\\StructType\\CheckForClient',
            'checkForClientResponse' => '\\App\\Insis\\StructType\\CheckForClientResponse',
            'deleteBill' => '\\App\\Insis\\StructType\\DeleteBill',
            'deleteBillResponse' => '\\App\\Insis\\StructType\\DeleteBillResponse',
            'sendTestMailForMe' => '\\App\\Insis\\StructType\\SendTestMailForMe',
            'sendTestMailForMeResponse' => '\\App\\Insis\\StructType\\SendTestMailForMeResponse',
            'setBoxPayments' => '\\App\\Insis\\StructType\\SetBoxPayments',
            'setBoxPaymentsResponse' => '\\App\\Insis\\StructType\\SetBoxPaymentsResponse',
            'setBlanks' => '\\App\\Insis\\StructType\\SetBlanks',
            'setBlanksResponse' => '\\App\\Insis\\StructType\\SetBlanksResponse',
            'getTechInspByKeyFields' => '\\App\\Insis\\StructType\\GetTechInspByKeyFields',
            'getTechInspByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetTechInspByKeyFieldsResponse',
            'getPolicyPaidPremium' => '\\App\\Insis\\StructType\\GetPolicyPaidPremium',
            'getPolicyPaidPremiumResponse' => '\\App\\Insis\\StructType\\GetPolicyPaidPremiumResponse',
            'getPoliciesForPaymentByKeyFields' => '\\App\\Insis\\StructType\\GetPoliciesForPaymentByKeyFields',
            'policyPayment' => '\\App\\Insis\\StructType\\PolicyPayment',
            'getPoliciesForPaymentByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetPoliciesForPaymentByKeyFieldsResponse',
            'setPaymentReference' => '\\App\\Insis\\StructType\\SetPaymentReference',
            'setPaymentReferenceResponse' => '\\App\\Insis\\StructType\\SetPaymentReferenceResponse',
            'getNameByIIN' => '\\App\\Insis\\StructType\\GetNameByIIN',
            'getNameByIINResponse' => '\\App\\Insis\\StructType\\GetNameByIINResponse',
            'activeTechInspection' => '\\App\\Insis\\StructType\\ActiveTechInspection',
            'activeTechInspectionResponse' => '\\App\\Insis\\StructType\\ActiveTechInspectionResponse',
            'getPremiumTravelPolicy' => '\\App\\Insis\\StructType\\GetPremiumTravelPolicy',
            'getPremiumTravelPolicyResponse' => '\\App\\Insis\\StructType\\GetPremiumTravelPolicyResponse',
            'getBoxIdByNumber' => '\\App\\Insis\\StructType\\GetBoxIdByNumber',
            'getBoxIdByNumberResponse' => '\\App\\Insis\\StructType\\GetBoxIdByNumberResponse',
            'annulApplication' => '\\App\\Insis\\StructType\\AnnulApplication',
            'annulApplicationResponse' => '\\App\\Insis\\StructType\\AnnulApplicationResponse',
            'getStandartRiskValues' => '\\App\\Insis\\StructType\\GetStandartRiskValues',
            'getStandartRiskValuesResponse' => '\\App\\Insis\\StructType\\GetStandartRiskValuesResponse',
            'getClaimByPeriod' => '\\App\\Insis\\StructType\\GetClaimByPeriod',
            'getClaimByPeriodResponse' => '\\App\\Insis\\StructType\\GetClaimByPeriodResponse',
            'claim' => '\\App\\Insis\\StructType\\Claim',
            'claimState' => '\\App\\Insis\\StructType\\ClaimState',
            'getTariffList' => '\\App\\Insis\\StructType\\GetTariffList',
            'getTariffListResponse' => '\\App\\Insis\\StructType\\GetTariffListResponse',
            'getStandartMultiCoverValues' => '\\App\\Insis\\StructType\\GetStandartMultiCoverValues',
            'getStandartMultiCoverValuesResponse' => '\\App\\Insis\\StructType\\GetStandartMultiCoverValuesResponse',
            'sendPrintFormToEmail' => '\\App\\Insis\\StructType\\SendPrintFormToEmail',
            'sendPrintFormToEmailResponse' => '\\App\\Insis\\StructType\\SendPrintFormToEmailResponse',
            'getArchiveByKeyFields' => '\\App\\Insis\\StructType\\GetArchiveByKeyFields',
            'getArchiveByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetArchiveByKeyFieldsResponse',
            'setArchiveConfirm' => '\\App\\Insis\\StructType\\SetArchiveConfirm',
            'setArchiveConfirmResponse' => '\\App\\Insis\\StructType\\SetArchiveConfirmResponse',
            'getDraftRequestForPrint' => '\\App\\Insis\\StructType\\GetDraftRequestForPrint',
            'getDraftRequestForPrintResponse' => '\\App\\Insis\\StructType\\GetDraftRequestForPrintResponse',
            'PremFromFirstPolicy' => '\\App\\Insis\\StructType\\PremFromFirstPolicy',
            'PremFromFirstPolicyResponse' => '\\App\\Insis\\StructType\\PremFromFirstPolicyResponse',
            'getStandartCovers' => '\\App\\Insis\\StructType\\GetStandartCovers',
            'getStandartCoversResponse' => '\\App\\Insis\\StructType\\GetStandartCoversResponse',
            'setHalykTravel' => '\\App\\Insis\\StructType\\SetHalykTravel',
            'halykTravel' => '\\App\\Insis\\StructType\\HalykTravel',
            'halykTravelTrace' => '\\App\\Insis\\StructType\\HalykTravelTrace',
            'setHalykTravelResponse' => '\\App\\Insis\\StructType\\SetHalykTravelResponse',
            'checkObjectCar' => '\\App\\Insis\\StructType\\CheckObjectCar',
            'checkObjectCarResponse' => '\\App\\Insis\\StructType\\CheckObjectCarResponse',
            'setTravelPolicy' => '\\App\\Insis\\StructType\\SetTravelPolicy',
            'travelPolicy' => '\\App\\Insis\\StructType\\TravelPolicy',
            'travelClient' => '\\App\\Insis\\StructType\\TravelClient',
            'setTravelPolicyResponse' => '\\App\\Insis\\StructType\\SetTravelPolicyResponse',
            'getStaffByKeyFields' => '\\App\\Insis\\StructType\\GetStaffByKeyFields',
            'staff' => '\\App\\Insis\\StructType\\Staff',
            'getStaffByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetStaffByKeyFieldsResponse',
            'getHalykTravelByKeyFields' => '\\App\\Insis\\StructType\\GetHalykTravelByKeyFields',
            'getHalykTravelByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetHalykTravelByKeyFieldsResponse',
            'getClaimByKeyFields' => '\\App\\Insis\\StructType\\GetClaimByKeyFields',
            'getClaimByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetClaimByKeyFieldsResponse',
            'checkPeopleInfo' => '\\App\\Insis\\StructType\\CheckPeopleInfo',
            'checkPeopleInfoResponse' => '\\App\\Insis\\StructType\\CheckPeopleInfoResponse',
            'getDocumentAttachment' => '\\App\\Insis\\StructType\\GetDocumentAttachment',
            'getDocumentAttachmentResponse' => '\\App\\Insis\\StructType\\GetDocumentAttachmentResponse',
            'annulOilCoupon' => '\\App\\Insis\\StructType\\AnnulOilCoupon',
            'annulOilCouponResponse' => '\\App\\Insis\\StructType\\AnnulOilCouponResponse',
            'getSiebelBoxPayment' => '\\App\\Insis\\StructType\\GetSiebelBoxPayment',
            'getSiebelBoxPaymentResponse' => '\\App\\Insis\\StructType\\GetSiebelBoxPaymentResponse',
            'siebelBoxPayment' => '\\App\\Insis\\StructType\\SiebelBoxPayment',
            'setObjectCargo' => '\\App\\Insis\\StructType\\SetObjectCargo',
            'setObjectCargoResponse' => '\\App\\Insis\\StructType\\SetObjectCargoResponse',
            'getPoliciesByKeyFields' => '\\App\\Insis\\StructType\\GetPoliciesByKeyFields',
            'getPoliciesByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetPoliciesByKeyFieldsResponse',
            'setObjectCar' => '\\App\\Insis\\StructType\\SetObjectCar',
            'setObjectCarResponse' => '\\App\\Insis\\StructType\\SetObjectCarResponse',
            'setPolicyOGPOAuto' => '\\App\\Insis\\StructType\\SetPolicyOGPOAuto',
            'setPolicyOGPOAutoResponse' => '\\App\\Insis\\StructType\\SetPolicyOGPOAutoResponse',
            'markPayment' => '\\App\\Insis\\StructType\\MarkPayment',
            'markPaymentResponse' => '\\App\\Insis\\StructType\\MarkPaymentResponse',
            'getCarByNumber' => '\\App\\Insis\\StructType\\GetCarByNumber',
            'getCarByNumberResponse' => '\\App\\Insis\\StructType\\GetCarByNumberResponse',
            'getPremForSite' => '\\App\\Insis\\StructType\\GetPremForSite',
            'getPremForSiteResponse' => '\\App\\Insis\\StructType\\GetPremForSiteResponse',
            'activateBox' => '\\App\\Insis\\StructType\\ActivateBox',
            'activateBoxResponse' => '\\App\\Insis\\StructType\\ActivateBoxResponse',
            'getReportParams' => '\\App\\Insis\\StructType\\GetReportParams',
            'getReportParamsResponse' => '\\App\\Insis\\StructType\\GetReportParamsResponse',
            'getBoxPayment' => '\\App\\Insis\\StructType\\GetBoxPayment',
            'getBoxPaymentResponse' => '\\App\\Insis\\StructType\\GetBoxPaymentResponse',
            'getClientClassByKeyFields' => '\\App\\Insis\\StructType\\GetClientClassByKeyFields',
            'getClientClassByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetClientClassByKeyFieldsResponse',
            'setBoxAddressKATO' => '\\App\\Insis\\StructType\\SetBoxAddressKATO',
            'setBoxAddressKATOResponse' => '\\App\\Insis\\StructType\\SetBoxAddressKATOResponse',
            'renewalPolicy' => '\\App\\Insis\\StructType\\RenewalPolicy',
            'renewalPolicyResponse' => '\\App\\Insis\\StructType\\RenewalPolicyResponse',
            'getClaimSiteView' => '\\App\\Insis\\StructType\\GetClaimSiteView',
            'getClaimSiteViewResponse' => '\\App\\Insis\\StructType\\GetClaimSiteViewResponse',
            'claimSiteView' => '\\App\\Insis\\StructType\\ClaimSiteView',
            'claimStateSiteView' => '\\App\\Insis\\StructType\\ClaimStateSiteView',
            'claimDocumentSiteView' => '\\App\\Insis\\StructType\\ClaimDocumentSiteView',
            'getBillByKeyFields' => '\\App\\Insis\\StructType\\GetBillByKeyFields',
            'getBillByKeyFieldsResponse' => '\\App\\Insis\\StructType\\GetBillByKeyFieldsResponse',
            'billList' => '\\App\\Insis\\StructType\\BillList',
            'getBoxPremium' => '\\App\\Insis\\StructType\\GetBoxPremium',
            'getBoxPremiumResponse' => '\\App\\Insis\\StructType\\GetBoxPremiumResponse',
            'seyHello' => '\\App\\Insis\\StructType\\SeyHello',
            'seyHelloResponse' => '\\App\\Insis\\StructType\\SeyHelloResponse',
            'setObjectCustom' => '\\App\\Insis\\StructType\\SetObjectCustom',
            'objectCustom' => '\\App\\Insis\\StructType\\ObjectCustom',
            'setObjectCustomResponse' => '\\App\\Insis\\StructType\\SetObjectCustomResponse',
            'getVerifiedPeople' => '\\App\\Insis\\StructType\\GetVerifiedPeople',
            'getVerifiedPeopleResponse' => '\\App\\Insis\\StructType\\GetVerifiedPeopleResponse',
            'changeBlankStatus' => '\\App\\Insis\\StructType\\ChangeBlankStatus',
            'changeBlankStatusResponse' => '\\App\\Insis\\StructType\\ChangeBlankStatusResponse',
            'getLimitConditions' => '\\App\\Insis\\StructType\\GetLimitConditions',
            'getLimitConditionsResponse' => '\\App\\Insis\\StructType\\GetLimitConditionsResponse',
            'checkSiebelBox' => '\\App\\Insis\\StructType\\CheckSiebelBox',
            'checkSiebelBoxResponse' => '\\App\\Insis\\StructType\\CheckSiebelBoxResponse',
            'setObjectProperty' => '\\App\\Insis\\StructType\\SetObjectProperty',
            'setObjectPropertyResponse' => '\\App\\Insis\\StructType\\SetObjectPropertyResponse',
            'sendSmsTechInspection' => '\\App\\Insis\\StructType\\SendSmsTechInspection',
            'sendSmsTechInspectionResponse' => '\\App\\Insis\\StructType\\SendSmsTechInspectionResponse',
            'APITest' => '\\App\\Insis\\StructType\\APITest',
            'APITestResponse' => '\\App\\Insis\\StructType\\APITestResponse',
            'calcOp_onai' => '\\App\\Insis\\StructType\\CalcOp_onai',
            'calcOp_onaiResponse' => '\\App\\Insis\\StructType\\CalcOp_onaiResponse',
            'getCarInfo' => '\\App\\Insis\\StructType\\GetCarInfo',
            'getCarInfoResponse' => '\\App\\Insis\\StructType\\GetCarInfoResponse',
            'calcMst' => '\\App\\Insis\\StructType\\CalcMst',
            'calcMstResponse' => '\\App\\Insis\\StructType\\CalcMstResponse',
            'markPaymentTerminal' => '\\App\\Insis\\StructType\\MarkPaymentTerminal',
            'markPaymentTerminalResponse' => '\\App\\Insis\\StructType\\MarkPaymentTerminalResponse',
            'getPremiumAndInsName' => '\\App\\Insis\\StructType\\GetPremiumAndInsName',
            'getPremiumAndInsNameResponse' => '\\App\\Insis\\StructType\\GetPremiumAndInsNameResponse',
            'getPolicy' => '\\App\\Insis\\StructType\\GetPolicy',
            'getPolicyResponse' => '\\App\\Insis\\StructType\\GetPolicyResponse',
            'checkPolicyStatus' => '\\App\\Insis\\StructType\\CheckPolicyStatus',
            'checkPolicyStatusResponse' => '\\App\\Insis\\StructType\\CheckPolicyStatusResponse',
            'getClientClassByIIN' => '\\App\\Insis\\StructType\\GetClientClassByIIN',
            'getClientClassByIINResponse' => '\\App\\Insis\\StructType\\GetClientClassByIINResponse',
            'addSiebelBoxFile' => '\\App\\Insis\\StructType\\AddSiebelBoxFile',
            'addSiebelBoxFileResponse' => '\\App\\Insis\\StructType\\AddSiebelBoxFileResponse',
            'sendPrintFormToEmailIPTest' => '\\App\\Insis\\StructType\\SendPrintFormToEmailIPTest',
            'sendPrintFormToEmailIPTestResponse' => '\\App\\Insis\\StructType\\SendPrintFormToEmailIPTestResponse',
            'setErrorText' => '\\App\\Insis\\StructType\\SetErrorText',
            'onlineUserData' => '\\App\\Insis\\StructType\\OnlineUserData',
            'setErrorTextResponse' => '\\App\\Insis\\StructType\\SetErrorTextResponse',
            'getPeopleShort' => '\\App\\Insis\\StructType\\GetPeopleShort',
            'getPeopleShortResponse' => '\\App\\Insis\\StructType\\GetPeopleShortResponse',
            'setCallCenterSale' => '\\App\\Insis\\StructType\\SetCallCenterSale',
            'setCallCenterSaleResponse' => '\\App\\Insis\\StructType\\SetCallCenterSaleResponse',
            'getPolicyPrint' => '\\App\\Insis\\StructType\\GetPolicyPrint',
            'getPolicyPrintResponse' => '\\App\\Insis\\StructType\\GetPolicyPrintResponse',
            'convertPolicy' => '\\App\\Insis\\StructType\\ConvertPolicy',
            'convertPolicyResponse' => '\\App\\Insis\\StructType\\ConvertPolicyResponse',
            'checkFormats' => '\\App\\Insis\\StructType\\CheckFormats',
            'checkFormatsResponse' => '\\App\\Insis\\StructType\\CheckFormatsResponse',
            'setSiebelPolicy' => '\\App\\Insis\\StructType\\SetSiebelPolicy',
            'siebelPolicy' => '\\App\\Insis\\StructType\\SiebelPolicy',
            'siebelBeneficiary' => '\\App\\Insis\\StructType\\SiebelBeneficiary',
            'siebelBeneficiaryAddress' => '\\App\\Insis\\StructType\\SiebelBeneficiaryAddress',
            'siebelBeneficiaryBank' => '\\App\\Insis\\StructType\\SiebelBeneficiaryBank',
            'siebelInsurer' => '\\App\\Insis\\StructType\\SiebelInsurer',
            'siebelInsurerAddress' => '\\App\\Insis\\StructType\\SiebelInsurerAddress',
            'siebelInsurerBank' => '\\App\\Insis\\StructType\\SiebelInsurerBank',
            'siebelObject' => '\\App\\Insis\\StructType\\SiebelObject',
            'siebelAttributes' => '\\App\\Insis\\StructType\\SiebelAttributes',
            'siebelAttributesTable' => '\\App\\Insis\\StructType\\SiebelAttributesTable',
            'siebelRisk' => '\\App\\Insis\\StructType\\SiebelRisk',
            'siebelEvents' => '\\App\\Insis\\StructType\\SiebelEvents',
            'siebelClass' => '\\App\\Insis\\StructType\\SiebelClass',
            'siebelPaymentFact' => '\\App\\Insis\\StructType\\SiebelPaymentFact',
            'siebelPaymentPlan' => '\\App\\Insis\\StructType\\SiebelPaymentPlan',
            'siebelPaymentOffset' => '\\App\\Insis\\StructType\\SiebelPaymentOffset',
            'setSiebelPolicyResponse' => '\\App\\Insis\\StructType\\SetSiebelPolicyResponse',
            'siebelResult' => '\\App\\Insis\\StructType\\SiebelResult',
            'getOilQR' => '\\App\\Insis\\StructType\\GetOilQR',
            'getOilQRResponse' => '\\App\\Insis\\StructType\\GetOilQRResponse',
        );
    }
}
