<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TradeDocInformationSealsCnt StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TradeDocInformationSealsCnt
 * @subpackage Structs
 */
class TradeDocInformationSealsCnt extends AbstractStructBase
{
    /**
     * The Marks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Marks;
    /**
     * The SealingParty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SealingParty;
    /**
     * Constructor method for TradeDocInformationSealsCnt
     * @uses TradeDocInformationSealsCnt::setMarks()
     * @uses TradeDocInformationSealsCnt::setSealingParty()
     * @param string $marks
     * @param string $sealingParty
     */
    public function __construct($marks = null, $sealingParty = null)
    {
        $this
            ->setMarks($marks)
            ->setSealingParty($sealingParty);
    }
    /**
     * Get Marks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarks()
    {
        return isset($this->Marks) ? $this->Marks : null;
    }
    /**
     * Set Marks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marks
     * @return \StructType\TradeDocInformationSealsCnt
     */
    public function setMarks($marks = null)
    {
        // validation for constraint: string
        if (!is_null($marks) && !is_string($marks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marks, true), gettype($marks)), __LINE__);
        }
        if (is_null($marks) || (is_array($marks) && empty($marks))) {
            unset($this->Marks);
        } else {
            $this->Marks = $marks;
        }
        return $this;
    }
    /**
     * Get SealingParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSealingParty()
    {
        return isset($this->SealingParty) ? $this->SealingParty : null;
    }
    /**
     * Set SealingParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sealingParty
     * @return \StructType\TradeDocInformationSealsCnt
     */
    public function setSealingParty($sealingParty = null)
    {
        // validation for constraint: string
        if (!is_null($sealingParty) && !is_string($sealingParty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sealingParty, true), gettype($sealingParty)), __LINE__);
        }
        if (is_null($sealingParty) || (is_array($sealingParty) && empty($sealingParty))) {
            unset($this->SealingParty);
        } else {
            $this->SealingParty = $sealingParty;
        }
        return $this;
    }
}
