<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonInquiryFault StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PersonInquiryFault
 * @subpackage Structs
 */
class PersonInquiryFault extends AbstractStructBase
{
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The ReceiverInquiryInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseItem
     */
    public $ReceiverInquiryInfo;
    /**
     * The SenderInquiryInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseItem
     */
    public $SenderInquiryInfo;
    /**
     * Constructor method for PersonInquiryFault
     * @uses PersonInquiryFault::setMessage()
     * @uses PersonInquiryFault::setReceiverInquiryInfo()
     * @uses PersonInquiryFault::setSenderInquiryInfo()
     * @param string $message
     * @param \StructType\ResponseItem $receiverInquiryInfo
     * @param \StructType\ResponseItem $senderInquiryInfo
     */
    public function __construct($message = null, \StructType\ResponseItem $receiverInquiryInfo = null, \StructType\ResponseItem $senderInquiryInfo = null)
    {
        $this
            ->setMessage($message)
            ->setReceiverInquiryInfo($receiverInquiryInfo)
            ->setSenderInquiryInfo($senderInquiryInfo);
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \StructType\PersonInquiryFault
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get ReceiverInquiryInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseItem|null
     */
    public function getReceiverInquiryInfo()
    {
        return isset($this->ReceiverInquiryInfo) ? $this->ReceiverInquiryInfo : null;
    }
    /**
     * Set ReceiverInquiryInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseItem $receiverInquiryInfo
     * @return \StructType\PersonInquiryFault
     */
    public function setReceiverInquiryInfo(\StructType\ResponseItem $receiverInquiryInfo = null)
    {
        if (is_null($receiverInquiryInfo) || (is_array($receiverInquiryInfo) && empty($receiverInquiryInfo))) {
            unset($this->ReceiverInquiryInfo);
        } else {
            $this->ReceiverInquiryInfo = $receiverInquiryInfo;
        }
        return $this;
    }
    /**
     * Get SenderInquiryInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseItem|null
     */
    public function getSenderInquiryInfo()
    {
        return isset($this->SenderInquiryInfo) ? $this->SenderInquiryInfo : null;
    }
    /**
     * Set SenderInquiryInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseItem $senderInquiryInfo
     * @return \StructType\PersonInquiryFault
     */
    public function setSenderInquiryInfo(\StructType\ResponseItem $senderInquiryInfo = null)
    {
        if (is_null($senderInquiryInfo) || (is_array($senderInquiryInfo) && empty($senderInquiryInfo))) {
            unset($this->SenderInquiryInfo);
        } else {
            $this->SenderInquiryInfo = $senderInquiryInfo;
        }
        return $this;
    }
}
