<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Inquiry_Insurance StructType
 * @subpackage Structs
 */
class Inquiry_Insurance extends AbstractStructBase
{
    /**
     * The InsuranceCompany
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InsuranceCompany;
    /**
     * The InsuranceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsuranceNumber;
    /**
     * Constructor method for Inquiry_Insurance
     * @uses Inquiry_Insurance::setInsuranceCompany()
     * @uses Inquiry_Insurance::setInsuranceNumber()
     * @param string $insuranceCompany
     * @param string $insuranceNumber
     */
    public function __construct($insuranceCompany = null, $insuranceNumber = null)
    {
        $this
            ->setInsuranceCompany($insuranceCompany)
            ->setInsuranceNumber($insuranceNumber);
    }
    /**
     * Get InsuranceCompany value
     * @return string|null
     */
    public function getInsuranceCompany()
    {
        return $this->InsuranceCompany;
    }
    /**
     * Set InsuranceCompany value
     * @uses \EnumType\InsuranceCompanyEnum::valueIsValid()
     * @uses \EnumType\InsuranceCompanyEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insuranceCompany
     * @return \StructType\Inquiry_Insurance
     */
    public function setInsuranceCompany($insuranceCompany = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InsuranceCompanyEnum::valueIsValid($insuranceCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InsuranceCompanyEnum', is_array($insuranceCompany) ? implode(', ', $insuranceCompany) : var_export($insuranceCompany, true), implode(', ', \EnumType\InsuranceCompanyEnum::getValidValues())), __LINE__);
        }
        $this->InsuranceCompany = $insuranceCompany;
        return $this;
    }
    /**
     * Get InsuranceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsuranceNumber()
    {
        return isset($this->InsuranceNumber) ? $this->InsuranceNumber : null;
    }
    /**
     * Set InsuranceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $insuranceNumber
     * @return \StructType\Inquiry_Insurance
     */
    public function setInsuranceNumber($insuranceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceNumber) && !is_string($insuranceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insuranceNumber, true), gettype($insuranceNumber)), __LINE__);
        }
        if (is_null($insuranceNumber) || (is_array($insuranceNumber) && empty($insuranceNumber))) {
            unset($this->InsuranceNumber);
        } else {
            $this->InsuranceNumber = $insuranceNumber;
        }
        return $this;
    }
}
