<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Register ServiceType
 * @subpackage Services
 */
class Register extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RegisterBillOfLadingFormAsDamaged
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegisterBillOfLadingFormAsDamaged $parameters
     * @return \StructType\RegisterBillOfLadingFormAsDamagedResponse|bool
     */
    public function RegisterBillOfLadingFormAsDamaged(\StructType\RegisterBillOfLadingFormAsDamaged $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegisterBillOfLadingFormAsDamaged($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegisterReceipt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegisterReceipt $parameters
     * @return \StructType\RegisterReceiptResponse|bool
     */
    public function RegisterReceipt(\StructType\RegisterReceipt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegisterReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RegisterBillOfLadingFormAsDamagedResponse|\StructType\RegisterReceiptResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
