<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Load ServiceType
 * @subpackage Services
 */
class Load extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LoadBillOfLadingByNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadBillOfLadingByNumber $parameters
     * @return \StructType\LoadBillOfLadingByNumberResponse|bool
     */
    public function LoadBillOfLadingByNumber(\StructType\LoadBillOfLadingByNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadBillOfLadingByNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadAllBillOfLadingByNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoadAllBillOfLadingByNumber $parameters
     * @return \StructType\LoadAllBillOfLadingByNumberResponse|bool
     */
    public function LoadAllBillOfLadingByNumber(\StructType\LoadAllBillOfLadingByNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoadAllBillOfLadingByNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LoadAllBillOfLadingByNumberResponse|\StructType\LoadBillOfLadingByNumberResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
