<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Receipt
 * @subpackage Structs
 */
class Receipt extends AbstractStructBase
{
    /**
     * The Cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Cost;
    /**
     * The DepositDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersianDate
     */
    public $DepositDate;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Number;
    /**
     * The Serial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Serial;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Receipt
     * @uses Receipt::setCost()
     * @uses Receipt::setDepositDate()
     * @uses Receipt::setNumber()
     * @uses Receipt::setSerial()
     * @uses Receipt::setType()
     * @param int $cost
     * @param \StructType\PersianDate $depositDate
     * @param int $number
     * @param string $serial
     * @param string $type
     */
    public function __construct($cost = null, \StructType\PersianDate $depositDate = null, $number = null, $serial = null, $type = null)
    {
        $this
            ->setCost($cost)
            ->setDepositDate($depositDate)
            ->setNumber($number)
            ->setSerial($serial)
            ->setType($type);
    }
    /**
     * Get Cost value
     * @return int|null
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param int $cost
     * @return \StructType\Receipt
     */
    public function setCost($cost = null)
    {
        // validation for constraint: int
        if (!is_null($cost) && !(is_int($cost) || ctype_digit($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->Cost = $cost;
        return $this;
    }
    /**
     * Get DepositDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersianDate|null
     */
    public function getDepositDate()
    {
        return isset($this->DepositDate) ? $this->DepositDate : null;
    }
    /**
     * Set DepositDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PersianDate $depositDate
     * @return \StructType\Receipt
     */
    public function setDepositDate(\StructType\PersianDate $depositDate = null)
    {
        if (is_null($depositDate) || (is_array($depositDate) && empty($depositDate))) {
            unset($this->DepositDate);
        } else {
            $this->DepositDate = $depositDate;
        }
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\Receipt
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Serial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerial()
    {
        return isset($this->Serial) ? $this->Serial : null;
    }
    /**
     * Set Serial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serial
     * @return \StructType\Receipt
     */
    public function setSerial($serial = null)
    {
        // validation for constraint: string
        if (!is_null($serial) && !is_string($serial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serial, true), gettype($serial)), __LINE__);
        }
        if (is_null($serial) || (is_array($serial) && empty($serial))) {
            unset($this->Serial);
        } else {
            $this->Serial = $serial;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\ReceiptType::valueIsValid()
     * @uses \EnumType\ReceiptType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Receipt
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReceiptType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReceiptType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\ReceiptType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
