<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RadTaeidCnt StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RadTaeidCnt
 * @subpackage Structs
 */
class RadTaeidCnt extends AbstractStructBase
{
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Count;
    /**
     * The Error_Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Error_Code;
    /**
     * The Error_Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Error_Message;
    /**
     * The data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRadTaeidDataCnt
     */
    public $data;
    /**
     * Constructor method for RadTaeidCnt
     * @uses RadTaeidCnt::setCount()
     * @uses RadTaeidCnt::setError_Code()
     * @uses RadTaeidCnt::setError_Message()
     * @uses RadTaeidCnt::setData()
     * @param int $count
     * @param int $error_Code
     * @param string $error_Message
     * @param \ArrayType\ArrayOfRadTaeidDataCnt $data
     */
    public function __construct($count = null, $error_Code = null, $error_Message = null, \ArrayType\ArrayOfRadTaeidDataCnt $data = null)
    {
        $this
            ->setCount($count)
            ->setError_Code($error_Code)
            ->setError_Message($error_Message)
            ->setData($data);
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\RadTaeidCnt
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get Error_Code value
     * @return int|null
     */
    public function getError_Code()
    {
        return $this->Error_Code;
    }
    /**
     * Set Error_Code value
     * @param int $error_Code
     * @return \StructType\RadTaeidCnt
     */
    public function setError_Code($error_Code = null)
    {
        // validation for constraint: int
        if (!is_null($error_Code) && !(is_int($error_Code) || ctype_digit($error_Code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($error_Code, true), gettype($error_Code)), __LINE__);
        }
        $this->Error_Code = $error_Code;
        return $this;
    }
    /**
     * Get Error_Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getError_Message()
    {
        return isset($this->Error_Message) ? $this->Error_Message : null;
    }
    /**
     * Set Error_Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $error_Message
     * @return \StructType\RadTaeidCnt
     */
    public function setError_Message($error_Message = null)
    {
        // validation for constraint: string
        if (!is_null($error_Message) && !is_string($error_Message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error_Message, true), gettype($error_Message)), __LINE__);
        }
        if (is_null($error_Message) || (is_array($error_Message) && empty($error_Message))) {
            unset($this->Error_Message);
        } else {
            $this->Error_Message = $error_Message;
        }
        return $this;
    }
    /**
     * Get data value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRadTaeidDataCnt|null
     */
    public function getData()
    {
        return isset($this->data) ? $this->data : null;
    }
    /**
     * Set data value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRadTaeidDataCnt $data
     * @return \StructType\RadTaeidCnt
     */
    public function setData(\ArrayType\ArrayOfRadTaeidDataCnt $data = null)
    {
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->data);
        } else {
            $this->data = $data;
        }
        return $this;
    }
}
