<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersianDate StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PersianDate
 * @subpackage Structs
 */
class PersianDate extends AbstractStructBase
{
    /**
     * The Day
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Day;
    /**
     * The Month
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Month;
    /**
     * The Year
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Year;
    /**
     * Constructor method for PersianDate
     * @uses PersianDate::setDay()
     * @uses PersianDate::setMonth()
     * @uses PersianDate::setYear()
     * @param int $day
     * @param string $month
     * @param int $year
     */
    public function __construct($day = null, $month = null, $year = null)
    {
        $this
            ->setDay($day)
            ->setMonth($month)
            ->setYear($year);
    }
    /**
     * Get Day value
     * @return int|null
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @param int $day
     * @return \StructType\PersianDate
     */
    public function setDay($day = null)
    {
        // validation for constraint: int
        if (!is_null($day) && !(is_int($day) || ctype_digit($day))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($day, true), gettype($day)), __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Get Month value
     * @return string|null
     */
    public function getMonth()
    {
        return $this->Month;
    }
    /**
     * Set Month value
     * @uses \EnumType\PersianMonth::valueIsValid()
     * @uses \EnumType\PersianMonth::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $month
     * @return \StructType\PersianDate
     */
    public function setMonth($month = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PersianMonth::valueIsValid($month)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PersianMonth', is_array($month) ? implode(', ', $month) : var_export($month, true), implode(', ', \EnumType\PersianMonth::getValidValues())), __LINE__);
        }
        $this->Month = $month;
        return $this;
    }
    /**
     * Get Year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->Year;
    }
    /**
     * Set Year value
     * @param int $year
     * @return \StructType\PersianDate
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->Year = $year;
        return $this;
    }
}
