<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertBillOfLading StructType
 * @subpackage Structs
 */
class InsertBillOfLading extends AbstractStructBase
{
    /**
     * The BillOfLading
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BillOfLading
     */
    public $BillOfLading;
    /**
     * Constructor method for InsertBillOfLading
     * @uses InsertBillOfLading::setBillOfLading()
     * @param \StructType\BillOfLading $billOfLading
     */
    public function __construct(\StructType\BillOfLading $billOfLading = null)
    {
        $this
            ->setBillOfLading($billOfLading);
    }
    /**
     * Get BillOfLading value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BillOfLading|null
     */
    public function getBillOfLading()
    {
        return isset($this->BillOfLading) ? $this->BillOfLading : null;
    }
    /**
     * Set BillOfLading value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BillOfLading $billOfLading
     * @return \StructType\InsertBillOfLading
     */
    public function setBillOfLading(\StructType\BillOfLading $billOfLading = null)
    {
        if (is_null($billOfLading) || (is_array($billOfLading) && empty($billOfLading))) {
            unset($this->BillOfLading);
        } else {
            $this->BillOfLading = $billOfLading;
        }
        return $this;
    }
}
