<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InquiryInsuranceEndorsmentResultCnt StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InquiryInsuranceEndorsmentResultCnt
 * @subpackage Structs
 */
class InquiryInsuranceEndorsmentResultCnt extends AbstractStructBase
{
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssueDate;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Text;
    /**
     * Constructor method for InquiryInsuranceEndorsmentResultCnt
     * @uses InquiryInsuranceEndorsmentResultCnt::setIssueDate()
     * @uses InquiryInsuranceEndorsmentResultCnt::setText()
     * @param string $issueDate
     * @param string $text
     */
    public function __construct($issueDate = null, $text = null)
    {
        $this
            ->setIssueDate($issueDate)
            ->setText($text);
    }
    /**
     * Get IssueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssueDate()
    {
        return isset($this->IssueDate) ? $this->IssueDate : null;
    }
    /**
     * Set IssueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issueDate
     * @return \StructType\InquiryInsuranceEndorsmentResultCnt
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        if (is_null($issueDate) || (is_array($issueDate) && empty($issueDate))) {
            unset($this->IssueDate);
        } else {
            $this->IssueDate = $issueDate;
        }
        return $this;
    }
    /**
     * Get Text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getText()
    {
        return isset($this->Text) ? $this->Text : null;
    }
    /**
     * Set Text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $text
     * @return \StructType\InquiryInsuranceEndorsmentResultCnt
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->Text);
        } else {
            $this->Text = $text;
        }
        return $this;
    }
}
