<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GoodInfo
 * @subpackage Structs
 */
class GoodInfo extends AbstractStructBase
{
    /**
     * The ContainerCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ContainerCount;
    /**
     * The ContainerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContainerID;
    /**
     * The ContainerList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTradeDocInformationContainerCnt
     */
    public $ContainerList;
    /**
     * The ContainerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContainerType;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Count;
    /**
     * The GoodTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GoodTypeCode;
    /**
     * The GrossWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GrossWeight;
    /**
     * The HSCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HSCode;
    /**
     * The IranCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IranCode;
    /**
     * The MeghdareTabieiLitr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MeghdareTabieiLitr;
    /**
     * The PackingTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PackingTypeCode;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Value;
    /**
     * The VazneMakhsoos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VazneMakhsoos;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Weight;
    /**
     * Constructor method for GoodInfo
     * @uses GoodInfo::setContainerCount()
     * @uses GoodInfo::setContainerID()
     * @uses GoodInfo::setContainerList()
     * @uses GoodInfo::setContainerType()
     * @uses GoodInfo::setCount()
     * @uses GoodInfo::setGoodTypeCode()
     * @uses GoodInfo::setGrossWeight()
     * @uses GoodInfo::setHSCode()
     * @uses GoodInfo::setIranCode()
     * @uses GoodInfo::setMeghdareTabieiLitr()
     * @uses GoodInfo::setPackingTypeCode()
     * @uses GoodInfo::setValue()
     * @uses GoodInfo::setVazneMakhsoos()
     * @uses GoodInfo::setWeight()
     * @param int $containerCount
     * @param string $containerID
     * @param \ArrayType\ArrayOfTradeDocInformationContainerCnt $containerList
     * @param string $containerType
     * @param int $count
     * @param int $goodTypeCode
     * @param string $grossWeight
     * @param int $hSCode
     * @param string $iranCode
     * @param int $meghdareTabieiLitr
     * @param int $packingTypeCode
     * @param float $value
     * @param float $vazneMakhsoos
     * @param int $weight
     */
    public function __construct($containerCount = null, $containerID = null, \ArrayType\ArrayOfTradeDocInformationContainerCnt $containerList = null, $containerType = null, $count = null, $goodTypeCode = null, $grossWeight = null, $hSCode = null, $iranCode = null, $meghdareTabieiLitr = null, $packingTypeCode = null, $value = null, $vazneMakhsoos = null, $weight = null)
    {
        $this
            ->setContainerCount($containerCount)
            ->setContainerID($containerID)
            ->setContainerList($containerList)
            ->setContainerType($containerType)
            ->setCount($count)
            ->setGoodTypeCode($goodTypeCode)
            ->setGrossWeight($grossWeight)
            ->setHSCode($hSCode)
            ->setIranCode($iranCode)
            ->setMeghdareTabieiLitr($meghdareTabieiLitr)
            ->setPackingTypeCode($packingTypeCode)
            ->setValue($value)
            ->setVazneMakhsoos($vazneMakhsoos)
            ->setWeight($weight);
    }
    /**
     * Get ContainerCount value
     * @return int|null
     */
    public function getContainerCount()
    {
        return $this->ContainerCount;
    }
    /**
     * Set ContainerCount value
     * @param int $containerCount
     * @return \StructType\GoodInfo
     */
    public function setContainerCount($containerCount = null)
    {
        // validation for constraint: int
        if (!is_null($containerCount) && !(is_int($containerCount) || ctype_digit($containerCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($containerCount, true), gettype($containerCount)), __LINE__);
        }
        $this->ContainerCount = $containerCount;
        return $this;
    }
    /**
     * Get ContainerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContainerID()
    {
        return isset($this->ContainerID) ? $this->ContainerID : null;
    }
    /**
     * Set ContainerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $containerID
     * @return \StructType\GoodInfo
     */
    public function setContainerID($containerID = null)
    {
        // validation for constraint: string
        if (!is_null($containerID) && !is_string($containerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($containerID, true), gettype($containerID)), __LINE__);
        }
        if (is_null($containerID) || (is_array($containerID) && empty($containerID))) {
            unset($this->ContainerID);
        } else {
            $this->ContainerID = $containerID;
        }
        return $this;
    }
    /**
     * Get ContainerList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTradeDocInformationContainerCnt|null
     */
    public function getContainerList()
    {
        return isset($this->ContainerList) ? $this->ContainerList : null;
    }
    /**
     * Set ContainerList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTradeDocInformationContainerCnt $containerList
     * @return \StructType\GoodInfo
     */
    public function setContainerList(\ArrayType\ArrayOfTradeDocInformationContainerCnt $containerList = null)
    {
        if (is_null($containerList) || (is_array($containerList) && empty($containerList))) {
            unset($this->ContainerList);
        } else {
            $this->ContainerList = $containerList;
        }
        return $this;
    }
    /**
     * Get ContainerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContainerType()
    {
        return isset($this->ContainerType) ? $this->ContainerType : null;
    }
    /**
     * Set ContainerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $containerType
     * @return \StructType\GoodInfo
     */
    public function setContainerType($containerType = null)
    {
        // validation for constraint: string
        if (!is_null($containerType) && !is_string($containerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($containerType, true), gettype($containerType)), __LINE__);
        }
        if (is_null($containerType) || (is_array($containerType) && empty($containerType))) {
            unset($this->ContainerType);
        } else {
            $this->ContainerType = $containerType;
        }
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\GoodInfo
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get GoodTypeCode value
     * @return int|null
     */
    public function getGoodTypeCode()
    {
        return $this->GoodTypeCode;
    }
    /**
     * Set GoodTypeCode value
     * @param int $goodTypeCode
     * @return \StructType\GoodInfo
     */
    public function setGoodTypeCode($goodTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($goodTypeCode) && !(is_int($goodTypeCode) || ctype_digit($goodTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($goodTypeCode, true), gettype($goodTypeCode)), __LINE__);
        }
        $this->GoodTypeCode = $goodTypeCode;
        return $this;
    }
    /**
     * Get GrossWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGrossWeight()
    {
        return isset($this->GrossWeight) ? $this->GrossWeight : null;
    }
    /**
     * Set GrossWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $grossWeight
     * @return \StructType\GoodInfo
     */
    public function setGrossWeight($grossWeight = null)
    {
        // validation for constraint: string
        if (!is_null($grossWeight) && !is_string($grossWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grossWeight, true), gettype($grossWeight)), __LINE__);
        }
        if (is_null($grossWeight) || (is_array($grossWeight) && empty($grossWeight))) {
            unset($this->GrossWeight);
        } else {
            $this->GrossWeight = $grossWeight;
        }
        return $this;
    }
    /**
     * Get HSCode value
     * @return int|null
     */
    public function getHSCode()
    {
        return $this->HSCode;
    }
    /**
     * Set HSCode value
     * @param int $hSCode
     * @return \StructType\GoodInfo
     */
    public function setHSCode($hSCode = null)
    {
        // validation for constraint: int
        if (!is_null($hSCode) && !(is_int($hSCode) || ctype_digit($hSCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hSCode, true), gettype($hSCode)), __LINE__);
        }
        $this->HSCode = $hSCode;
        return $this;
    }
    /**
     * Get IranCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIranCode()
    {
        return isset($this->IranCode) ? $this->IranCode : null;
    }
    /**
     * Set IranCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iranCode
     * @return \StructType\GoodInfo
     */
    public function setIranCode($iranCode = null)
    {
        // validation for constraint: string
        if (!is_null($iranCode) && !is_string($iranCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iranCode, true), gettype($iranCode)), __LINE__);
        }
        if (is_null($iranCode) || (is_array($iranCode) && empty($iranCode))) {
            unset($this->IranCode);
        } else {
            $this->IranCode = $iranCode;
        }
        return $this;
    }
    /**
     * Get MeghdareTabieiLitr value
     * @return int|null
     */
    public function getMeghdareTabieiLitr()
    {
        return $this->MeghdareTabieiLitr;
    }
    /**
     * Set MeghdareTabieiLitr value
     * @param int $meghdareTabieiLitr
     * @return \StructType\GoodInfo
     */
    public function setMeghdareTabieiLitr($meghdareTabieiLitr = null)
    {
        // validation for constraint: int
        if (!is_null($meghdareTabieiLitr) && !(is_int($meghdareTabieiLitr) || ctype_digit($meghdareTabieiLitr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($meghdareTabieiLitr, true), gettype($meghdareTabieiLitr)), __LINE__);
        }
        $this->MeghdareTabieiLitr = $meghdareTabieiLitr;
        return $this;
    }
    /**
     * Get PackingTypeCode value
     * @return int|null
     */
    public function getPackingTypeCode()
    {
        return $this->PackingTypeCode;
    }
    /**
     * Set PackingTypeCode value
     * @param int $packingTypeCode
     * @return \StructType\GoodInfo
     */
    public function setPackingTypeCode($packingTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($packingTypeCode) && !(is_int($packingTypeCode) || ctype_digit($packingTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packingTypeCode, true), gettype($packingTypeCode)), __LINE__);
        }
        $this->PackingTypeCode = $packingTypeCode;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\GoodInfo
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get VazneMakhsoos value
     * @return float|null
     */
    public function getVazneMakhsoos()
    {
        return $this->VazneMakhsoos;
    }
    /**
     * Set VazneMakhsoos value
     * @param float $vazneMakhsoos
     * @return \StructType\GoodInfo
     */
    public function setVazneMakhsoos($vazneMakhsoos = null)
    {
        // validation for constraint: float
        if (!is_null($vazneMakhsoos) && !(is_float($vazneMakhsoos) || is_numeric($vazneMakhsoos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vazneMakhsoos, true), gettype($vazneMakhsoos)), __LINE__);
        }
        $this->VazneMakhsoos = $vazneMakhsoos;
        return $this;
    }
    /**
     * Get Weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \StructType\GoodInfo
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !(is_int($weight) || ctype_digit($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
}
