<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodFullInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GoodFullInfo
 * @subpackage Structs
 */
class GoodFullInfo extends AbstractStructBase
{
    /**
     * The GoodTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GoodTitle;
    /**
     * The GoodTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GoodTypeCode;
    /**
     * The HSCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HSCode;
    /**
     * The HSTarrifTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HSTarrifTitle;
    /**
     * The IranCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IranCode;
    /**
     * The MeghdareTabieiLitr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MeghdareTabieiLitr;
    /**
     * The PackingTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PackingTitle;
    /**
     * The PackingTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PackingTypeCode;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Value;
    /**
     * The VazneMakhsoos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VazneMakhsoos;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Weight;
    /**
     * Constructor method for GoodFullInfo
     * @uses GoodFullInfo::setGoodTitle()
     * @uses GoodFullInfo::setGoodTypeCode()
     * @uses GoodFullInfo::setHSCode()
     * @uses GoodFullInfo::setHSTarrifTitle()
     * @uses GoodFullInfo::setIranCode()
     * @uses GoodFullInfo::setMeghdareTabieiLitr()
     * @uses GoodFullInfo::setPackingTitle()
     * @uses GoodFullInfo::setPackingTypeCode()
     * @uses GoodFullInfo::setValue()
     * @uses GoodFullInfo::setVazneMakhsoos()
     * @uses GoodFullInfo::setWeight()
     * @param string $goodTitle
     * @param int $goodTypeCode
     * @param int $hSCode
     * @param string $hSTarrifTitle
     * @param string $iranCode
     * @param int $meghdareTabieiLitr
     * @param string $packingTitle
     * @param int $packingTypeCode
     * @param float $value
     * @param float $vazneMakhsoos
     * @param int $weight
     */
    public function __construct($goodTitle = null, $goodTypeCode = null, $hSCode = null, $hSTarrifTitle = null, $iranCode = null, $meghdareTabieiLitr = null, $packingTitle = null, $packingTypeCode = null, $value = null, $vazneMakhsoos = null, $weight = null)
    {
        $this
            ->setGoodTitle($goodTitle)
            ->setGoodTypeCode($goodTypeCode)
            ->setHSCode($hSCode)
            ->setHSTarrifTitle($hSTarrifTitle)
            ->setIranCode($iranCode)
            ->setMeghdareTabieiLitr($meghdareTabieiLitr)
            ->setPackingTitle($packingTitle)
            ->setPackingTypeCode($packingTypeCode)
            ->setValue($value)
            ->setVazneMakhsoos($vazneMakhsoos)
            ->setWeight($weight);
    }
    /**
     * Get GoodTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGoodTitle()
    {
        return isset($this->GoodTitle) ? $this->GoodTitle : null;
    }
    /**
     * Set GoodTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $goodTitle
     * @return \StructType\GoodFullInfo
     */
    public function setGoodTitle($goodTitle = null)
    {
        // validation for constraint: string
        if (!is_null($goodTitle) && !is_string($goodTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goodTitle, true), gettype($goodTitle)), __LINE__);
        }
        if (is_null($goodTitle) || (is_array($goodTitle) && empty($goodTitle))) {
            unset($this->GoodTitle);
        } else {
            $this->GoodTitle = $goodTitle;
        }
        return $this;
    }
    /**
     * Get GoodTypeCode value
     * @return int|null
     */
    public function getGoodTypeCode()
    {
        return $this->GoodTypeCode;
    }
    /**
     * Set GoodTypeCode value
     * @param int $goodTypeCode
     * @return \StructType\GoodFullInfo
     */
    public function setGoodTypeCode($goodTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($goodTypeCode) && !(is_int($goodTypeCode) || ctype_digit($goodTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($goodTypeCode, true), gettype($goodTypeCode)), __LINE__);
        }
        $this->GoodTypeCode = $goodTypeCode;
        return $this;
    }
    /**
     * Get HSCode value
     * @return int|null
     */
    public function getHSCode()
    {
        return $this->HSCode;
    }
    /**
     * Set HSCode value
     * @param int $hSCode
     * @return \StructType\GoodFullInfo
     */
    public function setHSCode($hSCode = null)
    {
        // validation for constraint: int
        if (!is_null($hSCode) && !(is_int($hSCode) || ctype_digit($hSCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hSCode, true), gettype($hSCode)), __LINE__);
        }
        $this->HSCode = $hSCode;
        return $this;
    }
    /**
     * Get HSTarrifTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHSTarrifTitle()
    {
        return isset($this->HSTarrifTitle) ? $this->HSTarrifTitle : null;
    }
    /**
     * Set HSTarrifTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hSTarrifTitle
     * @return \StructType\GoodFullInfo
     */
    public function setHSTarrifTitle($hSTarrifTitle = null)
    {
        // validation for constraint: string
        if (!is_null($hSTarrifTitle) && !is_string($hSTarrifTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hSTarrifTitle, true), gettype($hSTarrifTitle)), __LINE__);
        }
        if (is_null($hSTarrifTitle) || (is_array($hSTarrifTitle) && empty($hSTarrifTitle))) {
            unset($this->HSTarrifTitle);
        } else {
            $this->HSTarrifTitle = $hSTarrifTitle;
        }
        return $this;
    }
    /**
     * Get IranCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIranCode()
    {
        return isset($this->IranCode) ? $this->IranCode : null;
    }
    /**
     * Set IranCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iranCode
     * @return \StructType\GoodFullInfo
     */
    public function setIranCode($iranCode = null)
    {
        // validation for constraint: string
        if (!is_null($iranCode) && !is_string($iranCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iranCode, true), gettype($iranCode)), __LINE__);
        }
        if (is_null($iranCode) || (is_array($iranCode) && empty($iranCode))) {
            unset($this->IranCode);
        } else {
            $this->IranCode = $iranCode;
        }
        return $this;
    }
    /**
     * Get MeghdareTabieiLitr value
     * @return int|null
     */
    public function getMeghdareTabieiLitr()
    {
        return $this->MeghdareTabieiLitr;
    }
    /**
     * Set MeghdareTabieiLitr value
     * @param int $meghdareTabieiLitr
     * @return \StructType\GoodFullInfo
     */
    public function setMeghdareTabieiLitr($meghdareTabieiLitr = null)
    {
        // validation for constraint: int
        if (!is_null($meghdareTabieiLitr) && !(is_int($meghdareTabieiLitr) || ctype_digit($meghdareTabieiLitr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($meghdareTabieiLitr, true), gettype($meghdareTabieiLitr)), __LINE__);
        }
        $this->MeghdareTabieiLitr = $meghdareTabieiLitr;
        return $this;
    }
    /**
     * Get PackingTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackingTitle()
    {
        return isset($this->PackingTitle) ? $this->PackingTitle : null;
    }
    /**
     * Set PackingTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packingTitle
     * @return \StructType\GoodFullInfo
     */
    public function setPackingTitle($packingTitle = null)
    {
        // validation for constraint: string
        if (!is_null($packingTitle) && !is_string($packingTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packingTitle, true), gettype($packingTitle)), __LINE__);
        }
        if (is_null($packingTitle) || (is_array($packingTitle) && empty($packingTitle))) {
            unset($this->PackingTitle);
        } else {
            $this->PackingTitle = $packingTitle;
        }
        return $this;
    }
    /**
     * Get PackingTypeCode value
     * @return int|null
     */
    public function getPackingTypeCode()
    {
        return $this->PackingTypeCode;
    }
    /**
     * Set PackingTypeCode value
     * @param int $packingTypeCode
     * @return \StructType\GoodFullInfo
     */
    public function setPackingTypeCode($packingTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($packingTypeCode) && !(is_int($packingTypeCode) || ctype_digit($packingTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packingTypeCode, true), gettype($packingTypeCode)), __LINE__);
        }
        $this->PackingTypeCode = $packingTypeCode;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\GoodFullInfo
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get VazneMakhsoos value
     * @return float|null
     */
    public function getVazneMakhsoos()
    {
        return $this->VazneMakhsoos;
    }
    /**
     * Set VazneMakhsoos value
     * @param float $vazneMakhsoos
     * @return \StructType\GoodFullInfo
     */
    public function setVazneMakhsoos($vazneMakhsoos = null)
    {
        // validation for constraint: float
        if (!is_null($vazneMakhsoos) && !(is_float($vazneMakhsoos) || is_numeric($vazneMakhsoos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vazneMakhsoos, true), gettype($vazneMakhsoos)), __LINE__);
        }
        $this->VazneMakhsoos = $vazneMakhsoos;
        return $this;
    }
    /**
     * Get Weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \StructType\GoodFullInfo
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !(is_int($weight) || ctype_digit($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
}
