<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Custom StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Custom
 * @subpackage Structs
 */
class Custom extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The KootajDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $KootajDate;
    /**
     * The KootajNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KootajNo;
    /**
     * Constructor method for Custom
     * @uses Custom::setCode()
     * @uses Custom::setKootajDate()
     * @uses Custom::setKootajNo()
     * @param string $code
     * @param string $kootajDate
     * @param string $kootajNo
     */
    public function __construct($code = null, $kootajDate = null, $kootajNo = null)
    {
        $this
            ->setCode($code)
            ->setKootajDate($kootajDate)
            ->setKootajNo($kootajNo);
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\Custom
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get KootajDate value
     * @return string|null
     */
    public function getKootajDate()
    {
        return $this->KootajDate;
    }
    /**
     * Set KootajDate value
     * @param string $kootajDate
     * @return \StructType\Custom
     */
    public function setKootajDate($kootajDate = null)
    {
        // validation for constraint: string
        if (!is_null($kootajDate) && !is_string($kootajDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kootajDate, true), gettype($kootajDate)), __LINE__);
        }
        $this->KootajDate = $kootajDate;
        return $this;
    }
    /**
     * Get KootajNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKootajNo()
    {
        return isset($this->KootajNo) ? $this->KootajNo : null;
    }
    /**
     * Set KootajNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kootajNo
     * @return \StructType\Custom
     */
    public function setKootajNo($kootajNo = null)
    {
        // validation for constraint: string
        if (!is_null($kootajNo) && !is_string($kootajNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kootajNo, true), gettype($kootajNo)), __LINE__);
        }
        if (is_null($kootajNo) || (is_array($kootajNo) && empty($kootajNo))) {
            unset($this->KootajNo);
        } else {
            $this->KootajNo = $kootajNo;
        }
        return $this;
    }
}
