<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckWaybillAssignGoodsCnt StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CheckWaybillAssignGoodsCnt
 * @subpackage Structs
 */
class CheckWaybillAssignGoodsCnt extends AbstractStructBase
{
    /**
     * The GoodTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GoodTypeCode;
    /**
     * The PackingTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PackingTypeCode;
    /**
     * Constructor method for CheckWaybillAssignGoodsCnt
     * @uses CheckWaybillAssignGoodsCnt::setGoodTypeCode()
     * @uses CheckWaybillAssignGoodsCnt::setPackingTypeCode()
     * @param int $goodTypeCode
     * @param int $packingTypeCode
     */
    public function __construct($goodTypeCode = null, $packingTypeCode = null)
    {
        $this
            ->setGoodTypeCode($goodTypeCode)
            ->setPackingTypeCode($packingTypeCode);
    }
    /**
     * Get GoodTypeCode value
     * @return int|null
     */
    public function getGoodTypeCode()
    {
        return $this->GoodTypeCode;
    }
    /**
     * Set GoodTypeCode value
     * @param int $goodTypeCode
     * @return \StructType\CheckWaybillAssignGoodsCnt
     */
    public function setGoodTypeCode($goodTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($goodTypeCode) && !(is_int($goodTypeCode) || ctype_digit($goodTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($goodTypeCode, true), gettype($goodTypeCode)), __LINE__);
        }
        $this->GoodTypeCode = $goodTypeCode;
        return $this;
    }
    /**
     * Get PackingTypeCode value
     * @return int|null
     */
    public function getPackingTypeCode()
    {
        return $this->PackingTypeCode;
    }
    /**
     * Set PackingTypeCode value
     * @param int $packingTypeCode
     * @return \StructType\CheckWaybillAssignGoodsCnt
     */
    public function setPackingTypeCode($packingTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($packingTypeCode) && !(is_int($packingTypeCode) || ctype_digit($packingTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packingTypeCode, true), gettype($packingTypeCode)), __LINE__);
        }
        $this->PackingTypeCode = $packingTypeCode;
        return $this;
    }
}
