<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckExistBillOfLadingBySerialAndNumber StructType
 * @subpackage Structs
 */
class CheckExistBillOfLadingBySerialAndNumber extends AbstractStructBase
{
    /**
     * The serial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serial;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $number;
    /**
     * Constructor method for CheckExistBillOfLadingBySerialAndNumber
     * @uses CheckExistBillOfLadingBySerialAndNumber::setSerial()
     * @uses CheckExistBillOfLadingBySerialAndNumber::setNumber()
     * @param string $serial
     * @param int $number
     */
    public function __construct($serial = null, $number = null)
    {
        $this
            ->setSerial($serial)
            ->setNumber($number);
    }
    /**
     * Get serial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerial()
    {
        return isset($this->serial) ? $this->serial : null;
    }
    /**
     * Set serial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serial
     * @return \StructType\CheckExistBillOfLadingBySerialAndNumber
     */
    public function setSerial($serial = null)
    {
        // validation for constraint: string
        if (!is_null($serial) && !is_string($serial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serial, true), gettype($serial)), __LINE__);
        }
        if (is_null($serial) || (is_array($serial) && empty($serial))) {
            unset($this->serial);
        } else {
            $this->serial = $serial;
        }
        return $this;
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \StructType\CheckExistBillOfLadingBySerialAndNumber
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
}
