<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillOfLadingInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BillOfLadingInfo
 * @subpackage Structs
 */
class BillOfLadingInfo extends AbstractStructBase
{
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Company;
    /**
     * The DestinationCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationCity;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Number;
    /**
     * The OriginCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginCity;
    /**
     * The Serial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Serial;
    /**
     * Constructor method for BillOfLadingInfo
     * @uses BillOfLadingInfo::setCompany()
     * @uses BillOfLadingInfo::setDestinationCity()
     * @uses BillOfLadingInfo::setNumber()
     * @uses BillOfLadingInfo::setOriginCity()
     * @uses BillOfLadingInfo::setSerial()
     * @param string $company
     * @param string $destinationCity
     * @param int $number
     * @param string $originCity
     * @param string $serial
     */
    public function __construct($company = null, $destinationCity = null, $number = null, $originCity = null, $serial = null)
    {
        $this
            ->setCompany($company)
            ->setDestinationCity($destinationCity)
            ->setNumber($number)
            ->setOriginCity($originCity)
            ->setSerial($serial);
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $company
     * @return \StructType\BillOfLadingInfo
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get DestinationCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationCity()
    {
        return isset($this->DestinationCity) ? $this->DestinationCity : null;
    }
    /**
     * Set DestinationCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationCity
     * @return \StructType\BillOfLadingInfo
     */
    public function setDestinationCity($destinationCity = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCity) && !is_string($destinationCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCity, true), gettype($destinationCity)), __LINE__);
        }
        if (is_null($destinationCity) || (is_array($destinationCity) && empty($destinationCity))) {
            unset($this->DestinationCity);
        } else {
            $this->DestinationCity = $destinationCity;
        }
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\BillOfLadingInfo
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get OriginCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginCity()
    {
        return isset($this->OriginCity) ? $this->OriginCity : null;
    }
    /**
     * Set OriginCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originCity
     * @return \StructType\BillOfLadingInfo
     */
    public function setOriginCity($originCity = null)
    {
        // validation for constraint: string
        if (!is_null($originCity) && !is_string($originCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCity, true), gettype($originCity)), __LINE__);
        }
        if (is_null($originCity) || (is_array($originCity) && empty($originCity))) {
            unset($this->OriginCity);
        } else {
            $this->OriginCity = $originCity;
        }
        return $this;
    }
    /**
     * Get Serial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerial()
    {
        return isset($this->Serial) ? $this->Serial : null;
    }
    /**
     * Set Serial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serial
     * @return \StructType\BillOfLadingInfo
     */
    public function setSerial($serial = null)
    {
        // validation for constraint: string
        if (!is_null($serial) && !is_string($serial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serial, true), gettype($serial)), __LINE__);
        }
        if (is_null($serial) || (is_array($serial) && empty($serial))) {
            unset($this->Serial);
        } else {
            $this->Serial = $serial;
        }
        return $this;
    }
}
