<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillOfLading StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BillOfLading
 * @subpackage Structs
 */
class BillOfLading extends AbstractStructBase
{
    /**
     * The ArrivalApproximateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalApproximateDate;
    /**
     * The ClientCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ClientCode;
    /**
     * The ClientVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientVersion;
    /**
     * The CompanyCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CompanyCommission;
    /**
     * The CompanyCommissionPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CompanyCommissionPercent;
    /**
     * The ContainerNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContainerNumber;
    /**
     * The Cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Cost;
    /**
     * The CustomInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Custom
     */
    public $CustomInfo;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DestinationCityCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DestinationCityCode;
    /**
     * The DischargeCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DischargeCost;
    /**
     * The DriverCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DriverCommission;
    /**
     * The FirstDriverCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstDriverCardNumber;
    /**
     * The FirstDriverNationalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstDriverNationalId;
    /**
     * The FreighterCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FreighterCardNumber;
    /**
     * The FreighterInsuranceExpireDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FreighterInsuranceExpireDate;
    /**
     * The FreighterInsuranceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FreighterInsuranceNumber;
    /**
     * The GoodInfoList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfGoodInfo
     */
    public $GoodInfoList;
    /**
     * The HavalehTraceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HavalehTraceCode;
    /**
     * The InsuranceCompany
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InsuranceCompany;
    /**
     * The InsuranceCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InsuranceCost;
    /**
     * The InsuranceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsuranceNumber;
    /**
     * The InsuranceTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $InsuranceTax;
    /**
     * The InternalCargoInsuranceCompany
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InternalCargoInsuranceCompany;
    /**
     * The InternalCargoInsuranceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InternalCargoInsuranceNumber;
    /**
     * The IsReturned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsReturned;
    /**
     * The IsTrafficLoad
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsTrafficLoad;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersianDate
     */
    public $IssueDate;
    /**
     * The IssueTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssueTime;
    /**
     * The KalaDesc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KalaDesc;
    /**
     * The KhordehBarList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBillOfLadingKhordehBar
     */
    public $KhordehBarList;
    /**
     * The LanderTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LanderTypeCode;
    /**
     * The LicenseNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LicenseNumber;
    /**
     * The LoadingCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LoadingCost;
    /**
     * The MasterBillofLadingTraceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterBillofLadingTraceCode;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Number;
    /**
     * The OriginCityCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OriginCityCode;
    /**
     * The PayanehCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PayanehCost;
    /**
     * The Receiver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Person
     */
    public $Receiver;
    /**
     * The ReceiverAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiverAddress;
    /**
     * The Robari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Robari;
    /**
     * The SecondDriverNationalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecondDriverNationalId;
    /**
     * The Sender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Person
     */
    public $Sender;
    /**
     * The SenderAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderAddress;
    /**
     * The Serial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Serial;
    /**
     * The ShomarehHavalehAnbarNaft
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ShomarehHavalehAnbarNaft;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Signature;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tax;
    /**
     * The TotalCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalCost;
    /**
     * The TransitTypecode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransitTypecode;
    /**
     * The WeighbridgeCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WeighbridgeCost;
    /**
     * The secondDriverCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $secondDriverCardNumber;
    /**
     * Constructor method for BillOfLading
     * @uses BillOfLading::setArrivalApproximateDate()
     * @uses BillOfLading::setClientCode()
     * @uses BillOfLading::setClientVersion()
     * @uses BillOfLading::setCompanyCommission()
     * @uses BillOfLading::setCompanyCommissionPercent()
     * @uses BillOfLading::setContainerNumber()
     * @uses BillOfLading::setCost()
     * @uses BillOfLading::setCustomInfo()
     * @uses BillOfLading::setDescription()
     * @uses BillOfLading::setDestinationCityCode()
     * @uses BillOfLading::setDischargeCost()
     * @uses BillOfLading::setDriverCommission()
     * @uses BillOfLading::setFirstDriverCardNumber()
     * @uses BillOfLading::setFirstDriverNationalId()
     * @uses BillOfLading::setFreighterCardNumber()
     * @uses BillOfLading::setFreighterInsuranceExpireDate()
     * @uses BillOfLading::setFreighterInsuranceNumber()
     * @uses BillOfLading::setGoodInfoList()
     * @uses BillOfLading::setHavalehTraceCode()
     * @uses BillOfLading::setInsuranceCompany()
     * @uses BillOfLading::setInsuranceCost()
     * @uses BillOfLading::setInsuranceNumber()
     * @uses BillOfLading::setInsuranceTax()
     * @uses BillOfLading::setInternalCargoInsuranceCompany()
     * @uses BillOfLading::setInternalCargoInsuranceNumber()
     * @uses BillOfLading::setIsReturned()
     * @uses BillOfLading::setIsTrafficLoad()
     * @uses BillOfLading::setIssueDate()
     * @uses BillOfLading::setIssueTime()
     * @uses BillOfLading::setKalaDesc()
     * @uses BillOfLading::setKhordehBarList()
     * @uses BillOfLading::setLanderTypeCode()
     * @uses BillOfLading::setLicenseNumber()
     * @uses BillOfLading::setLoadingCost()
     * @uses BillOfLading::setMasterBillofLadingTraceCode()
     * @uses BillOfLading::setNumber()
     * @uses BillOfLading::setOriginCityCode()
     * @uses BillOfLading::setPayanehCost()
     * @uses BillOfLading::setReceiver()
     * @uses BillOfLading::setReceiverAddress()
     * @uses BillOfLading::setRobari()
     * @uses BillOfLading::setSecondDriverNationalId()
     * @uses BillOfLading::setSender()
     * @uses BillOfLading::setSenderAddress()
     * @uses BillOfLading::setSerial()
     * @uses BillOfLading::setShomarehHavalehAnbarNaft()
     * @uses BillOfLading::setSignature()
     * @uses BillOfLading::setTax()
     * @uses BillOfLading::setTotalCost()
     * @uses BillOfLading::setTransitTypecode()
     * @uses BillOfLading::setWeighbridgeCost()
     * @uses BillOfLading::setSecondDriverCardNumber()
     * @param string $arrivalApproximateDate
     * @param int $clientCode
     * @param string $clientVersion
     * @param float $companyCommission
     * @param float $companyCommissionPercent
     * @param string $containerNumber
     * @param int $cost
     * @param \StructType\Custom $customInfo
     * @param string $description
     * @param int $destinationCityCode
     * @param int $dischargeCost
     * @param int $driverCommission
     * @param string $firstDriverCardNumber
     * @param string $firstDriverNationalId
     * @param string $freighterCardNumber
     * @param string $freighterInsuranceExpireDate
     * @param string $freighterInsuranceNumber
     * @param \ArrayType\ArrayOfGoodInfo $goodInfoList
     * @param string $havalehTraceCode
     * @param string $insuranceCompany
     * @param int $insuranceCost
     * @param string $insuranceNumber
     * @param float $insuranceTax
     * @param string $internalCargoInsuranceCompany
     * @param string $internalCargoInsuranceNumber
     * @param bool $isReturned
     * @param bool $isTrafficLoad
     * @param \StructType\PersianDate $issueDate
     * @param string $issueTime
     * @param string $kalaDesc
     * @param \ArrayType\ArrayOfBillOfLadingKhordehBar $khordehBarList
     * @param int $landerTypeCode
     * @param int $licenseNumber
     * @param int $loadingCost
     * @param string $masterBillofLadingTraceCode
     * @param int $number
     * @param int $originCityCode
     * @param int $payanehCost
     * @param \StructType\Person $receiver
     * @param string $receiverAddress
     * @param bool $robari
     * @param string $secondDriverNationalId
     * @param \StructType\Person $sender
     * @param string $senderAddress
     * @param string $serial
     * @param int $shomarehHavalehAnbarNaft
     * @param string $signature
     * @param int $tax
     * @param float $totalCost
     * @param int $transitTypecode
     * @param int $weighbridgeCost
     * @param string $secondDriverCardNumber
     */
    public function __construct($arrivalApproximateDate = null, $clientCode = null, $clientVersion = null, $companyCommission = null, $companyCommissionPercent = null, $containerNumber = null, $cost = null, \StructType\Custom $customInfo = null, $description = null, $destinationCityCode = null, $dischargeCost = null, $driverCommission = null, $firstDriverCardNumber = null, $firstDriverNationalId = null, $freighterCardNumber = null, $freighterInsuranceExpireDate = null, $freighterInsuranceNumber = null, \ArrayType\ArrayOfGoodInfo $goodInfoList = null, $havalehTraceCode = null, $insuranceCompany = null, $insuranceCost = null, $insuranceNumber = null, $insuranceTax = null, $internalCargoInsuranceCompany = null, $internalCargoInsuranceNumber = null, $isReturned = null, $isTrafficLoad = null, \StructType\PersianDate $issueDate = null, $issueTime = null, $kalaDesc = null, \ArrayType\ArrayOfBillOfLadingKhordehBar $khordehBarList = null, $landerTypeCode = null, $licenseNumber = null, $loadingCost = null, $masterBillofLadingTraceCode = null, $number = null, $originCityCode = null, $payanehCost = null, \StructType\Person $receiver = null, $receiverAddress = null, $robari = null, $secondDriverNationalId = null, \StructType\Person $sender = null, $senderAddress = null, $serial = null, $shomarehHavalehAnbarNaft = null, $signature = null, $tax = null, $totalCost = null, $transitTypecode = null, $weighbridgeCost = null, $secondDriverCardNumber = null)
    {
        $this
            ->setArrivalApproximateDate($arrivalApproximateDate)
            ->setClientCode($clientCode)
            ->setClientVersion($clientVersion)
            ->setCompanyCommission($companyCommission)
            ->setCompanyCommissionPercent($companyCommissionPercent)
            ->setContainerNumber($containerNumber)
            ->setCost($cost)
            ->setCustomInfo($customInfo)
            ->setDescription($description)
            ->setDestinationCityCode($destinationCityCode)
            ->setDischargeCost($dischargeCost)
            ->setDriverCommission($driverCommission)
            ->setFirstDriverCardNumber($firstDriverCardNumber)
            ->setFirstDriverNationalId($firstDriverNationalId)
            ->setFreighterCardNumber($freighterCardNumber)
            ->setFreighterInsuranceExpireDate($freighterInsuranceExpireDate)
            ->setFreighterInsuranceNumber($freighterInsuranceNumber)
            ->setGoodInfoList($goodInfoList)
            ->setHavalehTraceCode($havalehTraceCode)
            ->setInsuranceCompany($insuranceCompany)
            ->setInsuranceCost($insuranceCost)
            ->setInsuranceNumber($insuranceNumber)
            ->setInsuranceTax($insuranceTax)
            ->setInternalCargoInsuranceCompany($internalCargoInsuranceCompany)
            ->setInternalCargoInsuranceNumber($internalCargoInsuranceNumber)
            ->setIsReturned($isReturned)
            ->setIsTrafficLoad($isTrafficLoad)
            ->setIssueDate($issueDate)
            ->setIssueTime($issueTime)
            ->setKalaDesc($kalaDesc)
            ->setKhordehBarList($khordehBarList)
            ->setLanderTypeCode($landerTypeCode)
            ->setLicenseNumber($licenseNumber)
            ->setLoadingCost($loadingCost)
            ->setMasterBillofLadingTraceCode($masterBillofLadingTraceCode)
            ->setNumber($number)
            ->setOriginCityCode($originCityCode)
            ->setPayanehCost($payanehCost)
            ->setReceiver($receiver)
            ->setReceiverAddress($receiverAddress)
            ->setRobari($robari)
            ->setSecondDriverNationalId($secondDriverNationalId)
            ->setSender($sender)
            ->setSenderAddress($senderAddress)
            ->setSerial($serial)
            ->setShomarehHavalehAnbarNaft($shomarehHavalehAnbarNaft)
            ->setSignature($signature)
            ->setTax($tax)
            ->setTotalCost($totalCost)
            ->setTransitTypecode($transitTypecode)
            ->setWeighbridgeCost($weighbridgeCost)
            ->setSecondDriverCardNumber($secondDriverCardNumber);
    }
    /**
     * Get ArrivalApproximateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalApproximateDate()
    {
        return isset($this->ArrivalApproximateDate) ? $this->ArrivalApproximateDate : null;
    }
    /**
     * Set ArrivalApproximateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalApproximateDate
     * @return \StructType\BillOfLading
     */
    public function setArrivalApproximateDate($arrivalApproximateDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalApproximateDate) && !is_string($arrivalApproximateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalApproximateDate, true), gettype($arrivalApproximateDate)), __LINE__);
        }
        if (is_null($arrivalApproximateDate) || (is_array($arrivalApproximateDate) && empty($arrivalApproximateDate))) {
            unset($this->ArrivalApproximateDate);
        } else {
            $this->ArrivalApproximateDate = $arrivalApproximateDate;
        }
        return $this;
    }
    /**
     * Get ClientCode value
     * @return int|null
     */
    public function getClientCode()
    {
        return $this->ClientCode;
    }
    /**
     * Set ClientCode value
     * @param int $clientCode
     * @return \StructType\BillOfLading
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: int
        if (!is_null($clientCode) && !(is_int($clientCode) || ctype_digit($clientCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        $this->ClientCode = $clientCode;
        return $this;
    }
    /**
     * Get ClientVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientVersion()
    {
        return isset($this->ClientVersion) ? $this->ClientVersion : null;
    }
    /**
     * Set ClientVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientVersion
     * @return \StructType\BillOfLading
     */
    public function setClientVersion($clientVersion = null)
    {
        // validation for constraint: string
        if (!is_null($clientVersion) && !is_string($clientVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientVersion, true), gettype($clientVersion)), __LINE__);
        }
        if (is_null($clientVersion) || (is_array($clientVersion) && empty($clientVersion))) {
            unset($this->ClientVersion);
        } else {
            $this->ClientVersion = $clientVersion;
        }
        return $this;
    }
    /**
     * Get CompanyCommission value
     * @return float|null
     */
    public function getCompanyCommission()
    {
        return $this->CompanyCommission;
    }
    /**
     * Set CompanyCommission value
     * @param float $companyCommission
     * @return \StructType\BillOfLading
     */
    public function setCompanyCommission($companyCommission = null)
    {
        // validation for constraint: float
        if (!is_null($companyCommission) && !(is_float($companyCommission) || is_numeric($companyCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($companyCommission, true), gettype($companyCommission)), __LINE__);
        }
        $this->CompanyCommission = $companyCommission;
        return $this;
    }
    /**
     * Get CompanyCommissionPercent value
     * @return float|null
     */
    public function getCompanyCommissionPercent()
    {
        return $this->CompanyCommissionPercent;
    }
    /**
     * Set CompanyCommissionPercent value
     * @param float $companyCommissionPercent
     * @return \StructType\BillOfLading
     */
    public function setCompanyCommissionPercent($companyCommissionPercent = null)
    {
        // validation for constraint: float
        if (!is_null($companyCommissionPercent) && !(is_float($companyCommissionPercent) || is_numeric($companyCommissionPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($companyCommissionPercent, true), gettype($companyCommissionPercent)), __LINE__);
        }
        $this->CompanyCommissionPercent = $companyCommissionPercent;
        return $this;
    }
    /**
     * Get ContainerNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContainerNumber()
    {
        return isset($this->ContainerNumber) ? $this->ContainerNumber : null;
    }
    /**
     * Set ContainerNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $containerNumber
     * @return \StructType\BillOfLading
     */
    public function setContainerNumber($containerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($containerNumber) && !is_string($containerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($containerNumber, true), gettype($containerNumber)), __LINE__);
        }
        if (is_null($containerNumber) || (is_array($containerNumber) && empty($containerNumber))) {
            unset($this->ContainerNumber);
        } else {
            $this->ContainerNumber = $containerNumber;
        }
        return $this;
    }
    /**
     * Get Cost value
     * @return int|null
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param int $cost
     * @return \StructType\BillOfLading
     */
    public function setCost($cost = null)
    {
        // validation for constraint: int
        if (!is_null($cost) && !(is_int($cost) || ctype_digit($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->Cost = $cost;
        return $this;
    }
    /**
     * Get CustomInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Custom|null
     */
    public function getCustomInfo()
    {
        return isset($this->CustomInfo) ? $this->CustomInfo : null;
    }
    /**
     * Set CustomInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Custom $customInfo
     * @return \StructType\BillOfLading
     */
    public function setCustomInfo(\StructType\Custom $customInfo = null)
    {
        if (is_null($customInfo) || (is_array($customInfo) && empty($customInfo))) {
            unset($this->CustomInfo);
        } else {
            $this->CustomInfo = $customInfo;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\BillOfLading
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DestinationCityCode value
     * @return int|null
     */
    public function getDestinationCityCode()
    {
        return $this->DestinationCityCode;
    }
    /**
     * Set DestinationCityCode value
     * @param int $destinationCityCode
     * @return \StructType\BillOfLading
     */
    public function setDestinationCityCode($destinationCityCode = null)
    {
        // validation for constraint: int
        if (!is_null($destinationCityCode) && !(is_int($destinationCityCode) || ctype_digit($destinationCityCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destinationCityCode, true), gettype($destinationCityCode)), __LINE__);
        }
        $this->DestinationCityCode = $destinationCityCode;
        return $this;
    }
    /**
     * Get DischargeCost value
     * @return int|null
     */
    public function getDischargeCost()
    {
        return $this->DischargeCost;
    }
    /**
     * Set DischargeCost value
     * @param int $dischargeCost
     * @return \StructType\BillOfLading
     */
    public function setDischargeCost($dischargeCost = null)
    {
        // validation for constraint: int
        if (!is_null($dischargeCost) && !(is_int($dischargeCost) || ctype_digit($dischargeCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dischargeCost, true), gettype($dischargeCost)), __LINE__);
        }
        $this->DischargeCost = $dischargeCost;
        return $this;
    }
    /**
     * Get DriverCommission value
     * @return int|null
     */
    public function getDriverCommission()
    {
        return $this->DriverCommission;
    }
    /**
     * Set DriverCommission value
     * @param int $driverCommission
     * @return \StructType\BillOfLading
     */
    public function setDriverCommission($driverCommission = null)
    {
        // validation for constraint: int
        if (!is_null($driverCommission) && !(is_int($driverCommission) || ctype_digit($driverCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($driverCommission, true), gettype($driverCommission)), __LINE__);
        }
        $this->DriverCommission = $driverCommission;
        return $this;
    }
    /**
     * Get FirstDriverCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstDriverCardNumber()
    {
        return isset($this->FirstDriverCardNumber) ? $this->FirstDriverCardNumber : null;
    }
    /**
     * Set FirstDriverCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstDriverCardNumber
     * @return \StructType\BillOfLading
     */
    public function setFirstDriverCardNumber($firstDriverCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($firstDriverCardNumber) && !is_string($firstDriverCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstDriverCardNumber, true), gettype($firstDriverCardNumber)), __LINE__);
        }
        if (is_null($firstDriverCardNumber) || (is_array($firstDriverCardNumber) && empty($firstDriverCardNumber))) {
            unset($this->FirstDriverCardNumber);
        } else {
            $this->FirstDriverCardNumber = $firstDriverCardNumber;
        }
        return $this;
    }
    /**
     * Get FirstDriverNationalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstDriverNationalId()
    {
        return isset($this->FirstDriverNationalId) ? $this->FirstDriverNationalId : null;
    }
    /**
     * Set FirstDriverNationalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstDriverNationalId
     * @return \StructType\BillOfLading
     */
    public function setFirstDriverNationalId($firstDriverNationalId = null)
    {
        // validation for constraint: string
        if (!is_null($firstDriverNationalId) && !is_string($firstDriverNationalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstDriverNationalId, true), gettype($firstDriverNationalId)), __LINE__);
        }
        if (is_null($firstDriverNationalId) || (is_array($firstDriverNationalId) && empty($firstDriverNationalId))) {
            unset($this->FirstDriverNationalId);
        } else {
            $this->FirstDriverNationalId = $firstDriverNationalId;
        }
        return $this;
    }
    /**
     * Get FreighterCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFreighterCardNumber()
    {
        return isset($this->FreighterCardNumber) ? $this->FreighterCardNumber : null;
    }
    /**
     * Set FreighterCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $freighterCardNumber
     * @return \StructType\BillOfLading
     */
    public function setFreighterCardNumber($freighterCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($freighterCardNumber) && !is_string($freighterCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freighterCardNumber, true), gettype($freighterCardNumber)), __LINE__);
        }
        if (is_null($freighterCardNumber) || (is_array($freighterCardNumber) && empty($freighterCardNumber))) {
            unset($this->FreighterCardNumber);
        } else {
            $this->FreighterCardNumber = $freighterCardNumber;
        }
        return $this;
    }
    /**
     * Get FreighterInsuranceExpireDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFreighterInsuranceExpireDate()
    {
        return isset($this->FreighterInsuranceExpireDate) ? $this->FreighterInsuranceExpireDate : null;
    }
    /**
     * Set FreighterInsuranceExpireDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $freighterInsuranceExpireDate
     * @return \StructType\BillOfLading
     */
    public function setFreighterInsuranceExpireDate($freighterInsuranceExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($freighterInsuranceExpireDate) && !is_string($freighterInsuranceExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freighterInsuranceExpireDate, true), gettype($freighterInsuranceExpireDate)), __LINE__);
        }
        if (is_null($freighterInsuranceExpireDate) || (is_array($freighterInsuranceExpireDate) && empty($freighterInsuranceExpireDate))) {
            unset($this->FreighterInsuranceExpireDate);
        } else {
            $this->FreighterInsuranceExpireDate = $freighterInsuranceExpireDate;
        }
        return $this;
    }
    /**
     * Get FreighterInsuranceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFreighterInsuranceNumber()
    {
        return isset($this->FreighterInsuranceNumber) ? $this->FreighterInsuranceNumber : null;
    }
    /**
     * Set FreighterInsuranceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $freighterInsuranceNumber
     * @return \StructType\BillOfLading
     */
    public function setFreighterInsuranceNumber($freighterInsuranceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($freighterInsuranceNumber) && !is_string($freighterInsuranceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freighterInsuranceNumber, true), gettype($freighterInsuranceNumber)), __LINE__);
        }
        if (is_null($freighterInsuranceNumber) || (is_array($freighterInsuranceNumber) && empty($freighterInsuranceNumber))) {
            unset($this->FreighterInsuranceNumber);
        } else {
            $this->FreighterInsuranceNumber = $freighterInsuranceNumber;
        }
        return $this;
    }
    /**
     * Get GoodInfoList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfGoodInfo|null
     */
    public function getGoodInfoList()
    {
        return isset($this->GoodInfoList) ? $this->GoodInfoList : null;
    }
    /**
     * Set GoodInfoList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfGoodInfo $goodInfoList
     * @return \StructType\BillOfLading
     */
    public function setGoodInfoList(\ArrayType\ArrayOfGoodInfo $goodInfoList = null)
    {
        if (is_null($goodInfoList) || (is_array($goodInfoList) && empty($goodInfoList))) {
            unset($this->GoodInfoList);
        } else {
            $this->GoodInfoList = $goodInfoList;
        }
        return $this;
    }
    /**
     * Get HavalehTraceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHavalehTraceCode()
    {
        return isset($this->HavalehTraceCode) ? $this->HavalehTraceCode : null;
    }
    /**
     * Set HavalehTraceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $havalehTraceCode
     * @return \StructType\BillOfLading
     */
    public function setHavalehTraceCode($havalehTraceCode = null)
    {
        // validation for constraint: string
        if (!is_null($havalehTraceCode) && !is_string($havalehTraceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($havalehTraceCode, true), gettype($havalehTraceCode)), __LINE__);
        }
        if (is_null($havalehTraceCode) || (is_array($havalehTraceCode) && empty($havalehTraceCode))) {
            unset($this->HavalehTraceCode);
        } else {
            $this->HavalehTraceCode = $havalehTraceCode;
        }
        return $this;
    }
    /**
     * Get InsuranceCompany value
     * @return string|null
     */
    public function getInsuranceCompany()
    {
        return $this->InsuranceCompany;
    }
    /**
     * Set InsuranceCompany value
     * @uses \EnumType\InsuranceCompanyEnum::valueIsValid()
     * @uses \EnumType\InsuranceCompanyEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insuranceCompany
     * @return \StructType\BillOfLading
     */
    public function setInsuranceCompany($insuranceCompany = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InsuranceCompanyEnum::valueIsValid($insuranceCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InsuranceCompanyEnum', is_array($insuranceCompany) ? implode(', ', $insuranceCompany) : var_export($insuranceCompany, true), implode(', ', \EnumType\InsuranceCompanyEnum::getValidValues())), __LINE__);
        }
        $this->InsuranceCompany = $insuranceCompany;
        return $this;
    }
    /**
     * Get InsuranceCost value
     * @return int|null
     */
    public function getInsuranceCost()
    {
        return $this->InsuranceCost;
    }
    /**
     * Set InsuranceCost value
     * @param int $insuranceCost
     * @return \StructType\BillOfLading
     */
    public function setInsuranceCost($insuranceCost = null)
    {
        // validation for constraint: int
        if (!is_null($insuranceCost) && !(is_int($insuranceCost) || ctype_digit($insuranceCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insuranceCost, true), gettype($insuranceCost)), __LINE__);
        }
        $this->InsuranceCost = $insuranceCost;
        return $this;
    }
    /**
     * Get InsuranceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsuranceNumber()
    {
        return isset($this->InsuranceNumber) ? $this->InsuranceNumber : null;
    }
    /**
     * Set InsuranceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $insuranceNumber
     * @return \StructType\BillOfLading
     */
    public function setInsuranceNumber($insuranceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceNumber) && !is_string($insuranceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insuranceNumber, true), gettype($insuranceNumber)), __LINE__);
        }
        if (is_null($insuranceNumber) || (is_array($insuranceNumber) && empty($insuranceNumber))) {
            unset($this->InsuranceNumber);
        } else {
            $this->InsuranceNumber = $insuranceNumber;
        }
        return $this;
    }
    /**
     * Get InsuranceTax value
     * @return float|null
     */
    public function getInsuranceTax()
    {
        return $this->InsuranceTax;
    }
    /**
     * Set InsuranceTax value
     * @param float $insuranceTax
     * @return \StructType\BillOfLading
     */
    public function setInsuranceTax($insuranceTax = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceTax) && !(is_float($insuranceTax) || is_numeric($insuranceTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceTax, true), gettype($insuranceTax)), __LINE__);
        }
        $this->InsuranceTax = $insuranceTax;
        return $this;
    }
    /**
     * Get InternalCargoInsuranceCompany value
     * @return string|null
     */
    public function getInternalCargoInsuranceCompany()
    {
        return $this->InternalCargoInsuranceCompany;
    }
    /**
     * Set InternalCargoInsuranceCompany value
     * @uses \EnumType\InsuranceCompanyEnum::valueIsValid()
     * @uses \EnumType\InsuranceCompanyEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $internalCargoInsuranceCompany
     * @return \StructType\BillOfLading
     */
    public function setInternalCargoInsuranceCompany($internalCargoInsuranceCompany = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InsuranceCompanyEnum::valueIsValid($internalCargoInsuranceCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InsuranceCompanyEnum', is_array($internalCargoInsuranceCompany) ? implode(', ', $internalCargoInsuranceCompany) : var_export($internalCargoInsuranceCompany, true), implode(', ', \EnumType\InsuranceCompanyEnum::getValidValues())), __LINE__);
        }
        $this->InternalCargoInsuranceCompany = $internalCargoInsuranceCompany;
        return $this;
    }
    /**
     * Get InternalCargoInsuranceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternalCargoInsuranceNumber()
    {
        return isset($this->InternalCargoInsuranceNumber) ? $this->InternalCargoInsuranceNumber : null;
    }
    /**
     * Set InternalCargoInsuranceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internalCargoInsuranceNumber
     * @return \StructType\BillOfLading
     */
    public function setInternalCargoInsuranceNumber($internalCargoInsuranceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($internalCargoInsuranceNumber) && !is_string($internalCargoInsuranceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalCargoInsuranceNumber, true), gettype($internalCargoInsuranceNumber)), __LINE__);
        }
        if (is_null($internalCargoInsuranceNumber) || (is_array($internalCargoInsuranceNumber) && empty($internalCargoInsuranceNumber))) {
            unset($this->InternalCargoInsuranceNumber);
        } else {
            $this->InternalCargoInsuranceNumber = $internalCargoInsuranceNumber;
        }
        return $this;
    }
    /**
     * Get IsReturned value
     * @return bool|null
     */
    public function getIsReturned()
    {
        return $this->IsReturned;
    }
    /**
     * Set IsReturned value
     * @param bool $isReturned
     * @return \StructType\BillOfLading
     */
    public function setIsReturned($isReturned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReturned) && !is_bool($isReturned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReturned, true), gettype($isReturned)), __LINE__);
        }
        $this->IsReturned = $isReturned;
        return $this;
    }
    /**
     * Get IsTrafficLoad value
     * @return bool|null
     */
    public function getIsTrafficLoad()
    {
        return $this->IsTrafficLoad;
    }
    /**
     * Set IsTrafficLoad value
     * @param bool $isTrafficLoad
     * @return \StructType\BillOfLading
     */
    public function setIsTrafficLoad($isTrafficLoad = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTrafficLoad) && !is_bool($isTrafficLoad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTrafficLoad, true), gettype($isTrafficLoad)), __LINE__);
        }
        $this->IsTrafficLoad = $isTrafficLoad;
        return $this;
    }
    /**
     * Get IssueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersianDate|null
     */
    public function getIssueDate()
    {
        return isset($this->IssueDate) ? $this->IssueDate : null;
    }
    /**
     * Set IssueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PersianDate $issueDate
     * @return \StructType\BillOfLading
     */
    public function setIssueDate(\StructType\PersianDate $issueDate = null)
    {
        if (is_null($issueDate) || (is_array($issueDate) && empty($issueDate))) {
            unset($this->IssueDate);
        } else {
            $this->IssueDate = $issueDate;
        }
        return $this;
    }
    /**
     * Get IssueTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssueTime()
    {
        return isset($this->IssueTime) ? $this->IssueTime : null;
    }
    /**
     * Set IssueTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issueTime
     * @return \StructType\BillOfLading
     */
    public function setIssueTime($issueTime = null)
    {
        // validation for constraint: string
        if (!is_null($issueTime) && !is_string($issueTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueTime, true), gettype($issueTime)), __LINE__);
        }
        if (is_null($issueTime) || (is_array($issueTime) && empty($issueTime))) {
            unset($this->IssueTime);
        } else {
            $this->IssueTime = $issueTime;
        }
        return $this;
    }
    /**
     * Get KalaDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKalaDesc()
    {
        return isset($this->KalaDesc) ? $this->KalaDesc : null;
    }
    /**
     * Set KalaDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kalaDesc
     * @return \StructType\BillOfLading
     */
    public function setKalaDesc($kalaDesc = null)
    {
        // validation for constraint: string
        if (!is_null($kalaDesc) && !is_string($kalaDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kalaDesc, true), gettype($kalaDesc)), __LINE__);
        }
        if (is_null($kalaDesc) || (is_array($kalaDesc) && empty($kalaDesc))) {
            unset($this->KalaDesc);
        } else {
            $this->KalaDesc = $kalaDesc;
        }
        return $this;
    }
    /**
     * Get KhordehBarList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBillOfLadingKhordehBar|null
     */
    public function getKhordehBarList()
    {
        return isset($this->KhordehBarList) ? $this->KhordehBarList : null;
    }
    /**
     * Set KhordehBarList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBillOfLadingKhordehBar $khordehBarList
     * @return \StructType\BillOfLading
     */
    public function setKhordehBarList(\ArrayType\ArrayOfBillOfLadingKhordehBar $khordehBarList = null)
    {
        if (is_null($khordehBarList) || (is_array($khordehBarList) && empty($khordehBarList))) {
            unset($this->KhordehBarList);
        } else {
            $this->KhordehBarList = $khordehBarList;
        }
        return $this;
    }
    /**
     * Get LanderTypeCode value
     * @return int|null
     */
    public function getLanderTypeCode()
    {
        return $this->LanderTypeCode;
    }
    /**
     * Set LanderTypeCode value
     * @param int $landerTypeCode
     * @return \StructType\BillOfLading
     */
    public function setLanderTypeCode($landerTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($landerTypeCode) && !(is_int($landerTypeCode) || ctype_digit($landerTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($landerTypeCode, true), gettype($landerTypeCode)), __LINE__);
        }
        $this->LanderTypeCode = $landerTypeCode;
        return $this;
    }
    /**
     * Get LicenseNumber value
     * @return int|null
     */
    public function getLicenseNumber()
    {
        return $this->LicenseNumber;
    }
    /**
     * Set LicenseNumber value
     * @param int $licenseNumber
     * @return \StructType\BillOfLading
     */
    public function setLicenseNumber($licenseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($licenseNumber) && !(is_int($licenseNumber) || ctype_digit($licenseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($licenseNumber, true), gettype($licenseNumber)), __LINE__);
        }
        $this->LicenseNumber = $licenseNumber;
        return $this;
    }
    /**
     * Get LoadingCost value
     * @return int|null
     */
    public function getLoadingCost()
    {
        return $this->LoadingCost;
    }
    /**
     * Set LoadingCost value
     * @param int $loadingCost
     * @return \StructType\BillOfLading
     */
    public function setLoadingCost($loadingCost = null)
    {
        // validation for constraint: int
        if (!is_null($loadingCost) && !(is_int($loadingCost) || ctype_digit($loadingCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loadingCost, true), gettype($loadingCost)), __LINE__);
        }
        $this->LoadingCost = $loadingCost;
        return $this;
    }
    /**
     * Get MasterBillofLadingTraceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterBillofLadingTraceCode()
    {
        return isset($this->MasterBillofLadingTraceCode) ? $this->MasterBillofLadingTraceCode : null;
    }
    /**
     * Set MasterBillofLadingTraceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterBillofLadingTraceCode
     * @return \StructType\BillOfLading
     */
    public function setMasterBillofLadingTraceCode($masterBillofLadingTraceCode = null)
    {
        // validation for constraint: string
        if (!is_null($masterBillofLadingTraceCode) && !is_string($masterBillofLadingTraceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterBillofLadingTraceCode, true), gettype($masterBillofLadingTraceCode)), __LINE__);
        }
        if (is_null($masterBillofLadingTraceCode) || (is_array($masterBillofLadingTraceCode) && empty($masterBillofLadingTraceCode))) {
            unset($this->MasterBillofLadingTraceCode);
        } else {
            $this->MasterBillofLadingTraceCode = $masterBillofLadingTraceCode;
        }
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\BillOfLading
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get OriginCityCode value
     * @return int|null
     */
    public function getOriginCityCode()
    {
        return $this->OriginCityCode;
    }
    /**
     * Set OriginCityCode value
     * @param int $originCityCode
     * @return \StructType\BillOfLading
     */
    public function setOriginCityCode($originCityCode = null)
    {
        // validation for constraint: int
        if (!is_null($originCityCode) && !(is_int($originCityCode) || ctype_digit($originCityCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originCityCode, true), gettype($originCityCode)), __LINE__);
        }
        $this->OriginCityCode = $originCityCode;
        return $this;
    }
    /**
     * Get PayanehCost value
     * @return int|null
     */
    public function getPayanehCost()
    {
        return $this->PayanehCost;
    }
    /**
     * Set PayanehCost value
     * @param int $payanehCost
     * @return \StructType\BillOfLading
     */
    public function setPayanehCost($payanehCost = null)
    {
        // validation for constraint: int
        if (!is_null($payanehCost) && !(is_int($payanehCost) || ctype_digit($payanehCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payanehCost, true), gettype($payanehCost)), __LINE__);
        }
        $this->PayanehCost = $payanehCost;
        return $this;
    }
    /**
     * Get Receiver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Person|null
     */
    public function getReceiver()
    {
        return isset($this->Receiver) ? $this->Receiver : null;
    }
    /**
     * Set Receiver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Person $receiver
     * @return \StructType\BillOfLading
     */
    public function setReceiver(\StructType\Person $receiver = null)
    {
        if (is_null($receiver) || (is_array($receiver) && empty($receiver))) {
            unset($this->Receiver);
        } else {
            $this->Receiver = $receiver;
        }
        return $this;
    }
    /**
     * Get ReceiverAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiverAddress()
    {
        return isset($this->ReceiverAddress) ? $this->ReceiverAddress : null;
    }
    /**
     * Set ReceiverAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiverAddress
     * @return \StructType\BillOfLading
     */
    public function setReceiverAddress($receiverAddress = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAddress) && !is_string($receiverAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverAddress, true), gettype($receiverAddress)), __LINE__);
        }
        if (is_null($receiverAddress) || (is_array($receiverAddress) && empty($receiverAddress))) {
            unset($this->ReceiverAddress);
        } else {
            $this->ReceiverAddress = $receiverAddress;
        }
        return $this;
    }
    /**
     * Get Robari value
     * @return bool|null
     */
    public function getRobari()
    {
        return $this->Robari;
    }
    /**
     * Set Robari value
     * @param bool $robari
     * @return \StructType\BillOfLading
     */
    public function setRobari($robari = null)
    {
        // validation for constraint: boolean
        if (!is_null($robari) && !is_bool($robari)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($robari, true), gettype($robari)), __LINE__);
        }
        $this->Robari = $robari;
        return $this;
    }
    /**
     * Get SecondDriverNationalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondDriverNationalId()
    {
        return isset($this->SecondDriverNationalId) ? $this->SecondDriverNationalId : null;
    }
    /**
     * Set SecondDriverNationalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondDriverNationalId
     * @return \StructType\BillOfLading
     */
    public function setSecondDriverNationalId($secondDriverNationalId = null)
    {
        // validation for constraint: string
        if (!is_null($secondDriverNationalId) && !is_string($secondDriverNationalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondDriverNationalId, true), gettype($secondDriverNationalId)), __LINE__);
        }
        if (is_null($secondDriverNationalId) || (is_array($secondDriverNationalId) && empty($secondDriverNationalId))) {
            unset($this->SecondDriverNationalId);
        } else {
            $this->SecondDriverNationalId = $secondDriverNationalId;
        }
        return $this;
    }
    /**
     * Get Sender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Person|null
     */
    public function getSender()
    {
        return isset($this->Sender) ? $this->Sender : null;
    }
    /**
     * Set Sender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Person $sender
     * @return \StructType\BillOfLading
     */
    public function setSender(\StructType\Person $sender = null)
    {
        if (is_null($sender) || (is_array($sender) && empty($sender))) {
            unset($this->Sender);
        } else {
            $this->Sender = $sender;
        }
        return $this;
    }
    /**
     * Get SenderAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderAddress()
    {
        return isset($this->SenderAddress) ? $this->SenderAddress : null;
    }
    /**
     * Set SenderAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderAddress
     * @return \StructType\BillOfLading
     */
    public function setSenderAddress($senderAddress = null)
    {
        // validation for constraint: string
        if (!is_null($senderAddress) && !is_string($senderAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderAddress, true), gettype($senderAddress)), __LINE__);
        }
        if (is_null($senderAddress) || (is_array($senderAddress) && empty($senderAddress))) {
            unset($this->SenderAddress);
        } else {
            $this->SenderAddress = $senderAddress;
        }
        return $this;
    }
    /**
     * Get Serial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerial()
    {
        return isset($this->Serial) ? $this->Serial : null;
    }
    /**
     * Set Serial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serial
     * @return \StructType\BillOfLading
     */
    public function setSerial($serial = null)
    {
        // validation for constraint: string
        if (!is_null($serial) && !is_string($serial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serial, true), gettype($serial)), __LINE__);
        }
        if (is_null($serial) || (is_array($serial) && empty($serial))) {
            unset($this->Serial);
        } else {
            $this->Serial = $serial;
        }
        return $this;
    }
    /**
     * Get ShomarehHavalehAnbarNaft value
     * @return int|null
     */
    public function getShomarehHavalehAnbarNaft()
    {
        return $this->ShomarehHavalehAnbarNaft;
    }
    /**
     * Set ShomarehHavalehAnbarNaft value
     * @param int $shomarehHavalehAnbarNaft
     * @return \StructType\BillOfLading
     */
    public function setShomarehHavalehAnbarNaft($shomarehHavalehAnbarNaft = null)
    {
        // validation for constraint: int
        if (!is_null($shomarehHavalehAnbarNaft) && !(is_int($shomarehHavalehAnbarNaft) || ctype_digit($shomarehHavalehAnbarNaft))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shomarehHavalehAnbarNaft, true), gettype($shomarehHavalehAnbarNaft)), __LINE__);
        }
        $this->ShomarehHavalehAnbarNaft = $shomarehHavalehAnbarNaft;
        return $this;
    }
    /**
     * Get Signature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSignature()
    {
        return isset($this->Signature) ? $this->Signature : null;
    }
    /**
     * Set Signature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $signature
     * @return \StructType\BillOfLading
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: string
        if (!is_null($signature) && !is_string($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signature, true), gettype($signature)), __LINE__);
        }
        if (is_null($signature) || (is_array($signature) && empty($signature))) {
            unset($this->Signature);
        } else {
            $this->Signature = $signature;
        }
        return $this;
    }
    /**
     * Get Tax value
     * @return int|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param int $tax
     * @return \StructType\BillOfLading
     */
    public function setTax($tax = null)
    {
        // validation for constraint: int
        if (!is_null($tax) && !(is_int($tax) || ctype_digit($tax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tax, true), gettype($tax)), __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get TotalCost value
     * @return float|null
     */
    public function getTotalCost()
    {
        return $this->TotalCost;
    }
    /**
     * Set TotalCost value
     * @param float $totalCost
     * @return \StructType\BillOfLading
     */
    public function setTotalCost($totalCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalCost) && !(is_float($totalCost) || is_numeric($totalCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCost, true), gettype($totalCost)), __LINE__);
        }
        $this->TotalCost = $totalCost;
        return $this;
    }
    /**
     * Get TransitTypecode value
     * @return int|null
     */
    public function getTransitTypecode()
    {
        return $this->TransitTypecode;
    }
    /**
     * Set TransitTypecode value
     * @param int $transitTypecode
     * @return \StructType\BillOfLading
     */
    public function setTransitTypecode($transitTypecode = null)
    {
        // validation for constraint: int
        if (!is_null($transitTypecode) && !(is_int($transitTypecode) || ctype_digit($transitTypecode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transitTypecode, true), gettype($transitTypecode)), __LINE__);
        }
        $this->TransitTypecode = $transitTypecode;
        return $this;
    }
    /**
     * Get WeighbridgeCost value
     * @return int|null
     */
    public function getWeighbridgeCost()
    {
        return $this->WeighbridgeCost;
    }
    /**
     * Set WeighbridgeCost value
     * @param int $weighbridgeCost
     * @return \StructType\BillOfLading
     */
    public function setWeighbridgeCost($weighbridgeCost = null)
    {
        // validation for constraint: int
        if (!is_null($weighbridgeCost) && !(is_int($weighbridgeCost) || ctype_digit($weighbridgeCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weighbridgeCost, true), gettype($weighbridgeCost)), __LINE__);
        }
        $this->WeighbridgeCost = $weighbridgeCost;
        return $this;
    }
    /**
     * Get secondDriverCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondDriverCardNumber()
    {
        return isset($this->secondDriverCardNumber) ? $this->secondDriverCardNumber : null;
    }
    /**
     * Set secondDriverCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondDriverCardNumber
     * @return \StructType\BillOfLading
     */
    public function setSecondDriverCardNumber($secondDriverCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($secondDriverCardNumber) && !is_string($secondDriverCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondDriverCardNumber, true), gettype($secondDriverCardNumber)), __LINE__);
        }
        if (is_null($secondDriverCardNumber) || (is_array($secondDriverCardNumber) && empty($secondDriverCardNumber))) {
            unset($this->secondDriverCardNumber);
        } else {
            $this->secondDriverCardNumber = $secondDriverCardNumber;
        }
        return $this;
    }
}
